/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.transform;

import xyz.janboerman.scalaloader.configurationserializable.DelegateSerialization;
import xyz.janboerman.scalaloader.configurationserializable.DeserializationMethod;
import xyz.janboerman.scalaloader.configurationserializable.InjectionPoint;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableError;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableTransformations;
import xyz.janboerman.scalaloader.configurationserializable.transform.LocalScanResult;
import xyz.janboerman.scalaloader.libs.asm.AnnotationVisitor;
import xyz.janboerman.scalaloader.libs.asm.ClassVisitor;
import xyz.janboerman.scalaloader.libs.asm.Label;
import xyz.janboerman.scalaloader.libs.asm.MethodVisitor;
import xyz.janboerman.scalaloader.libs.asm.Type;

class DelegateTransformer
extends ClassVisitor {
    private final LocalScanResult scanResult;
    private String className;
    private String classDescriptor;
    private String superType;
    private String classSignature;
    private boolean classIsInterface;
    private boolean alreadyHasDeserializeMethod;
    private boolean alreadyHasValueOfMethod;
    private boolean alreadyHasClassInitializer;
    private String serializableAs;
    private DeserializationMethod constructUsing = DeserializationMethod.DESERIALIZE;
    private InjectionPoint registerAt = InjectionPoint.PLUGIN_ONENABLE;

    DelegateTransformer(ClassVisitor delegate, LocalScanResult scanResult) {
        super(589824, delegate);
        this.scanResult = scanResult;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.scanResult.annotatedByDelegateSerialization) {
            this.className = name;
            this.classDescriptor = 'L' + name + ';';
            this.classSignature = signature;
            this.superType = superName;
            this.classIsInterface = (access & 0x200) == 512;
            access = (access | 1) & 0xFFFFFFF9;
            if (!this.scanResult.implementsConfigurationSerializable) {
                String[] newInterfaces = new String[interfaces.length + 1];
                System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
                newInterfaces[interfaces.length] = ConfigurationSerializableTransformations.BUKKIT_CONFIGURATIONSERIALIZABLE_NAME;
                interfaces = newInterfaces;
            }
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor superVisitor = super.visitAnnotation(descriptor, visible);
        if (ConfigurationSerializableTransformations.SCALALOADER_DELEGATESERIALIZATION_DESCRIPTOR.equals(descriptor)) {
            return new AnnotationVisitor(589824, superVisitor){
                boolean setAlias;
                {
                    this.setAlias = false;
                }

                @Override
                public void visit(String name, Object value) {
                    if ("as".equals(name)) {
                        DelegateTransformer.this.serializableAs = (String)value;
                        this.setAlias = true;
                    }
                    super.visit(name, value);
                }

                @Override
                public void visitEnum(String name, String descriptor, String value) {
                    if ("constructUsing".equals(name) && ConfigurationSerializableTransformations.SCALALOADER_DESERIALIZATIONMETHOD_DESCRIPTOR.equals(descriptor)) {
                        DelegateTransformer.this.constructUsing = DeserializationMethod.valueOf(value);
                        assert (DelegateTransformer.this.constructUsing != DeserializationMethod.MAP_CONSTRUCTOR) : "attempted to set DeserializationMethod MAP_CONSTRUCTOR for sum types!";
                    } else if ("registerAt".equals(name) && ConfigurationSerializableTransformations.SCALALOADER_INJECTIONPOINT_DESCRIPTOR.equals(descriptor)) {
                        DelegateTransformer.this.registerAt = InjectionPoint.valueOf(value);
                    }
                    super.visit(name, value);
                }

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    if (this.setAlias && !((DelegateTransformer)DelegateTransformer.this).scanResult.annotatedBySerializableAs) {
                        AnnotationVisitor av = DelegateTransformer.this.visitAnnotation(ConfigurationSerializableTransformations.BUKKIT_SERIALIZABLEAS_DESCRIPTOR, true);
                        av.visit("value", DelegateTransformer.this.serializableAs);
                        av.visitEnd();
                    }
                }
            };
        }
        if (ConfigurationSerializableTransformations.BUKKIT_SERIALIZABLEAS_DESCRIPTOR.equals(descriptor)) {
            return new AnnotationVisitor(589824, superVisitor){

                @Override
                public void visit(String name, Object value) {
                    if ("value".equals(name)) {
                        DelegateTransformer.this.serializableAs = (String)value;
                    }
                    super.visit(name, value);
                }
            };
        }
        return superVisitor;
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String methodDescriptor, String methodSignature, String[] exceptions) {
        if (this.scanResult.annotatedByDelegateSerialization) {
            boolean isStatic;
            boolean bl = isStatic = (access & 8) == 8;
            if (isStatic && "deserialize".equals(methodName) && ConfigurationSerializableTransformations.deserializationDescriptor(this.classDescriptor).equals(methodDescriptor)) {
                this.alreadyHasDeserializeMethod = true;
                access = (access | 1) & 0xFFFFFFF9;
            } else if (isStatic && "valueOf".equals(methodName) && ConfigurationSerializableTransformations.deserializationDescriptor(this.classDescriptor).equals(methodDescriptor)) {
                this.alreadyHasValueOfMethod = true;
                access = (access | 1) & 0xFFFFFFF9;
            } else if (isStatic && "<clinit>".equals(methodName) && "()V".equals(methodDescriptor)) {
                this.alreadyHasClassInitializer = true;
                if (this.registerAt == InjectionPoint.CLASS_INITIALIZER) {
                    return new MethodVisitor(589824, super.visitMethod(access, methodName, methodDescriptor, methodSignature, exceptions)){

                        @Override
                        public void visitCode() {
                            this.visitMethodInsn(184, DelegateTransformer.this.className, "$registerWithConfigurationSerialization", "()V", DelegateTransformer.this.classIsInterface);
                            super.visitCode();
                        }
                    };
                }
            }
        }
        return super.visitMethod(access, methodName, methodDescriptor, methodSignature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (this.scanResult.annotatedByDelegateSerialization) {
            boolean generateDeserializationMethod;
            String deserializeMethodName;
            switch (this.constructUsing) {
                case MAP_CONSTRUCTOR: {
                    throw new ConfigurationSerializableError("Can't use constructUsing " + DeserializationMethod.MAP_CONSTRUCTOR.name() + " when using the @" + DelegateSerialization.class.getSimpleName() + " annotation");
                }
                case DESERIALIZE: {
                    deserializeMethodName = "deserialize";
                    generateDeserializationMethod = !this.alreadyHasDeserializeMethod;
                    break;
                }
                case VALUE_OF: {
                    deserializeMethodName = "valueOf";
                    generateDeserializationMethod = !this.alreadyHasValueOfMethod;
                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable, got constructUsing " + DeserializationMethod.class.getSimpleName() + "." + this.constructUsing.name());
                }
            }
            if (generateDeserializationMethod) {
                MethodVisitor methodVisitor = this.visitMethod(9, deserializeMethodName, ConfigurationSerializableTransformations.deserializationDescriptor(this.classDescriptor), ConfigurationSerializableTransformations.deserializationSignature(this.classDescriptor), null);
                methodVisitor.visitParameter("map", 16);
                methodVisitor.visitCode();
                Label startLabel = new Label();
                methodVisitor.visitLabel(startLabel);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn("$variant");
                methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                methodVisitor.visitMethodInsn(184, "org/bukkit/configuration/serialization/ConfigurationSerialization", "getClassByAlias", "(Ljava/lang/String;)Ljava/lang/Class;", false);
                methodVisitor.visitMethodInsn(184, "org/bukkit/configuration/serialization/ConfigurationSerialization", "deserializeObject", "(Ljava/util/Map;Ljava/lang/Class;)Lorg/bukkit/configuration/serialization/ConfigurationSerializable;", false);
                methodVisitor.visitTypeInsn(192, this.className);
                methodVisitor.visitInsn(176);
                Label endLabel = new Label();
                methodVisitor.visitLabel(endLabel);
                methodVisitor.visitLocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", startLabel, endLabel, 0);
                methodVisitor.visitMaxs(3, 1);
                methodVisitor.visitEnd();
            }
            boolean noAlias = this.serializableAs == null || this.serializableAs.isEmpty();
            MethodVisitor methodVisitor = this.visitMethod(9, "$registerWithConfigurationSerialization", "()V", null, null);
            methodVisitor.visitCode();
            Label label0 = new Label();
            methodVisitor.visitLabel(label0);
            methodVisitor.visitLdcInsn(Type.getType(this.classDescriptor));
            if (noAlias) {
                methodVisitor.visitMethodInsn(184, "org/bukkit/configuration/serialization/ConfigurationSerialization", "registerClass", "(Ljava/lang/Class;)V", false);
            } else {
                methodVisitor.visitLdcInsn(this.serializableAs);
                methodVisitor.visitMethodInsn(184, "org/bukkit/configuration/serialization/ConfigurationSerialization", "registerClass", "(Ljava/lang/Class;Ljava/lang/String;)V", false);
            }
            Label label1 = new Label();
            methodVisitor.visitLabel(label1);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(noAlias ? 1 : 2, 0);
            methodVisitor.visitEnd();
            if (!this.alreadyHasClassInitializer && this.registerAt == InjectionPoint.CLASS_INITIALIZER) {
                MethodVisitor mvStaticInit = this.visitMethod(8, "<clinit>", "()V", null, null);
                mvStaticInit.visitCode();
                mvStaticInit.visitMethodInsn(184, this.className, "$registerWithConfigurationSerialization", "()V", this.classIsInterface);
                mvStaticInit.visitInsn(177);
                mvStaticInit.visitMaxs(0, 0);
                mvStaticInit.visitEnd();
            }
        }
        super.visitEnd();
    }
}

