/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import xyz.janboerman.scalaloader.bytecode.AsmConstants;
import xyz.janboerman.scalaloader.bytecode.LocalCounter;
import xyz.janboerman.scalaloader.bytecode.LocalVariable;
import xyz.janboerman.scalaloader.bytecode.LocalVariableTable;
import xyz.janboerman.scalaloader.bytecode.OperandStack;
import xyz.janboerman.scalaloader.bytecode.TypeSignature;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ArrayParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterizedParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.RuntimeConversions;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableTransformations;
import xyz.janboerman.scalaloader.configurationserializable.transform.ScalaConversions;
import xyz.janboerman.scalaloader.libs.asm.Label;
import xyz.janboerman.scalaloader.libs.asm.MethodVisitor;
import xyz.janboerman.scalaloader.libs.asm.Type;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;
import xyz.janboerman.scalaloader.util.Pair;

class Conversions {
    private static Map<Pair<String, ClassLoader>, Class<?>> knownCollectionClasses;
    private static Map<Pair<String, ClassLoader>, Class<?>> knownMapClasses;

    private Conversions() {
    }

    static void toSerializedType(ScalaPluginClassLoader pluginClassLoader, MethodVisitor methodVisitor, String descriptor, String signature, LocalCounter localCounter, LocalVariableTable localVariables, OperandStack operandStack) {
        TypeSignature typeSignature;
        TypeSignature typeSignature2 = typeSignature = signature != null ? TypeSignature.ofSignature(signature) : TypeSignature.ofDescriptor(descriptor);
        if (typeSignature.hasTypeArguments()) {
            if (typeSignature.isArray()) {
                Conversions.arrayToSerializedType(pluginClassLoader, methodVisitor, typeSignature, operandStack, localCounter, localVariables);
                return;
            }
            if (Conversions.isJavaUtilCollection(typeSignature, pluginClassLoader)) {
                Conversions.collectionToSerializedType(pluginClassLoader, methodVisitor, typeSignature, operandStack, localCounter, localVariables);
                return;
            }
            if (Conversions.isJavaUtilMap(typeSignature, pluginClassLoader)) {
                Conversions.mapToSerializedType(pluginClassLoader, methodVisitor, typeSignature, operandStack, localCounter, localVariables);
                return;
            }
        } else if (ScalaConversions.isScalaCollection(typeSignature, pluginClassLoader)) {
            ScalaConversions.serializeCollection(pluginClassLoader, methodVisitor, typeSignature, localCounter, localVariables, operandStack);
            return;
        }
        switch (descriptor) {
            case "B": 
            case "S": 
            case "I": {
                methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Integer_TYPE);
                break;
            }
            case "J": {
                methodVisitor.visitMethodInsn(184, "java/lang/Long", "toString", "(J)Ljava/lang/String;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                break;
            }
            case "F": {
                methodVisitor.visitInsn(141);
                operandStack.replaceTop(Type.DOUBLE_TYPE);
            }
            case "D": {
                methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Double_TYPE);
                break;
            }
            case "C": {
                methodVisitor.visitMethodInsn(184, "java/lang/Character", "toString", "(C)Ljava/lang/String;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                break;
            }
            case "Z": {
                methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Boolean_TYPE);
                break;
            }
            case "Ljava/lang/Byte;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Byte");
                methodVisitor.visitMethodInsn(182, "java/lang/Byte", "intValue", "()I", false);
                methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                operandStack.replaceTop(Type.INT_TYPE);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Integer_TYPE);
                break;
            }
            case "Ljava/lang/Short;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Short");
                methodVisitor.visitMethodInsn(182, "java/lang/Short", "intValue", "()I", false);
                methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                operandStack.replaceTop(Type.INT_TYPE);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Integer_TYPE);
                break;
            }
            case "Ljava/lang/Integer;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                operandStack.replaceTop(ConfigurationSerializableTransformations.Integer_TYPE);
                break;
            }
            case "Ljava/lang/Long;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Long");
                methodVisitor.visitMethodInsn(182, "java/lang/Long", "toString", "()Ljava/lang/String;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                break;
            }
            case "Ljava/lang/Float": {
                methodVisitor.visitTypeInsn(192, "java/lang/Float");
                methodVisitor.visitMethodInsn(182, "java/lang/Float", "doubleValue", "()D", false);
                methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                operandStack.replaceTop(Type.DOUBLE_TYPE);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Double_TYPE);
                break;
            }
            case "Ljava/lang/Double;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Double");
                break;
            }
            case "Ljava/lang/Character;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Character");
                methodVisitor.visitMethodInsn(182, "java/lang/Character", "toString", "()Ljava/lang/String;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                break;
            }
            case "Ljava/lang/Boolean;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
                break;
            }
            case "Ljava/lang/Void;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Void");
                operandStack.replaceTop(ConfigurationSerializableTransformations.Void_TYPE);
                break;
            }
            case "Ljava/lang/String;": {
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                break;
            }
            case "Ljava/math/BigInteger;": {
                methodVisitor.visitTypeInsn(192, "java/math/BigInteger");
                methodVisitor.visitMethodInsn(182, "java/math/BigInteger", "toString", "()Ljava/lang/String;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                break;
            }
            case "Ljava/math/BigDecimal;": {
                methodVisitor.visitTypeInsn(192, "java/math/BigDecimal");
                methodVisitor.visitMethodInsn(182, "java/math/BigDecimal", "toString", "()Ljava/lang/String;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                break;
            }
            case "Ljava/util/UUID;": {
                methodVisitor.visitTypeInsn(192, "java/util/UUID");
                methodVisitor.visitMethodInsn(182, "java/util/UUID", "toString", "()Ljava/lang/String;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                break;
            }
            default: {
                Conversions.genParameterType(methodVisitor, typeSignature, operandStack, localCounter, localVariables);
                Conversions.genScalaPluginClassLoader(methodVisitor, pluginClassLoader, operandStack, localCounter, localVariables);
                methodVisitor.visitMethodInsn(184, Type.getType(RuntimeConversions.class).getInternalName(), "serialize", "(" + ConfigurationSerializableTransformations.OBJECT_TYPE.getDescriptor() + Type.getType(ParameterType.class).getDescriptor() + Type.getType(ScalaPluginClassLoader.class).getDescriptor() + ")" + ConfigurationSerializableTransformations.OBJECT_TYPE.getDescriptor(), false);
                operandStack.replaceTop(3, ConfigurationSerializableTransformations.OBJECT_TYPE);
            }
        }
    }

    private static void arrayToSerializedType(ScalaPluginClassLoader pluginClassLoader, MethodVisitor methodVisitor, TypeSignature arrayTypeSignature, OperandStack operandStack, LocalCounter localCounter, LocalVariableTable localVariableTable) {
        assert (arrayTypeSignature.isArray()) : "not an array";
        TypeSignature componentTypeSignature = arrayTypeSignature.getTypeArgument(0);
        Type arrayType = Type.getType(arrayTypeSignature.toDescriptor());
        Type arrayComponentType = Type.getType(componentTypeSignature.toDescriptor());
        TypeSignature serializedComponentTypeSignature = Conversions.serializedType(componentTypeSignature);
        Type serializedComponentType = Type.getType(serializedComponentTypeSignature.toDescriptor());
        Label start = new Label();
        Label end = new Label();
        methodVisitor.visitLabel(start);
        methodVisitor.visitTypeInsn(192, arrayType.getInternalName());
        operandStack.replaceTop(arrayType);
        int arrayIndex = localCounter.getSlotIndex();
        int arrayFrameIndex = localCounter.getFrameIndex();
        LocalVariable array = new LocalVariable("array", arrayTypeSignature.toDescriptor(), arrayTypeSignature.toSignature(), start, end, arrayIndex, arrayFrameIndex);
        localVariableTable.add(array);
        localCounter.add(Type.getType(arrayTypeSignature.toDescriptor()));
        methodVisitor.visitVarInsn(58, arrayIndex);
        operandStack.pop();
        int listIndex = localCounter.getSlotIndex();
        int listFrameIndex = localCounter.getFrameIndex();
        methodVisitor.visitTypeInsn(187, "java/util/ArrayList");
        operandStack.push(ConfigurationSerializableTransformations.ARRAYLIST_TYPE);
        methodVisitor.visitInsn(89);
        operandStack.push(ConfigurationSerializableTransformations.ARRAYLIST_TYPE);
        methodVisitor.visitVarInsn(25, arrayIndex);
        operandStack.push(arrayType);
        methodVisitor.visitInsn(190);
        operandStack.replaceTop(Type.INT_TYPE);
        methodVisitor.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V", false);
        operandStack.pop(2);
        LocalVariable list = new LocalVariable("list", "Ljava/util/List;", "Ljava/util/List<" + serializedComponentTypeSignature.toSignature() + ">;", start, end, listIndex, listFrameIndex);
        localVariableTable.add(list);
        localCounter.add(Type.getType(List.class));
        methodVisitor.visitVarInsn(58, listIndex);
        operandStack.pop();
        methodVisitor.visitVarInsn(25, arrayIndex);
        operandStack.push(arrayType);
        int sameArrayIndex = localCounter.getSlotIndex();
        int sameArrayFrameIndex = localCounter.getFrameIndex();
        LocalVariable sameArray = new LocalVariable("sameArray", arrayTypeSignature.toDescriptor(), arrayTypeSignature.toSignature(), start, end, sameArrayIndex, sameArrayFrameIndex);
        localVariableTable.add(sameArray);
        localCounter.add(Type.getType(arrayTypeSignature.toDescriptor()));
        methodVisitor.visitVarInsn(58, sameArrayIndex);
        operandStack.pop();
        methodVisitor.visitVarInsn(25, sameArrayIndex);
        operandStack.push(arrayType);
        methodVisitor.visitInsn(190);
        operandStack.replaceTop(Type.INT_TYPE);
        int sizeIndex = localCounter.getSlotIndex();
        int sizeFrameIndex = localCounter.getFrameIndex();
        LocalVariable size = new LocalVariable("size", "I", null, start, end, sizeIndex, sizeFrameIndex);
        localVariableTable.add(size);
        localCounter.add(Type.INT_TYPE);
        methodVisitor.visitVarInsn(54, sizeIndex);
        operandStack.pop();
        methodVisitor.visitInsn(3);
        operandStack.push(Type.INT_TYPE);
        int indexIndex = localCounter.getSlotIndex();
        int indexFrameIndex = localCounter.getFrameIndex();
        LocalVariable index = new LocalVariable("index", "I", null, start, end, indexIndex, indexFrameIndex);
        localVariableTable.add(index);
        localCounter.add(Type.INT_TYPE);
        methodVisitor.visitVarInsn(54, indexIndex);
        operandStack.pop();
        Label jumpBackTarget = new Label();
        Label endOfLoopTarget = new Label();
        methodVisitor.visitLabel(jumpBackTarget);
        Object[] localsFrame = localVariableTable.frame();
        Object[] stackFrame = operandStack.frame();
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(21, indexIndex);
        operandStack.push(Type.INT_TYPE);
        methodVisitor.visitVarInsn(21, sizeIndex);
        operandStack.push(Type.INT_TYPE);
        methodVisitor.visitJumpInsn(162, endOfLoopTarget);
        operandStack.pop(2);
        methodVisitor.visitVarInsn(25, sameArrayIndex);
        operandStack.push(arrayType);
        methodVisitor.visitVarInsn(21, indexIndex);
        operandStack.push(Type.INT_TYPE);
        methodVisitor.visitInsn(arrayComponentType.getOpcode(46));
        operandStack.replaceTop(2, arrayComponentType);
        Label bodyStart = new Label();
        Label bodyEnd = new Label();
        methodVisitor.visitLabel(bodyStart);
        Conversions.toSerializedType(pluginClassLoader, methodVisitor, componentTypeSignature.toDescriptor(), componentTypeSignature.toSignature(), localCounter, localVariableTable, operandStack);
        methodVisitor.visitLabel(bodyEnd);
        int elementIndex = localCounter.getSlotIndex();
        int elementFrameIndex = localCounter.getFrameIndex();
        LocalVariable element = new LocalVariable("element", serializedComponentTypeSignature.toDescriptor(), serializedComponentTypeSignature.toSignature(), jumpBackTarget, endOfLoopTarget, elementIndex, elementFrameIndex);
        localVariableTable.add(element);
        localCounter.add(Type.getType(serializedComponentTypeSignature.toDescriptor()));
        methodVisitor.visitVarInsn(serializedComponentType.getOpcode(54), elementIndex);
        operandStack.pop();
        methodVisitor.visitVarInsn(25, listIndex);
        operandStack.push(ConfigurationSerializableTransformations.LIST_TYPE);
        methodVisitor.visitVarInsn(25, elementIndex);
        operandStack.push(serializedComponentType);
        methodVisitor.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
        operandStack.replaceTop(2, Type.BOOLEAN_TYPE);
        methodVisitor.visitInsn(87);
        operandStack.pop();
        methodVisitor.visitIincInsn(indexIndex, 1);
        methodVisitor.visitJumpInsn(167, jumpBackTarget);
        methodVisitor.visitLabel(endOfLoopTarget);
        localVariableTable.removeFramesFromIndex(elementFrameIndex);
        localCounter.reset(elementIndex, elementFrameIndex);
        assert (Arrays.equals(localsFrame, localVariableTable.frame())) : "local variables differ!";
        assert (Arrays.equals(stackFrame, operandStack.frame())) : "stack operands differ!";
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, listIndex);
        operandStack.push(ConfigurationSerializableTransformations.LIST_TYPE);
        methodVisitor.visitLabel(end);
        localVariableTable.removeFramesFromIndex(arrayFrameIndex);
        localCounter.reset(arrayIndex, arrayFrameIndex);
    }

    private static void collectionToSerializedType(ScalaPluginClassLoader pluginClassLoader, MethodVisitor methodVisitor, TypeSignature typeSignature, OperandStack operandStack, LocalCounter localCounter, LocalVariableTable localVariableTable) {
        String rawTypeName = typeSignature.getTypeName();
        TypeSignature elementTypeSignature = typeSignature.getTypeArgument(0);
        Label startLabel = new Label();
        Label endLabel = new Label();
        methodVisitor.visitTypeInsn(192, "java/util/Collection");
        operandStack.replaceTop(Type.getType(Collection.class));
        int oldCollectionIndex = localCounter.getSlotIndex();
        int oldCollectionFrameIndex = localCounter.getFrameIndex();
        LocalVariable oldCollection = new LocalVariable("liveCollection", "Ljava/util/Collection;", null, startLabel, endLabel, oldCollectionIndex, oldCollectionFrameIndex);
        methodVisitor.visitVarInsn(58, oldCollectionIndex);
        localVariableTable.add(oldCollection);
        localCounter.add(Type.getType(Collection.class));
        operandStack.pop();
        methodVisitor.visitLabel(startLabel);
        switch (rawTypeName) {
            case "java/util/Set": 
            case "java/util/NavigableSet": 
            case "java/util/SortedSet": 
            case "java/util/AbstractSet": 
            case "java/util/concurrent/ConcurrentHashMap$KeySetView": 
            case "java/util/concurrent/ConcurrentSkipListSet": 
            case "java/util/concurrent/CopyOnWriteArraySet": 
            case "java/util/EnumSet": 
            case "java/util/HashSet": 
            case "java/util/LinkedHashSet": 
            case "java/util/TreeSet": {
                methodVisitor.visitTypeInsn(187, "java/util/LinkedHashSet");
                operandStack.push(Type.getType(LinkedHashMap.class));
                methodVisitor.visitInsn(89);
                operandStack.push(Type.getType(LinkedHashMap.class));
                methodVisitor.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V", false);
                operandStack.pop();
                break;
            }
            default: {
                methodVisitor.visitTypeInsn(187, "java/util/ArrayList");
                operandStack.push(Type.getType(ArrayList.class));
                methodVisitor.visitInsn(89);
                operandStack.push(Type.getType(ArrayList.class));
                methodVisitor.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
                operandStack.pop();
            }
        }
        Label newCollectionLabel = new Label();
        int newCollectionIndex = localCounter.getSlotIndex();
        int newCollectionFrameIndex = localCounter.getFrameIndex();
        LocalVariable newCollection = new LocalVariable("serializedCollection", "Ljava/util/Collection;", null, newCollectionLabel, endLabel, newCollectionIndex, newCollectionFrameIndex);
        methodVisitor.visitVarInsn(58, newCollectionIndex);
        localVariableTable.add(newCollection);
        operandStack.pop();
        localCounter.add(Type.getType(Collection.class));
        methodVisitor.visitLabel(newCollectionLabel);
        Label iteratorLabel = new Label();
        methodVisitor.visitVarInsn(25, oldCollectionIndex);
        operandStack.push(Type.getType(Collection.class));
        methodVisitor.visitMethodInsn(185, "java/util/Collection", "iterator", "()Ljava/util/Iterator;", true);
        operandStack.replaceTop(Type.getType(Iterator.class));
        int iteratorIndex = localCounter.getSlotIndex();
        int iteratorFrameIndex = localCounter.getFrameIndex();
        LocalVariable iterator = new LocalVariable("iterator", "Ljava/util/Iterator;", null, iteratorLabel, endLabel, iteratorIndex, iteratorFrameIndex);
        methodVisitor.visitVarInsn(58, iteratorIndex);
        localVariableTable.add(iterator);
        operandStack.pop();
        localCounter.add(Type.getType(Iterator.class));
        methodVisitor.visitLabel(iteratorLabel);
        Label jumpBackTarget = iteratorLabel;
        Label endLoopLabel = new Label();
        Object[] localsFrame = localVariableTable.frame();
        Object[] stackFrame = operandStack.frame();
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(Type.getType(Iterator.class));
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        operandStack.replaceTop(Type.BOOLEAN_TYPE);
        methodVisitor.visitJumpInsn(153, endLoopLabel);
        operandStack.pop();
        methodVisitor.visitVarInsn(25, newCollectionIndex);
        operandStack.push(Type.getType(Collection.class));
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(Type.getType(Iterator.class));
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        Conversions.toSerializedType(pluginClassLoader, methodVisitor, elementTypeSignature.toDescriptor(), elementTypeSignature.toSignature(), localCounter, localVariableTable, operandStack);
        methodVisitor.visitMethodInsn(185, "java/util/Collection", "add", "(Ljava/lang/Object;)Z", true);
        operandStack.replaceTop(2, Type.BOOLEAN_TYPE);
        methodVisitor.visitInsn(87);
        operandStack.pop();
        methodVisitor.visitJumpInsn(167, jumpBackTarget);
        methodVisitor.visitLabel(endLoopLabel);
        localVariableTable.removeFramesFromIndex(localCounter.getFrameIndex());
        assert (Arrays.equals(localsFrame, localVariableTable.frame())) : "local variables differ!";
        assert (Arrays.equals(stackFrame, operandStack.frame())) : "stack operands differ!";
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, newCollectionIndex);
        operandStack.push(Type.getType(Collection.class));
        methodVisitor.visitLabel(endLabel);
        localVariableTable.removeFramesFromIndex(oldCollectionFrameIndex);
        localCounter.reset(oldCollectionIndex, oldCollectionFrameIndex);
    }

    private static void mapToSerializedType(ScalaPluginClassLoader pluginClassLoader, MethodVisitor methodVisitor, TypeSignature typeSignature, OperandStack operandStack, LocalCounter localCounter, LocalVariableTable localVariableTable) {
        String rawTypeName = typeSignature.getTypeName();
        TypeSignature keyTypeSignature = typeSignature.getTypeArgument(0);
        TypeSignature valueTypeSignature = typeSignature.getTypeArgument(1);
        Type keyType = Type.getObjectType(keyTypeSignature.internalName());
        Type valueType = Type.getObjectType(valueTypeSignature.internalName());
        Label startLabel = new Label();
        Label endLabel = new Label();
        methodVisitor.visitTypeInsn(192, "java/util/Map");
        operandStack.replaceTop(ConfigurationSerializableTransformations.MAP_TYPE);
        int oldMapIndex = localCounter.getSlotIndex();
        int oldMapFrameIndex = localCounter.getFrameIndex();
        LocalVariable oldMap = new LocalVariable("liveMap", "Ljava/util/Map;", null, startLabel, endLabel, oldMapIndex, oldMapFrameIndex);
        localVariableTable.add(oldMap);
        localCounter.add(Type.getType(Map.class));
        methodVisitor.visitVarInsn(58, oldMapIndex);
        operandStack.pop();
        methodVisitor.visitLabel(startLabel);
        Label newMapLabel = new Label();
        methodVisitor.visitTypeInsn(187, "java/util/LinkedHashMap");
        operandStack.push(ConfigurationSerializableTransformations.LINKEDHASHMAP_TYPE);
        methodVisitor.visitInsn(89);
        operandStack.push(ConfigurationSerializableTransformations.LINKEDHASHMAP_TYPE);
        methodVisitor.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        operandStack.pop();
        int newMapIndex = localCounter.getSlotIndex();
        int newMapFrameIndex = localCounter.getFrameIndex();
        LocalVariable newMap = new LocalVariable("serializedMap", "Ljava/util/Map;", null, newMapLabel, endLabel, newMapIndex, newMapFrameIndex);
        localVariableTable.add(newMap);
        localCounter.add(Type.getType(Map.class));
        methodVisitor.visitVarInsn(58, newMapIndex);
        operandStack.pop();
        methodVisitor.visitLabel(newMapLabel);
        Label iteratorLabel = new Label();
        methodVisitor.visitVarInsn(25, oldMapIndex);
        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "entrySet", "()Ljava/util/Set;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.SET_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.ITERATOR_TYPE);
        int iteratorIndex = localCounter.getSlotIndex();
        int iteratorFrameIndex = localCounter.getFrameIndex();
        LocalVariable iterator = new LocalVariable("iterator", "Ljava/util/Iterator;", null, iteratorLabel, endLabel, iteratorIndex, iteratorFrameIndex);
        localVariableTable.add(iterator);
        localCounter.add(Type.getType(Iterator.class));
        methodVisitor.visitVarInsn(58, iteratorIndex);
        operandStack.pop();
        methodVisitor.visitLabel(iteratorLabel);
        Label jumpBackTarget = iteratorLabel;
        Label endLoopLabel = new Label();
        Object[] localsFrame = localVariableTable.frame();
        Object[] stackFrame = operandStack.frame();
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(Type.getType(Iterator.class));
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        operandStack.replaceTop(Type.BOOLEAN_TYPE);
        methodVisitor.visitJumpInsn(153, endLoopLabel);
        operandStack.pop();
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(ConfigurationSerializableTransformations.ITERATOR_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        methodVisitor.visitTypeInsn(192, "java/util/Map$Entry");
        operandStack.replaceTop(ConfigurationSerializableTransformations.MAP$ENTRY_TYPE);
        Label entryLabel = new Label();
        int entryIndex = localCounter.getSlotIndex();
        int entryFrameIndex = localCounter.getFrameIndex();
        LocalVariable entry = new LocalVariable("entry", "Ljava/util/Map$Entry;", null, jumpBackTarget, endLoopLabel, entryIndex, entryFrameIndex);
        localVariableTable.add(entry);
        localCounter.add(Type.getType(Map.Entry.class));
        methodVisitor.visitVarInsn(58, entryIndex);
        operandStack.pop();
        methodVisitor.visitLabel(entryLabel);
        methodVisitor.visitVarInsn(25, newMapIndex);
        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
        methodVisitor.visitVarInsn(25, entryIndex);
        operandStack.push(ConfigurationSerializableTransformations.MAP$ENTRY_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getKey", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        methodVisitor.visitTypeInsn(192, keyTypeSignature.internalName());
        operandStack.replaceTop(keyType);
        Conversions.toSerializedType(pluginClassLoader, methodVisitor, keyTypeSignature.toDescriptor(), keyTypeSignature.toSignature(), localCounter, localVariableTable, operandStack);
        methodVisitor.visitVarInsn(25, entryIndex);
        operandStack.push(ConfigurationSerializableTransformations.MAP$ENTRY_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getValue", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        methodVisitor.visitTypeInsn(192, valueTypeSignature.internalName());
        operandStack.replaceTop(valueType);
        Conversions.toSerializedType(pluginClassLoader, methodVisitor, valueTypeSignature.toDescriptor(), valueTypeSignature.toSignature(), localCounter, localVariableTable, operandStack);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
        operandStack.replaceTop(3, ConfigurationSerializableTransformations.OBJECT_TYPE);
        methodVisitor.visitInsn(87);
        operandStack.pop();
        methodVisitor.visitJumpInsn(167, jumpBackTarget);
        methodVisitor.visitLabel(endLoopLabel);
        localVariableTable.removeFramesFromIndex(entryFrameIndex);
        localCounter.reset(entryIndex, entryFrameIndex);
        assert (Arrays.equals(localsFrame, localVariableTable.frame())) : "local variables differ!";
        assert (Arrays.equals(stackFrame, operandStack.frame())) : "stack operands differ!";
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, newMapIndex);
        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
        localVariableTable.removeFramesFromIndex(oldMapFrameIndex);
        localCounter.reset(oldMapIndex, oldMapFrameIndex);
        methodVisitor.visitLabel(endLabel);
    }

    private static TypeSignature serializedType(TypeSignature liveType) {
        String internalName = liveType.getTypeName();
        List<TypeSignature> typeArguments = liveType.getTypeArguments();
        if (liveType.isArray()) {
            return new TypeSignature("java/util/List", typeArguments.stream().map(Conversions::serializedType).collect(Collectors.toList()));
        }
        switch (internalName) {
            case "B": 
            case "java/lang/Byte": 
            case "S": 
            case "java/lang/Short": 
            case "I": 
            case "java/lang/Integer": {
                return new TypeSignature("java/lang/Integer", Compat.emptyList());
            }
            case "F": 
            case "java/lang/Float": 
            case "D": 
            case "java/lang/Double:": {
                return new TypeSignature("java/lang/Double", Compat.emptyList());
            }
            case "C": 
            case "java/lang/Character": 
            case "J": 
            case "java/lang/Long": {
                return new TypeSignature("java/lang/String", Compat.emptyList());
            }
            case "Z": 
            case "java/lang/Boolean": {
                return new TypeSignature("java/lang/Boolean", Compat.emptyList());
            }
            case "java/util/UUID": 
            case "java/math/BigInteger": 
            case "java/math/BigDecimal": {
                return new TypeSignature("java/lang/String", Compat.emptyList());
            }
        }
        return new TypeSignature(internalName, typeArguments.stream().map(Conversions::serializedType).collect(Collectors.toList()));
    }

    static void toLiveType(ScalaPluginClassLoader pluginClassLoader, MethodVisitor methodVisitor, String descriptor, String signature, LocalCounter localCounter, LocalVariableTable localVariables, OperandStack operandStack) {
        TypeSignature typeSignature;
        TypeSignature typeSignature2 = typeSignature = signature != null ? TypeSignature.ofSignature(signature) : TypeSignature.ofDescriptor(descriptor);
        if (typeSignature.hasTypeArguments()) {
            if (typeSignature.isArray()) {
                Conversions.arrayToLiveType(pluginClassLoader, methodVisitor, typeSignature, operandStack, localCounter, localVariables);
                return;
            }
            if (Conversions.isJavaUtilCollection(typeSignature, pluginClassLoader)) {
                Conversions.collectionToLiveType(pluginClassLoader, methodVisitor, typeSignature, operandStack, localCounter, localVariables);
                return;
            }
            if (Conversions.isJavaUtilMap(typeSignature, pluginClassLoader)) {
                Conversions.mapToLiveType(pluginClassLoader, methodVisitor, typeSignature, operandStack, localCounter, localVariables);
                return;
            }
        } else if (ScalaConversions.isScalaCollection(typeSignature, pluginClassLoader)) {
            ScalaConversions.deserializeCollection(pluginClassLoader, methodVisitor, typeSignature, localCounter, localVariables, operandStack);
            return;
        }
        switch (descriptor) {
            case "B": {
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "byteValue", "()B", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Integer_TYPE);
                operandStack.replaceTop(Type.BYTE_TYPE);
                break;
            }
            case "S": {
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "shortValue", "()S", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Integer_TYPE);
                operandStack.replaceTop(Type.SHORT_TYPE);
                break;
            }
            case "I": {
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Integer_TYPE);
                operandStack.replaceTop(Type.INT_TYPE);
                break;
            }
            case "J": {
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                methodVisitor.visitMethodInsn(184, "java/lang/Long", "parseLong", "(Ljava/lang/String;)J", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                operandStack.replaceTop(Type.LONG_TYPE);
                break;
            }
            case "F": {
                methodVisitor.visitTypeInsn(192, "java/lang/Double");
                methodVisitor.visitMethodInsn(182, "java/lang/Double", "floatValue", "()F", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Double_TYPE);
                operandStack.replaceTop(Type.FLOAT_TYPE);
                break;
            }
            case "D": {
                methodVisitor.visitTypeInsn(192, "java/lang/Double");
                methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Double_TYPE);
                operandStack.replaceTop(Type.DOUBLE_TYPE);
                break;
            }
            case "C": {
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                methodVisitor.visitInsn(3);
                methodVisitor.visitMethodInsn(182, "java/lang/String", "charAt", "(I)C", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                operandStack.push(Type.INT_TYPE);
                operandStack.replaceTop(2, Type.CHAR_TYPE);
                break;
            }
            case "Z": {
                methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
                methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Boolean_TYPE);
                operandStack.replaceTop(Type.BOOLEAN_TYPE);
                break;
            }
            case "Ljava/lang/Byte;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "byteValue", "()B", false);
                methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Integer_TYPE);
                operandStack.replaceTop(Type.BYTE_TYPE);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Byte_TYPE);
                break;
            }
            case "Ljava/lang/Short;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                methodVisitor.visitMethodInsn(182, "java/lang/Integer", "shortValue", "()S", false);
                methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Integer_TYPE);
                operandStack.replaceTop(Type.SHORT_TYPE);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Short_TYPE);
                break;
            }
            case "Ljava/lang/Integer;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Integer");
                operandStack.replaceTop(ConfigurationSerializableTransformations.Integer_TYPE);
                break;
            }
            case "Ljava/lang/Long;": {
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(Ljava/lang/String;)Ljava/lang/Long;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Long_TYPE);
                break;
            }
            case "Ljava/lang/Float;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Double");
                methodVisitor.visitMethodInsn(182, "java/lang/Double", "floatValue", "()F", false);
                methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Double_TYPE);
                operandStack.replaceTop(Type.FLOAT_TYPE);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Float_TYPE);
                break;
            }
            case "Ljava/lang/Double;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Double");
                operandStack.replaceTop(ConfigurationSerializableTransformations.Double_TYPE);
                break;
            }
            case "Ljava/lang/Character": {
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                methodVisitor.visitInsn(3);
                methodVisitor.visitMethodInsn(182, "java/lang/String", "charAt", "(I)C", false);
                methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                operandStack.push(Type.INT_TYPE);
                operandStack.replaceTop(2, Type.CHAR_TYPE);
                operandStack.replaceTop(ConfigurationSerializableTransformations.Character_TYPE);
                break;
            }
            case "Ljava/lang/Boolean;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
                operandStack.replaceTop(ConfigurationSerializableTransformations.Boolean_TYPE);
                break;
            }
            case "Ljava/lang/Void;": {
                methodVisitor.visitTypeInsn(192, "java/lang/Void");
                operandStack.replaceTop(ConfigurationSerializableTransformations.Void_TYPE);
                break;
            }
            case "Ljava/lang/String;": {
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                break;
            }
            case "Ljava/math/BigInteger;": {
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                methodVisitor.visitTypeInsn(187, "java/math/BigInteger");
                operandStack.push(ConfigurationSerializableTransformations.BIGINTEGER_TYPE);
                methodVisitor.visitInsn(90);
                operandStack.pop(2);
                operandStack.push(ConfigurationSerializableTransformations.BIGINTEGER_TYPE, ConfigurationSerializableTransformations.STRING_TYPE, ConfigurationSerializableTransformations.BIGINTEGER_TYPE);
                methodVisitor.visitInsn(95);
                operandStack.pop(2);
                operandStack.push(ConfigurationSerializableTransformations.BIGINTEGER_TYPE, ConfigurationSerializableTransformations.STRING_TYPE);
                methodVisitor.visitMethodInsn(183, "java/math/BigInteger", "<init>", "(Ljava/lang/String;)V", false);
                operandStack.pop(2);
                break;
            }
            case "Ljava/math/BigDecimal;": {
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                methodVisitor.visitTypeInsn(187, "java/math/BigDecimal");
                operandStack.push(ConfigurationSerializableTransformations.BIGDECIMAL_TYPE);
                methodVisitor.visitInsn(90);
                operandStack.pop(2);
                operandStack.push(ConfigurationSerializableTransformations.BIGDECIMAL_TYPE, ConfigurationSerializableTransformations.STRING_TYPE, ConfigurationSerializableTransformations.BIGDECIMAL_TYPE);
                methodVisitor.visitInsn(95);
                operandStack.pop(2);
                operandStack.push(ConfigurationSerializableTransformations.BIGDECIMAL_TYPE, ConfigurationSerializableTransformations.STRING_TYPE);
                methodVisitor.visitMethodInsn(183, "java/math/BigDecimal", "<init>", "(Ljava/lang/String;)V", false);
                operandStack.pop(2);
                break;
            }
            case "Ljava/util/UUID;": {
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                methodVisitor.visitMethodInsn(184, "java/util/UUID", "fromString", "(Ljava/lang/String;)Ljava/util/UUID;", false);
                operandStack.replaceTop(ConfigurationSerializableTransformations.STRING_TYPE);
                operandStack.replaceTop(ConfigurationSerializableTransformations.UUID_TYPE);
                break;
            }
            default: {
                Conversions.genParameterType(methodVisitor, typeSignature, operandStack, localCounter, localVariables);
                Conversions.genScalaPluginClassLoader(methodVisitor, pluginClassLoader, operandStack, localCounter, localVariables);
                methodVisitor.visitMethodInsn(184, Type.getType(RuntimeConversions.class).getInternalName(), "deserialize", "(" + ConfigurationSerializableTransformations.OBJECT_TYPE.getDescriptor() + Type.getType(ParameterType.class).getDescriptor() + Type.getType(ScalaPluginClassLoader.class).getDescriptor() + ")" + ConfigurationSerializableTransformations.OBJECT_TYPE.getDescriptor(), false);
                operandStack.replaceTop(3, ConfigurationSerializableTransformations.OBJECT_TYPE);
                methodVisitor.visitTypeInsn(192, typeSignature.internalName());
            }
        }
    }

    private static void arrayToLiveType(ScalaPluginClassLoader pluginClassLoader, MethodVisitor methodVisitor, TypeSignature arrayTypeSignature, OperandStack operandStack, LocalCounter localCounter, LocalVariableTable localVariableTable) {
        assert (arrayTypeSignature.isArray()) : "not an array";
        TypeSignature componentTypeSignature = arrayTypeSignature.getTypeArgument(0);
        Type arrayType = Type.getType(arrayTypeSignature.toDescriptor());
        Type componentType = Type.getType(componentTypeSignature.toDescriptor());
        TypeSignature listTypeSignature = Conversions.serializedType(arrayTypeSignature);
        Label start = new Label();
        Label end = new Label();
        methodVisitor.visitLabel(start);
        int listIndex = localCounter.getSlotIndex();
        int listFrameIndex = localCounter.getFrameIndex();
        methodVisitor.visitTypeInsn(192, "java/util/List");
        operandStack.replaceTop(ConfigurationSerializableTransformations.LIST_TYPE);
        LocalVariable list = new LocalVariable("list", "Ljava/util/List;", listTypeSignature.toSignature(), start, end, listIndex, listFrameIndex);
        localVariableTable.add(list);
        localCounter.add(Type.getType(List.class));
        methodVisitor.visitVarInsn(58, listIndex);
        operandStack.pop();
        int arrayIndex = localCounter.getSlotIndex();
        int arrayFrameIndex = localCounter.getFrameIndex();
        methodVisitor.visitVarInsn(25, listIndex);
        operandStack.push(ConfigurationSerializableTransformations.LIST_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/List", "size", "()I", true);
        operandStack.replaceTop(Type.INT_TYPE);
        Conversions.visitNewArray(arrayTypeSignature, methodVisitor);
        operandStack.replaceTop(arrayType);
        LocalVariable array = new LocalVariable("array", arrayTypeSignature.toDescriptor(), arrayTypeSignature.toSignature(), start, end, arrayIndex, arrayFrameIndex);
        localVariableTable.add(array);
        localCounter.add(Type.getType(arrayTypeSignature.toDescriptor()));
        methodVisitor.visitVarInsn(58, arrayIndex);
        operandStack.pop();
        int indexIndex = localCounter.getSlotIndex();
        int indexFrameIndex = localCounter.getFrameIndex();
        methodVisitor.visitInsn(3);
        operandStack.push(Type.INT_TYPE);
        LocalVariable index = new LocalVariable("index", "I", null, start, end, indexIndex, indexFrameIndex);
        localVariableTable.add(index);
        localCounter.add(Type.INT_TYPE);
        methodVisitor.visitVarInsn(54, indexIndex);
        operandStack.pop();
        Label jumpBackTarget = new Label();
        Label endOfLoopTarget = new Label();
        methodVisitor.visitLabel(jumpBackTarget);
        Object[] localsFrame = localVariableTable.frame();
        Object[] stackFrame = operandStack.frame();
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(21, indexIndex);
        operandStack.push(Type.INT_TYPE);
        methodVisitor.visitVarInsn(25, arrayIndex);
        operandStack.push(arrayType);
        methodVisitor.visitInsn(190);
        operandStack.replaceTop(Type.INT_TYPE);
        methodVisitor.visitJumpInsn(162, endOfLoopTarget);
        operandStack.pop(2);
        methodVisitor.visitVarInsn(25, arrayIndex);
        operandStack.push(arrayType);
        methodVisitor.visitVarInsn(21, indexIndex);
        operandStack.push(Type.INT_TYPE);
        methodVisitor.visitVarInsn(25, listIndex);
        operandStack.push(ConfigurationSerializableTransformations.LIST_TYPE);
        methodVisitor.visitVarInsn(21, indexIndex);
        operandStack.push(Type.INT_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;", true);
        operandStack.replaceTop(2, ConfigurationSerializableTransformations.OBJECT_TYPE);
        Label bodyStart = new Label();
        Label bodyEnd = new Label();
        methodVisitor.visitLabel(bodyStart);
        Conversions.toLiveType(pluginClassLoader, methodVisitor, componentTypeSignature.toDescriptor(), componentTypeSignature.toSignature(), localCounter, localVariableTable, operandStack);
        methodVisitor.visitLabel(bodyEnd);
        methodVisitor.visitInsn(componentType.getOpcode(79));
        operandStack.pop(3);
        methodVisitor.visitIincInsn(indexIndex, 1);
        methodVisitor.visitJumpInsn(167, jumpBackTarget);
        methodVisitor.visitLabel(endOfLoopTarget);
        localVariableTable.removeFramesFromIndex(localCounter.getFrameIndex());
        assert (Arrays.equals(localsFrame, localVariableTable.frame())) : "local variables differ!";
        assert (Arrays.equals(stackFrame, operandStack.frame())) : "stack operands differ!";
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, arrayIndex);
        operandStack.push(arrayType);
        methodVisitor.visitLabel(end);
        localVariableTable.removeFramesFromIndex(listFrameIndex);
        localCounter.reset(listIndex, listFrameIndex);
    }

    private static void visitNewArray(TypeSignature theArrayType, MethodVisitor mv) {
        TypeSignature ofWhat = theArrayType.getTypeArgument(0);
        switch (ofWhat.getTypeName()) {
            case "B": {
                mv.visitIntInsn(188, 8);
                break;
            }
            case "S": {
                mv.visitIntInsn(188, 9);
                break;
            }
            case "I": {
                mv.visitIntInsn(188, 10);
                break;
            }
            case "J": {
                mv.visitIntInsn(188, 11);
                break;
            }
            case "F": {
                mv.visitIntInsn(188, 6);
                break;
            }
            case "D": {
                mv.visitIntInsn(188, 7);
                break;
            }
            case "Z": {
                mv.visitIntInsn(188, 4);
                break;
            }
            case "C": {
                mv.visitIntInsn(188, 5);
                break;
            }
            default: {
                mv.visitTypeInsn(189, ofWhat.internalName());
            }
        }
    }

    private static void collectionToLiveType(ScalaPluginClassLoader pluginClassLoader, MethodVisitor methodVisitor, TypeSignature typeSignature, OperandStack operandStack, LocalCounter localCounter, LocalVariableTable localVariableTable) {
        String implementationClassName;
        String collectionTypeName;
        switch (collectionTypeName = typeSignature.getTypeName()) {
            case "java/util/concurrent/BlockingDeque": {
                implementationClassName = "java/util/concurrent/LinkedBlockingDeque";
                break;
            }
            case "java/util/concurrent/TransferQueue": {
                implementationClassName = "java/util/concurrent/LinkedTransferQueue";
                break;
            }
            case "java/util/concurrent/BlockingQueue": {
                implementationClassName = "java/util/concurrent/LinkedBlockingQueue";
                break;
            }
            case "java/util/Deque": {
                implementationClassName = "java/util/ArrayDeque";
                break;
            }
            case "java/util/Queue": {
                implementationClassName = "java/util/LinkedList";
                break;
            }
            case "java/util/SortedSet": 
            case "java/util/NavigableSet": {
                implementationClassName = "java/util/TreeSet";
                break;
            }
            case "java/util/Set": {
                implementationClassName = "java/util/LinkedHashSet";
                break;
            }
            case "java/util/List": 
            case "java/util/Collection": {
                implementationClassName = "java/util/ArrayList";
                break;
            }
            default: {
                implementationClassName = collectionTypeName;
            }
        }
        TypeSignature elementTypeSignature = typeSignature.getTypeArgument(0);
        methodVisitor.visitTypeInsn(192, "java/util/Collection");
        operandStack.replaceTop(Type.getType(Collection.class));
        Label startLabel = new Label();
        Label endLabel = new Label();
        methodVisitor.visitLabel(startLabel);
        int serializedCollectionIndex = localCounter.getSlotIndex();
        int serializedCollectionFrameIndex = localCounter.getFrameIndex();
        LocalVariable serializedCollection = new LocalVariable("serializedCollection", "Ljava/util/Collection;", null, startLabel, endLabel, serializedCollectionIndex, serializedCollectionFrameIndex);
        localVariableTable.add(serializedCollection);
        localCounter.add(Type.getType(Collection.class));
        operandStack.pop();
        methodVisitor.visitVarInsn(58, serializedCollectionIndex);
        Label liveCollectionLabel = new Label();
        methodVisitor.visitLabel(liveCollectionLabel);
        if ("java/util/EnumSet".equals(implementationClassName)) {
            methodVisitor.visitLdcInsn(Type.getType(elementTypeSignature.toDescriptor()));
            operandStack.push(Type.getType(Class.class));
            methodVisitor.visitMethodInsn(184, "java/util/EnumSet", "noneOf", "(Ljava/langClass;)Ljava/util/EnumSet;", false);
            operandStack.replaceTop(Type.getType(EnumSet.class));
        } else {
            methodVisitor.visitTypeInsn(187, implementationClassName);
            operandStack.push(Type.getObjectType(collectionTypeName));
            methodVisitor.visitInsn(89);
            operandStack.push(Type.getObjectType(collectionTypeName));
            methodVisitor.visitMethodInsn(183, implementationClassName, "<init>", "()V", false);
            operandStack.pop();
        }
        int liveCollectionIndex = localCounter.getSlotIndex();
        int liveCollectionFrameIndex = localCounter.getFrameIndex();
        LocalVariable liveCollection = new LocalVariable("liveCollection", typeSignature.toDescriptor(), typeSignature.toSignature(), liveCollectionLabel, endLabel, liveCollectionIndex, liveCollectionFrameIndex);
        localVariableTable.add(liveCollection);
        localCounter.add(Type.getType(typeSignature.toDescriptor()));
        operandStack.pop();
        methodVisitor.visitVarInsn(58, liveCollectionIndex);
        Label iteratorLabel = new Label();
        methodVisitor.visitLabel(iteratorLabel);
        methodVisitor.visitVarInsn(25, serializedCollectionIndex);
        operandStack.push(Type.getType(Collection.class));
        methodVisitor.visitMethodInsn(185, "java/util/Collection", "iterator", "()Ljava/util/Iterator;", true);
        operandStack.replaceTop(Type.getType(Iterator.class));
        int iteratorIndex = localCounter.getSlotIndex();
        int iteratorFrameIndex = localCounter.getFrameIndex();
        LocalVariable iterator = new LocalVariable("iterator", "Ljava/util/Iterator;", null, iteratorLabel, endLabel, iteratorIndex, iteratorFrameIndex);
        localCounter.add(Type.getType(Iterator.class));
        localVariableTable.add(iterator);
        operandStack.pop();
        methodVisitor.visitVarInsn(58, iteratorIndex);
        Label jumpBackTarget = new Label();
        Label endOfLoopLabel = new Label();
        Object[] localsFrame = localVariableTable.frame();
        Object[] stackFrame = operandStack.frame();
        methodVisitor.visitLabel(jumpBackTarget);
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(Type.getType(Iterator.class));
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        operandStack.replaceTop(Type.BOOLEAN_TYPE);
        methodVisitor.visitJumpInsn(153, endOfLoopLabel);
        operandStack.pop();
        methodVisitor.visitVarInsn(25, liveCollectionIndex);
        operandStack.push(Type.getObjectType(collectionTypeName));
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(Type.getType(Iterator.class));
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        Conversions.toLiveType(pluginClassLoader, methodVisitor, elementTypeSignature.toDescriptor(), elementTypeSignature.toSignature(), localCounter, localVariableTable, operandStack);
        methodVisitor.visitMethodInsn(185, "java/util/Collection", "add", "(Ljava/lang/Object;)Z", true);
        operandStack.replaceTop(2, Type.BOOLEAN_TYPE);
        methodVisitor.visitInsn(87);
        operandStack.pop();
        methodVisitor.visitJumpInsn(167, jumpBackTarget);
        localVariableTable.removeFramesFromIndex(localCounter.getFrameIndex());
        assert (Arrays.equals(localsFrame, localVariableTable.frame())) : "local variables differ!";
        assert (Arrays.equals(stackFrame, operandStack.frame())) : "stack operands differ!";
        methodVisitor.visitLabel(endOfLoopLabel);
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, liveCollectionIndex);
        operandStack.push(Type.getObjectType(collectionTypeName));
        methodVisitor.visitLabel(endLabel);
        localVariableTable.removeFramesFromIndex(serializedCollectionFrameIndex);
        localCounter.reset(serializedCollectionIndex, serializedCollectionFrameIndex);
    }

    private static void mapToLiveType(ScalaPluginClassLoader pluginClassLoader, MethodVisitor methodVisitor, TypeSignature typeSignature, OperandStack operandStack, LocalCounter localCounter, LocalVariableTable localVariableTable) {
        String implementationClassName;
        String mapTypeName;
        switch (mapTypeName = typeSignature.getTypeName()) {
            case "java/util/Map": {
                implementationClassName = "java/util/LinkedHashMap";
                break;
            }
            case "java/util/concurrent/ConcurrentMap": {
                implementationClassName = "java/util/concurrent/ConcurrentHashMap";
                break;
            }
            case "java/util/concurrent/ConcurrentNavigableMap": {
                implementationClassName = "java/util/concurrent/ConcurrentSkipListMap";
                break;
            }
            case "java/util/NavigableMap": 
            case "java/util/SortedMap": {
                implementationClassName = "java/util/TreeMap";
                break;
            }
            default: {
                implementationClassName = mapTypeName;
            }
        }
        TypeSignature keyTypeSignature = typeSignature.getTypeArgument(0);
        TypeSignature valueTypeSignature = typeSignature.getTypeArgument(1);
        Type keyType = Type.getObjectType(keyTypeSignature.internalName());
        Type valueType = Type.getObjectType(valueTypeSignature.internalName());
        methodVisitor.visitTypeInsn(192, "java/util/Map");
        operandStack.replaceTop(ConfigurationSerializableTransformations.MAP_TYPE);
        Label startlabel = new Label();
        Label endLabel = new Label();
        methodVisitor.visitLabel(startlabel);
        int serializedMapIndex = localCounter.getSlotIndex();
        int serializedMapFrameIndex = localCounter.getFrameIndex();
        LocalVariable serializedMap = new LocalVariable("serializedMap", "Ljava/util/Map;", null, startlabel, endLabel, serializedMapIndex, serializedMapFrameIndex);
        localVariableTable.add(serializedMap);
        localCounter.add(Type.getType(Map.class));
        methodVisitor.visitVarInsn(58, serializedMapIndex);
        operandStack.pop();
        Label liveMapLabel = new Label();
        methodVisitor.visitLabel(liveMapLabel);
        if ("java/util/EnumMap".equals(implementationClassName)) {
            methodVisitor.visitTypeInsn(187, "java/util/EnumMap");
            operandStack.push(Type.getType(EnumMap.class));
            methodVisitor.visitInsn(89);
            operandStack.push(Type.getType(EnumMap.class));
            methodVisitor.visitLdcInsn(keyType);
            operandStack.push(keyType);
            methodVisitor.visitMethodInsn(183, "java/util/EnumMap", "<init>", "(Ljava/lang/Class;)V", false);
            operandStack.pop(2);
        } else {
            methodVisitor.visitTypeInsn(187, implementationClassName);
            operandStack.push(Type.getObjectType(implementationClassName));
            methodVisitor.visitInsn(89);
            operandStack.push(Type.getObjectType(implementationClassName));
            methodVisitor.visitMethodInsn(183, implementationClassName, "<init>", "()V", false);
            operandStack.pop();
        }
        int liveMapIndex = localCounter.getSlotIndex();
        int liveMapFrameIndex = localCounter.getFrameIndex();
        LocalVariable liveMap = new LocalVariable("liveMap", "L" + implementationClassName + ";", null, liveMapLabel, endLabel, liveMapIndex, liveMapFrameIndex);
        localVariableTable.add(liveMap);
        localCounter.add(Type.getObjectType(implementationClassName));
        methodVisitor.visitVarInsn(58, liveMapIndex);
        operandStack.pop();
        Label iteratorLabel = new Label();
        methodVisitor.visitLabel(iteratorLabel);
        methodVisitor.visitVarInsn(25, serializedMapIndex);
        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "entrySet", "()Ljava/util/Set;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.SET_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.ITERATOR_TYPE);
        int iteratorIndex = localCounter.getSlotIndex();
        int iteratorFrameIndex = localCounter.getFrameIndex();
        LocalVariable iterator = new LocalVariable("iterator", "Ljava/util/Iterator;", null, iteratorLabel, endLabel, iteratorIndex, iteratorFrameIndex);
        localVariableTable.add(iterator);
        localCounter.add(Type.getType(Iterator.class));
        methodVisitor.visitVarInsn(58, iteratorIndex);
        operandStack.pop();
        Label jumpBackTarget = new Label();
        Label endOfLoopLabel = new Label();
        Object[] localsFrame = localVariableTable.frame();
        Object[] stackFrame = operandStack.frame();
        methodVisitor.visitLabel(jumpBackTarget);
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(ConfigurationSerializableTransformations.ITERATOR_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        operandStack.replaceTop(Type.BOOLEAN_TYPE);
        methodVisitor.visitJumpInsn(153, endOfLoopLabel);
        operandStack.pop();
        methodVisitor.visitVarInsn(25, iteratorIndex);
        operandStack.push(ConfigurationSerializableTransformations.ITERATOR_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        methodVisitor.visitTypeInsn(192, "java/util/Map$Entry");
        operandStack.replaceTop(ConfigurationSerializableTransformations.MAP$ENTRY_TYPE);
        int entryIndex = localCounter.getSlotIndex();
        int entryFrameIndex = localCounter.getFrameIndex();
        LocalVariable entry = new LocalVariable("entry", "Ljava/util/Map$Entry;", null, jumpBackTarget, endOfLoopLabel, entryIndex, entryFrameIndex);
        localVariableTable.add(entry);
        localCounter.add(Type.getType(Map.Entry.class));
        methodVisitor.visitVarInsn(58, entryIndex);
        operandStack.pop();
        methodVisitor.visitVarInsn(25, liveMapIndex);
        operandStack.push(ConfigurationSerializableTransformations.MAP_TYPE);
        methodVisitor.visitVarInsn(25, entryIndex);
        operandStack.push(ConfigurationSerializableTransformations.MAP$ENTRY_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getKey", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        Conversions.toLiveType(pluginClassLoader, methodVisitor, keyTypeSignature.toDescriptor(), keyTypeSignature.toSignature(), localCounter, localVariableTable, operandStack);
        methodVisitor.visitVarInsn(25, entryIndex);
        operandStack.push(ConfigurationSerializableTransformations.MAP$ENTRY_TYPE);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getValue", "()Ljava/lang/Object;", true);
        operandStack.replaceTop(ConfigurationSerializableTransformations.OBJECT_TYPE);
        Conversions.toLiveType(pluginClassLoader, methodVisitor, valueTypeSignature.toDescriptor(), valueTypeSignature.toSignature(), localCounter, localVariableTable, operandStack);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
        operandStack.replaceTop(3, ConfigurationSerializableTransformations.OBJECT_TYPE);
        methodVisitor.visitInsn(87);
        operandStack.pop();
        methodVisitor.visitJumpInsn(167, jumpBackTarget);
        localVariableTable.removeFramesFromIndex(entryFrameIndex);
        localCounter.reset(entryIndex, entryFrameIndex);
        assert (Arrays.equals(localsFrame, localVariableTable.frame())) : "local variables differ!";
        assert (Arrays.equals(stackFrame, operandStack.frame())) : "stack operands differ!";
        methodVisitor.visitLabel(endOfLoopLabel);
        methodVisitor.visitFrame(0, localsFrame.length, localsFrame, stackFrame.length, stackFrame);
        methodVisitor.visitVarInsn(25, liveMapIndex);
        operandStack.push(Type.getObjectType(implementationClassName));
        methodVisitor.visitLabel(endLabel);
        localVariableTable.removeFramesFromIndex(serializedMapFrameIndex);
        localCounter.reset(serializedMapIndex, serializedMapFrameIndex);
    }

    static String boxedType(String type) {
        switch (type) {
            case "B": {
                return AsmConstants.javaLangByte_TYPE;
            }
            case "S": {
                return AsmConstants.javaLangShort_TYPE;
            }
            case "I": {
                return AsmConstants.javaLangInteger_TYPE;
            }
            case "J": {
                return AsmConstants.javaLangLong_TYPE;
            }
            case "C": {
                return AsmConstants.javaLangCharacter_TYPE;
            }
            case "F": {
                return AsmConstants.javaLangFloat_TYPE;
            }
            case "D": {
                return AsmConstants.javaLangDouble_TYPE;
            }
            case "Z": {
                return AsmConstants.javaLangBoolean_TYPE;
            }
            case "V": {
                return AsmConstants.javaLangVoid_TYPE;
            }
        }
        return type;
    }

    static String boxedDescriptor(String descriptor) {
        switch (descriptor) {
            case "B": {
                return AsmConstants.javaLangByte_DESCRIPTOR;
            }
            case "S": {
                return AsmConstants.javaLangShort_DESCRIPTOR;
            }
            case "I": {
                return AsmConstants.javaLangInteger_DESCRIPTOR;
            }
            case "J": {
                return AsmConstants.javaLangLong_DESCRIPTOR;
            }
            case "C": {
                return AsmConstants.javaLangCharacter_DESCRIPTOR;
            }
            case "F": {
                return AsmConstants.javaLangFloat_DESCRIPTOR;
            }
            case "D": {
                return AsmConstants.javaLangDouble_DESCRIPTOR;
            }
            case "Z": {
                return AsmConstants.javaLangBoolean_DESCRIPTOR;
            }
            case "V": {
                return AsmConstants.javaLangVoid_DESCRIPTOR;
            }
        }
        return descriptor;
    }

    private static boolean isJavaUtilCollection(TypeSignature typeSignature, ClassLoader pluginClassLoader) {
        Pair<String, ClassLoader> pair;
        String typeName;
        switch (typeName = typeSignature.getTypeName()) {
            case "java/util/Collection": 
            case "java/util/concurrent/BlockingQueue": 
            case "java/util/Deque": 
            case "java/util/List": 
            case "java/util/NavigableSet": 
            case "java/util/Queue": 
            case "java/util/Set": 
            case "java/util/SortedSet": 
            case "java/util/concurrent/TransferQueue": 
            case "java/util/AbstractCollection": 
            case "java/util/AbstractList": 
            case "java/util/AbstractQueue": 
            case "java/util/AbstractSequentialList": 
            case "java/util/AbstractSet": 
            case "java/util/concurrent/ArrayBlockingQueue": 
            case "java/util/ArrayDeque": 
            case "java/util/ArrayList": 
            case "java/util/concurrent/ConcurrentHashMap$KeySetView": 
            case "java/util/concurrent/ConcurrentLinkedDeque": 
            case "java/util/concurrent/ConcurrentLinkedQueue": 
            case "java/util/concurrent/ConcurrentSkipListSet": 
            case "java/util/concurrent/CopyOnWriteArrayList": 
            case "java/util/concurrent/CopyOnWriteArraySet": 
            case "java/util/concurrent/DelayQueue": 
            case "java/util/EnumSet": 
            case "java/util/HashSet": 
            case "java/util/concurrent/LinkedBlockingDeque": 
            case "java/util/concurrent/LinkedBlockingQueue": 
            case "java/util/LinkedHashSet": 
            case "java/util/LinkedList": 
            case "java/util/concurrent/LinkedTransferQueue": 
            case "java/util/concurrent/PriorityBlockingQueue": 
            case "java/util/PriorityQueue": 
            case "java/util/Stack": 
            case "java/util/concurrent/SynchronousQueue": 
            case "java/util/TreeSet": 
            case "java/util/Vector": {
                return true;
            }
        }
        if (knownCollectionClasses == null) {
            knownCollectionClasses = new HashMap();
        }
        if (knownCollectionClasses.containsKey(pair = new Pair<String, ClassLoader>(typeName, pluginClassLoader))) {
            return true;
        }
        String jvmClassName = typeName.replace('/', '.');
        try {
            Class<?> clazz = Class.forName(jvmClassName, false, pluginClassLoader);
            if (Collection.class.isAssignableFrom(clazz)) {
                knownCollectionClasses.put(pair, clazz);
                return true;
            }
        }
        catch (ClassNotFoundException tooBad) {
            NoClassDefFoundError error = new NoClassDefFoundError(jvmClassName);
            error.addSuppressed(tooBad);
            throw error;
        }
        return false;
    }

    private static boolean isJavaUtilMap(TypeSignature typeSignature, ClassLoader pluginClassLoader) {
        Pair<String, ClassLoader> pair;
        String typeName;
        switch (typeName = typeSignature.getTypeName()) {
            case "java/util/Map": 
            case "java/util/concurrent/ConcurrentMap": 
            case "java/util/concurrent/ConcurrentNavigableMap": 
            case "java/util/NavigableMap": 
            case "java/util/SortedMap": 
            case "java/util/AbstractMap": 
            case "java/util/concurrent/ConcurrentHashMap": 
            case "java/util/concurrent/ConcurrentSkipListMap": 
            case "java/util/EnumMap": 
            case "java/util/HashMap": 
            case "java/util/Hashtable": 
            case "java/util/IdentityHashMap": 
            case "java/util/LinkedHashMap": 
            case "java/util/Properties": 
            case "java/util/TreeMap": 
            case "java/util/WeakHashMap": {
                return true;
            }
        }
        if (knownMapClasses == null) {
            knownMapClasses = new HashMap();
        }
        if (knownMapClasses.containsKey(pair = new Pair<String, ClassLoader>(typeName, pluginClassLoader))) {
            return true;
        }
        String jvmClassName = typeName.replace('/', '.');
        try {
            Class<?> clazz = Class.forName(jvmClassName, false, pluginClassLoader);
            if (Map.class.isAssignableFrom(clazz)) {
                knownMapClasses.put(pair, clazz);
                return true;
            }
        }
        catch (ClassNotFoundException tooBad) {
            NoClassDefFoundError error = new NoClassDefFoundError(jvmClassName);
            error.addSuppressed(tooBad);
            throw error;
        }
        return false;
    }

    private static void genScalaPluginClassLoader(MethodVisitor methodVisitor, ScalaPluginClassLoader plugin, OperandStack operandStack, LocalCounter localCounter, LocalVariableTable localVariableTable) {
        String main = plugin.getMainClassName();
        Type mainType = Type.getType("L" + main.replace('.', '/') + ";");
        methodVisitor.visitLdcInsn(mainType);
        operandStack.push(Type.getType(Class.class));
        methodVisitor.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;", false);
        operandStack.replaceTop(Type.getType(ClassLoader.class));
        methodVisitor.visitTypeInsn(192, "xyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader");
        operandStack.replaceTop(Type.getType(ScalaPluginClassLoader.class));
    }

    private static void genParameterType(MethodVisitor methodVisitor, TypeSignature typeSignature, OperandStack operandStack, LocalCounter localCounter, LocalVariableTable localVariableTable) {
        if (typeSignature.isArray()) {
            Conversions.genParameterType(methodVisitor, typeSignature.getTypeArgument(0), operandStack, localCounter, localVariableTable);
            methodVisitor.visitInsn(3);
            operandStack.push(Type.BOOLEAN_TYPE);
            methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/ArrayParameterType", "from", "(Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Z)Lxyz/janboerman/scalaloader/configurationserializable/runtime/ArrayParameterType;", false);
            operandStack.replaceTop(2, Type.getType(ArrayParameterType.class));
        } else if (typeSignature.hasTypeArguments()) {
            methodVisitor.visitLdcInsn(Type.getObjectType(typeSignature.internalName()));
            operandStack.push(Type.getType(Class.class));
            methodVisitor.visitIntInsn(16, typeSignature.countTypeArguments());
            operandStack.push(Type.INT_TYPE);
            methodVisitor.visitTypeInsn(189, "xyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType");
            operandStack.replaceTop(Type.getType(ParameterType[].class));
            for (int i = 0; i < typeSignature.countTypeArguments(); ++i) {
                methodVisitor.visitInsn(89);
                operandStack.push(Type.getType(ParameterType[].class));
                TypeSignature typeArgument = typeSignature.getTypeArgument(i);
                methodVisitor.visitIntInsn(16, i);
                operandStack.push(Type.INT_TYPE);
                Conversions.genParameterType(methodVisitor, typeArgument, operandStack, localCounter, localVariableTable);
                methodVisitor.visitInsn(83);
                operandStack.pop(2);
            }
            methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/ParameterizedParameterType", "from", "(Ljava/lang/Class;[Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;)Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterizedParameterType;", false);
            operandStack.replaceTop(2, Type.getType(ParameterizedParameterType.class));
        } else {
            methodVisitor.visitLdcInsn(Type.getObjectType(typeSignature.internalName()));
            operandStack.push(Type.getType(Class.class));
            methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType", "from", "(Ljava/lang/reflect/Type;)Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;", false);
            operandStack.replaceTop(Type.getType(ParameterType.class));
        }
    }
}

