/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.transform;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import xyz.janboerman.scalaloader.bytecode.TransformerRegistry;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableError;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableTransformations;
import xyz.janboerman.scalaloader.configurationserializable.transform.GlobalScanResult;
import xyz.janboerman.scalaloader.libs.asm.AnnotationVisitor;
import xyz.janboerman.scalaloader.libs.asm.ClassVisitor;
import xyz.janboerman.scalaloader.libs.asm.Label;
import xyz.janboerman.scalaloader.libs.asm.MethodVisitor;
import xyz.janboerman.scalaloader.libs.asm.Type;

public class AddVariantTransformer
extends ClassVisitor {
    private String className;
    private String classDescriptor;
    private String classSignature;
    private String alias;
    private boolean isInterface;
    private String superClassName;
    private Set<String> notSerializableInterfaces;
    private boolean hasSerialize;
    private int lastLevel = -1;

    AddVariantTransformer(ClassVisitor delegate) {
        super(589824, delegate);
    }

    public static void addTo(TransformerRegistry transformerRegistry, GlobalScanResult scanResult) {
        if (scanResult.sumAlternatives != null) {
            for (Type type : scanResult.sumAlternatives) {
                String className = type.getInternalName().replace('/', '.');
                transformerRegistry.addClassTransformer(className, AddVariantTransformer::new);
            }
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.classDescriptor = 'L' + name + ';';
        this.classSignature = signature;
        this.alias = name.replace('/', '.');
        this.superClassName = superName;
        boolean bl = this.isInterface = (access & 0x200) == 512;
        if (interfaces == null) {
            this.notSerializableInterfaces = Compat.emptySet();
        } else {
            this.notSerializableInterfaces = new HashSet<String>(2);
            Collections.addAll(this.notSerializableInterfaces, interfaces);
            this.notSerializableInterfaces.remove(ConfigurationSerializableTransformations.BUKKIT_CONFIGURATIONSERIALIZABLE_NAME);
            this.notSerializableInterfaces.remove("java/io/Serializable");
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor superVisitor = super.visitAnnotation(descriptor, visible);
        if (ConfigurationSerializableTransformations.SCALALOADER_CONFIGURATIONSERIALIZABLE_DESCRIPTOR.equals(descriptor)) {
            return new AnnotationVisitor(589824, superVisitor){

                @Override
                public void visit(String name, Object value) {
                    if ("as".equals(name)) {
                        AddVariantTransformer.this.alias = (String)value;
                    }
                    super.visit(name, value);
                }
            };
        }
        if (ConfigurationSerializableTransformations.BUKKIT_SERIALIZABLEAS_DESCRIPTOR.equals(descriptor)) {
            return new AnnotationVisitor(589824, superVisitor){

                @Override
                public void visit(String name, Object value) {
                    if ("value".equals(name)) {
                        AddVariantTransformer.this.alias = (String)value;
                    }
                    super.visit(name, value);
                }
            };
        }
        if (ConfigurationSerializableTransformations.SCALALOADER_DELEGATESERIALIZATION_DESCRIPTOR.equals(descriptor)) {
            return new AnnotationVisitor(589824, superVisitor){

                @Override
                public void visit(String name, Object value) {
                    if ("value".equals(name)) {
                        AddVariantTransformer.this.alias = (String)value;
                    }
                    super.visit(name, value);
                }
            };
        }
        return superVisitor;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if ((access & 8) == 0 && "()Ljava/util/Map;".equals(descriptor) && name.endsWith("serialize")) {
            String dollarPrefix;
            this.hasSerialize = true;
            String prefix = name.substring(0, name.length() - "serialize".length());
            if (prefix.equals(dollarPrefix = Compat.stringRepeat("$", prefix.length()))) {
                this.lastLevel = Math.max(prefix.length(), this.lastLevel);
                access = (access | 2) & 0xFFFFFFFA;
                return new MethodVisitor(589824, super.visitMethod(access, '$' + name, descriptor, signature, exceptions)){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        if (opcode != 184 && AddVariantTransformer.this.className.equals(owner) && name.endsWith("serialize") && "()Ljava/util/Map;".equals(descriptor)) {
                            super.visitMethodInsn(opcode, owner, '$' + name, descriptor, isInterface);
                        } else {
                            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                        }
                    }
                };
            }
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitEnd() {
        if (this.lastLevel == -1) throw new ConfigurationSerializableError("Tried to generate a modified version of the serialize() method, but serialize() did not exist for class " + this.className.replace('/', '.'));
        MethodVisitor methodVisitor = super.visitMethod(1, "serialize", "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        methodVisitor.visitCode();
        Label startLabel = new Label();
        methodVisitor.visitLabel(startLabel);
        methodVisitor.visitTypeInsn(187, "java/util/HashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        Label mapInitializedLabel = new Label();
        methodVisitor.visitLabel(mapInitializedLabel);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        if (this.hasSerialize) {
            methodVisitor.visitMethodInsn(183, this.className, "$serialize", "()Ljava/util/Map;", this.isInterface);
        } else if (!"java/lang/Object".equals(this.superClassName)) {
            methodVisitor.visitMethodInsn(183, this.superClassName, "serialize", "()Ljava/util/Map;", false);
        } else {
            if (this.notSerializableInterfaces.isEmpty()) throw new ConfigurationSerializableError("Could not generate a call to this.serialize(). Make sure the class has got a serialize() method! Did you forget the @ConfigurationSerializable annotation?");
            String theInterface = this.notSerializableInterfaces.iterator().next();
            methodVisitor.visitMethodInsn(183, theInterface, "serialize", "()Ljava/util/Map;", true);
        }
        methodVisitor.visitMethodInsn(185, "java/util/Map", "putAll", "(Ljava/util/Map;)V", true);
        Label previousSerializeInvokedAndStoredLabel = new Label();
        methodVisitor.visitLabel(previousSerializeInvokedAndStoredLabel);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitLdcInsn("$variant");
        methodVisitor.visitLdcInsn(this.alias);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
        methodVisitor.visitInsn(87);
        Label variantStoredLabel = new Label();
        methodVisitor.visitLabel(variantStoredLabel);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        Label endLabel = new Label();
        methodVisitor.visitLabel(endLabel);
        methodVisitor.visitLocalVariable("this", this.classDescriptor, this.classSignature, startLabel, endLabel, 0);
        methodVisitor.visitLocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", mapInitializedLabel, endLabel, 1);
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
    }
}

