/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.runtime.types;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import xyz.janboerman.scalaloader.bytecode.AsmConstants;
import xyz.janboerman.scalaloader.bytecode.LocalCounter;
import xyz.janboerman.scalaloader.bytecode.LocalVariable;
import xyz.janboerman.scalaloader.bytecode.LocalVariableTable;
import xyz.janboerman.scalaloader.bytecode.OperandStack;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.configurationserializable.runtime.Adapter;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterizedParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.RuntimeConversions;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.Types;
import xyz.janboerman.scalaloader.libs.asm.AnnotationVisitor;
import xyz.janboerman.scalaloader.libs.asm.ClassWriter;
import xyz.janboerman.scalaloader.libs.asm.FieldVisitor;
import xyz.janboerman.scalaloader.libs.asm.Label;
import xyz.janboerman.scalaloader.libs.asm.MethodVisitor;
import xyz.janboerman.scalaloader.libs.asm.Opcodes;
import xyz.janboerman.scalaloader.libs.asm.Type;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;
import xyz.janboerman.scalaloader.plugin.runtime.ClassDefineResult;

public class Tuple {
    static final String TUPLE_XXL = "scala.runtime.TupleXXL";

    private Tuple() {
    }

    public static boolean isTuple(Object live) {
        if (live == null) {
            return false;
        }
        String rawTypeName = live.getClass().getName();
        for (int arity = 1; arity <= 22; ++arity) {
            if (!("scala.Tuple" + arity).equals(rawTypeName)) continue;
            return true;
        }
        return TUPLE_XXL.equals(rawTypeName);
    }

    private static int getArity(Class<?> scalaTupleClass) {
        switch (scalaTupleClass.getName()) {
            case "scala.Tuple1": {
                return 1;
            }
            case "scala.Tuple2": {
                return 2;
            }
            case "scala.Tuple3": {
                return 3;
            }
            case "scala.Tuple4": {
                return 4;
            }
            case "scala.Tuple5": {
                return 5;
            }
            case "scala.Tuple6": {
                return 6;
            }
            case "scala.Tuple7": {
                return 7;
            }
            case "scala.Tuple8": {
                return 8;
            }
            case "scala.Tuple9": {
                return 9;
            }
            case "scala.Tuple10": {
                return 10;
            }
            case "scala.Tuple11": {
                return 11;
            }
            case "scala.Tuple12": {
                return 12;
            }
            case "scala.Tuple13": {
                return 13;
            }
            case "scala.Tuple14": {
                return 14;
            }
            case "scala.Tuple15": {
                return 15;
            }
            case "scala.Tuple16": {
                return 16;
            }
            case "scala.Tuple17": {
                return 17;
            }
            case "scala.Tuple18": {
                return 18;
            }
            case "scala.Tuple19": {
                return 19;
            }
            case "scala.Tuple20": {
                return 20;
            }
            case "scala.Tuple21": {
                return 21;
            }
            case "scala.Tuple22": {
                return 22;
            }
            case "scala.runtime.TupleXXL": {
                return -1;
            }
        }
        return 0;
    }

    public static ConfigurationSerializable serialize(Object scalaTuple, ParameterType type, ScalaPluginClassLoader pluginClassLoader) {
        int arity = Tuple.getArity(scalaTuple.getClass());
        assert (arity != 0) : "Not a scala tuple";
        if (type instanceof ParameterizedParameterType || arity > 0) {
            List<ParameterType> tupleTypeArguments;
            if (type instanceof ParameterizedParameterType) {
                ParameterizedParameterType ppt = (ParameterizedParameterType)type;
                tupleTypeArguments = ppt.getTypeParameters();
            } else {
                tupleTypeArguments = Stream.generate(() -> ParameterType.from(Object.class)).limit(arity).collect(Collectors.toList());
            }
            String serializedClassName = "scala.Tuple" + arity;
            String generatedClassName = "xyz.janboerman.scalaloader.configurationserializable.runtime.types.generated." + serializedClassName;
            ClassDefineResult classDefineResult = pluginClassLoader.getOrDefineClass(generatedClassName, className -> Tuple.makeTupleN(className, tupleTypeArguments, pluginClassLoader), true);
            Class<?> wrapperClazz = classDefineResult.getClassDefinition();
            if (classDefineResult.isNew()) {
                ConfigurationSerialization.registerClass(wrapperClazz, (String)serializedClassName);
            }
            try {
                Constructor<?> constructor = wrapperClazz.getConstructor(type.getRawType());
                return (ConfigurationSerializable)constructor.newInstance(scalaTuple);
            }
            catch (Exception shouldNotOccur) {
                throw new Error("Malformed generated class", shouldNotOccur);
            }
        }
        if (TUPLE_XXL.equals(type.getRawType().getName()) || TUPLE_XXL.equals(scalaTuple.getClass().getName())) {
            String serializedClassName = TUPLE_XXL;
            String generatedClassName = "xyz.janboerman.scalaloader.configurationserializable.runtime.types.generated." + serializedClassName;
            ClassDefineResult classDefineResult = pluginClassLoader.getOrDefineClass(generatedClassName, className -> Tuple.makeTupleXXL(className, pluginClassLoader), true);
            Class<?> wrapperClazz = classDefineResult.getClassDefinition();
            if (classDefineResult.isNew()) {
                ConfigurationSerialization.registerClass(wrapperClazz, (String)serializedClassName);
            }
            try {
                Constructor<?> constructor = wrapperClazz.getConstructor(type.getRawType());
                return (ConfigurationSerializable)constructor.newInstance(scalaTuple);
            }
            catch (Exception shouldNotOccur) {
                throw new Error("Malformed generated class", shouldNotOccur);
            }
        }
        throw new RuntimeException("Could not serialize tuple: " + scalaTuple + ", of type: " + type);
    }

    private static byte[] makeTupleN(String generatedClassName, List<? extends ParameterType> tupleTypeArguments, ScalaPluginClassLoader plugin) {
        int arity = tupleTypeArguments.size();
        ClassWriter classWriter = new ClassWriter(0);
        String classNameUsingDots = generatedClassName;
        generatedClassName = generatedClassName.replace('.', '/');
        String classSignature = Tuple.classSignature(arity);
        String generatedClassDescriptor = "L" + generatedClassName + ";";
        String generatedClassSignature = "L" + generatedClassName + Tuple.typeArguments(arity) + ";";
        String tupleName = Tuple.tupleName(arity);
        String tupleNameUsingDots = tupleName.replace('/', '.');
        String tupleDescriptor = Tuple.tupleDescriptor(arity);
        String tupleSignature = Tuple.tupleSignature(arity);
        String tupleConstructorDescriptor = Tuple.tupleConstructorDescriptor(arity);
        classWriter.visit(52, 33, generatedClassName, classSignature, "java/lang/Object", new String[]{Type.getInternalName(Adapter.class)});
        classWriter.visitSource("xyz/janboerman/scalaloader/configurationserializable/runtime/types/Tuple.java", null);
        AnnotationVisitor annotationVisitor0 = classWriter.visitAnnotation("Lorg/bukkit/configuration/serialization/SerializableAs;", true);
        annotationVisitor0.visit("value", tupleNameUsingDots);
        annotationVisitor0.visitEnd();
        FieldVisitor fieldVisitor = classWriter.visitField(18, "tuple", tupleDescriptor, tupleSignature, null);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "(" + tupleDescriptor + ")V", "(" + tupleSignature + ")V", null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, generatedClassName, "tuple", tupleDescriptor);
        Label label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitInsn(177);
        Label label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, generatedClassSignature, label0, label3, 0);
        methodVisitor.visitLocalVariable("tuple", tupleDescriptor, tupleSignature, label0, label3, 1);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "getValue", "()" + tupleDescriptor, "()" + tupleSignature, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", tupleDescriptor);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, generatedClassSignature, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        OperandStack operandStack = new OperandStack();
        LocalVariableTable localVariableTable = new LocalVariableTable();
        LocalCounter localCounter = new LocalCounter();
        methodVisitor = classWriter.visitMethod(1, "serialize", "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        methodVisitor.visitCode();
        Label beginLabel = new Label();
        Label endLabel = new Label();
        methodVisitor.visitLabel(beginLabel);
        int generatedClassDescriptorIndex = localCounter.getSlotIndex();
        int generatedClassDescriptorFrameIndex = localCounter.getFrameIndex();
        LocalVariable thisVariable = new LocalVariable("this", generatedClassDescriptor, generatedClassSignature, beginLabel, endLabel, generatedClassDescriptorIndex, generatedClassDescriptorFrameIndex);
        localVariableTable.add(thisVariable);
        localCounter.add(Type.getType(generatedClassDescriptor));
        methodVisitor.visitTypeInsn(187, "java/util/HashMap");
        operandStack.push(Type.getType(HashMap.class));
        methodVisitor.visitInsn(89);
        operandStack.push(Type.getType(HashMap.class));
        methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        operandStack.pop();
        methodVisitor.visitVarInsn(58, 1);
        operandStack.pop();
        int hashMapIndex = localCounter.getSlotIndex();
        int hashMapFrameIndex = localCounter.getFrameIndex();
        LocalVariable mapVariable = new LocalVariable("map", Type.getDescriptor(HashMap.class), "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/Object;>;", beginLabel, endLabel, hashMapIndex, hashMapFrameIndex);
        localVariableTable.add(mapVariable);
        localCounter.add(Type.getType(HashMap.class));
        for (int a = 1; a <= arity; ++a) {
            methodVisitor.visitVarInsn(25, 1);
            operandStack.push(Type.getType(Map.class));
            methodVisitor.visitLdcInsn("_" + a);
            operandStack.push(Type.getType(String.class));
            methodVisitor.visitVarInsn(25, 0);
            operandStack.push(Type.getType(generatedClassDescriptor));
            methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", tupleDescriptor);
            operandStack.replaceTop(Type.getType(tupleDescriptor));
            methodVisitor.visitMethodInsn(182, tupleName, "_" + a, "()Ljava/lang/Object;", false);
            operandStack.replaceTop(Type.getType(Object.class));
            Types.genParameterType(methodVisitor, tupleTypeArguments.get(a - 1), operandStack);
            Types.genScalaPluginClassLoader(methodVisitor, plugin, operandStack);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(RuntimeConversions.class), "serialize", "(" + AsmConstants.javaLangObject_DESCRIPTOR + Type.getDescriptor(ParameterType.class) + Type.getDescriptor(ScalaPluginClassLoader.class) + ")" + AsmConstants.javaLangObject_DESCRIPTOR, false);
            operandStack.replaceTop(3, Type.getType(Object.class));
            methodVisitor.visitMethodInsn(185, Type.getInternalName(Map.class), "put", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(Object.class), Type.getType(Object.class)), true);
            operandStack.replaceTop(3, Type.getType(Object.class));
            methodVisitor.visitInsn(87);
            operandStack.pop();
        }
        Label returnLabel = new Label();
        methodVisitor.visitLabel(returnLabel);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitLabel(endLabel);
        for (LocalVariable local : localVariableTable) {
            methodVisitor.visitLocalVariable(local.name, local.descriptor, local.signature, local.startLabel, local.endLabel, local.tableSlot);
        }
        methodVisitor.visitMaxs(operandStack.maxStack(), localVariableTable.maxLocals());
        methodVisitor.visitEnd();
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        for (int a = 1; a <= arity; ++a) {
            sb.append("T" + a + ":Ljava/lang/Object;");
        }
        sb.append(">");
        sb.append("(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)");
        sb.append(generatedClassSignature);
        String deserializeSignature = sb.toString();
        OperandStack operandStack2 = new OperandStack();
        LocalVariableTable localVariableTable2 = new LocalVariableTable();
        LocalCounter localCounter2 = new LocalCounter();
        methodVisitor = classWriter.visitMethod(9, "deserialize", "(Ljava/util/Map;)" + generatedClassDescriptor, deserializeSignature, null);
        methodVisitor.visitCode();
        Label beginLabel2 = new Label();
        Label endLabel2 = new Label();
        methodVisitor.visitLabel(beginLabel2);
        int mapIndex = localCounter2.getSlotIndex();
        int mapFrameIndex = localCounter2.getFrameIndex();
        LocalVariable mapVariable2 = new LocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", beginLabel2, endLabel2, mapIndex, mapFrameIndex);
        localVariableTable2.add(mapVariable2);
        localCounter2.add(Type.getType(Map.class));
        for (int a = 1; a <= arity; ++a) {
            methodVisitor.visitVarInsn(25, 0);
            operandStack2.push(Type.getType(Map.class));
            methodVisitor.visitLdcInsn("_" + a);
            operandStack2.push(Type.getType(String.class));
            methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            operandStack2.replaceTop(2, Type.getType(Object.class));
            Types.genParameterType(methodVisitor, tupleTypeArguments.get(a - 1), operandStack2);
            Types.genScalaPluginClassLoader(methodVisitor, plugin, operandStack2);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(RuntimeConversions.class), "deserialize", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(Object.class), Type.getType(ParameterType.class), Type.getType(ScalaPluginClassLoader.class)), false);
            operandStack2.replaceTop(3, Type.getType(Object.class));
            methodVisitor.visitVarInsn(58, a);
            operandStack2.pop();
            int aIndex = localCounter2.getSlotIndex();
            int aFrameIndex = localCounter2.getFrameIndex();
            LocalVariable _variable = new LocalVariable("_" + a, "Ljava/lang/Object;", "TT" + a + ";", beginLabel2, endLabel2, aIndex, aFrameIndex);
            localVariableTable2.add(_variable);
            localCounter2.add(Type.getType(Object.class));
        }
        Label returnLabel2 = new Label();
        methodVisitor.visitLabel(returnLabel2);
        methodVisitor.visitTypeInsn(187, generatedClassName);
        operandStack2.push(Type.getType(generatedClassDescriptor));
        methodVisitor.visitInsn(89);
        operandStack2.push(Type.getType(generatedClassDescriptor));
        methodVisitor.visitTypeInsn(187, tupleName);
        operandStack2.push(Type.getObjectType(tupleName));
        methodVisitor.visitInsn(89);
        operandStack2.push(Type.getObjectType(tupleName));
        for (int a = 1; a <= arity; ++a) {
            methodVisitor.visitVarInsn(25, a);
            operandStack2.push(Type.getType(Object.class));
        }
        methodVisitor.visitMethodInsn(183, tupleName, "<init>", tupleConstructorDescriptor, false);
        operandStack2.pop(arity + 1);
        methodVisitor.visitMethodInsn(183, generatedClassName, "<init>", "(" + tupleDescriptor + ")V", false);
        operandStack2.pop(2);
        methodVisitor.visitInsn(176);
        methodVisitor.visitLabel(endLabel2);
        for (LocalVariable local : localVariableTable2) {
            methodVisitor.visitLocalVariable(local.name, local.descriptor, local.signature, local.startLabel, local.endLabel, local.tableSlot);
        }
        methodVisitor.visitMaxs(operandStack2.maxStack(), localVariableTable2.maxLocals());
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "hashCode", "()I", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", tupleDescriptor);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "hashCode", "(Ljava/lang/Object;)I", false);
        methodVisitor.visitInsn(172);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, generatedClassSignature, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        label1 = new Label();
        methodVisitor.visitJumpInsn(166, label1);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(label1);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(193, generatedClassName);
        label2 = new Label();
        methodVisitor.visitJumpInsn(154, label2);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, generatedClassName);
        methodVisitor.visitVarInsn(58, 2);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", tupleDescriptor);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", tupleDescriptor);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
        methodVisitor.visitInsn(172);
        Label label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, generatedClassSignature, label0, label4, 0);
        methodVisitor.visitLocalVariable("obj", "Ljava/lang/Object;", null, label0, label4, 1);
        methodVisitor.visitLocalVariable("that", generatedClassDescriptor, null, label3, label4, 2);
        methodVisitor.visitMaxs(2, 3);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", tupleDescriptor);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "toString", "(Ljava/lang/Object;)Ljava/lang/String;", false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, generatedClassSignature, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(4161, "getValue", "()Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()" + tupleDescriptor, false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, generatedClassSignature, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static byte[] makeTupleXXL(String generatedClassName, ScalaPluginClassLoader plugin) {
        ClassWriter classWriter = new ClassWriter(0);
        String classNameUsingDots = generatedClassName;
        generatedClassName = generatedClassName.replace('.', '/');
        String classSignature = "Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/Adapter<Lscala/runtime/TupleXXL;>;";
        String generatedClassDescriptor = "L" + generatedClassName + ";";
        classWriter.visit(52, 33, generatedClassName, "Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/Adapter<Lscala/runtime/TupleXXL;>;", "java/lang/Object", new String[]{Type.getInternalName(Adapter.class)});
        classWriter.visitSource("xyz/janboerman/scalaloader/configurationserializable/runtime/types/Tuple.java", null);
        AnnotationVisitor annotationVisitor0 = classWriter.visitAnnotation("Lorg/bukkit/configuration/serialization/SerializableAs;", true);
        annotationVisitor0.visit("value", TUPLE_XXL);
        annotationVisitor0.visitEnd();
        classWriter.visitInnerClass("java/util/Map$Entry", "java/util/Map", "Entry", 1545);
        FieldVisitor fieldVisitor = classWriter.visitField(18, "tuple", "Lscala/runtime/TupleXXL;", null, null);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "(Lscala/runtime/TupleXXL;)V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, generatedClassName, "tuple", "Lscala/runtime/TupleXXL;");
        Label label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitInsn(177);
        Label label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label3, 0);
        methodVisitor.visitLocalVariable("tuple", "Lscala/runtime/TupleXXL;", null, label0, label3, 1);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "getValue", "()Lscala/runtime/TupleXXL;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", "Lscala/runtime/TupleXXL;");
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "serialize", "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitTypeInsn(187, "java/util/LinkedHashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitInsn(4);
        methodVisitor.visitVarInsn(54, 2);
        label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(1, 2, new Object[]{"java/util/Map", Opcodes.INTEGER}, 0, null);
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", "Lscala/runtime/TupleXXL;");
        methodVisitor.visitMethodInsn(182, "scala/runtime/TupleXXL", "productArity", "()I", false);
        label3 = new Label();
        methodVisitor.visitJumpInsn(163, label3);
        Label label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(187, "java/lang/StringBuilder");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        methodVisitor.visitLdcInsn("_");
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", "Lscala/runtime/TupleXXL;");
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(100);
        methodVisitor.visitMethodInsn(182, "scala/runtime/TupleXXL", "productElement", "(I)Ljava/lang/Object;", false);
        methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType", "from", "(Ljava/lang/reflect/Type;)Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;", false);
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "serialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
        methodVisitor.visitInsn(87);
        Label label5 = new Label();
        methodVisitor.visitLabel(label5);
        methodVisitor.visitIincInsn(2, 1);
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        Label label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitLocalVariable("a", "I", null, label2, label3, 2);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label6, 0);
        methodVisitor.visitLocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", label1, label6, 1);
        methodVisitor.visitMaxs(5, 3);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(9, "deserialize", "(Ljava/util/Map;)" + generatedClassDescriptor, "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)" + generatedClassDescriptor, null);
        methodVisitor.visitCode();
        Label labelNeg1 = new Label();
        methodVisitor.visitLabel(labelNeg1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn("==");
        methodVisitor.visitMethodInsn(185, "java/util/Map", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        methodVisitor.visitInsn(87);
        Label label02 = new Label();
        methodVisitor.visitLabel(label02);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "size", "()I", true);
        methodVisitor.visitVarInsn(54, 1);
        Label label12 = new Label();
        methodVisitor.visitLabel(label12);
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitTypeInsn(189, "java/lang/Object");
        methodVisitor.visitVarInsn(58, 2);
        Label label22 = new Label();
        methodVisitor.visitLabel(label22);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "entrySet", "()Ljava/util/Set;", true);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;", true);
        methodVisitor.visitVarInsn(58, 3);
        Label label32 = new Label();
        methodVisitor.visitLabel(label32);
        methodVisitor.visitFrame(1, 3, new Object[]{Opcodes.INTEGER, "[Ljava/lang/Object;", "java/util/Iterator"}, 0, null);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        Label label42 = new Label();
        methodVisitor.visitJumpInsn(153, label42);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/util/Map$Entry");
        methodVisitor.visitVarInsn(58, 4);
        Label label52 = new Label();
        methodVisitor.visitLabel(label52);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getKey", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/lang/String");
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(182, "java/lang/String", "substring", "(I)Ljava/lang/String;", false);
        methodVisitor.visitMethodInsn(184, "java/lang/Integer", "parseInt", "(Ljava/lang/String;)I", false);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(100);
        methodVisitor.visitVarInsn(54, 5);
        Label label62 = new Label();
        methodVisitor.visitLabel(label62);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(21, 5);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getValue", "()Ljava/lang/Object;", true);
        methodVisitor.visitLdcInsn(Type.getType("Ljava/lang/Object;"));
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType", "from", "(Ljava/lang/reflect/Type;)Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;", false);
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "deserialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        methodVisitor.visitInsn(83);
        Label label7 = new Label();
        methodVisitor.visitLabel(label7);
        methodVisitor.visitJumpInsn(167, label32);
        methodVisitor.visitLabel(label42);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        methodVisitor.visitTypeInsn(187, generatedClassName);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(184, "scala/runtime/TupleXXL", "fromIArray", "([Ljava/lang/Object;)Lscala/runtime/TupleXXL;", false);
        methodVisitor.visitMethodInsn(183, generatedClassName, "<init>", "(Lscala/runtime/TupleXXL;)V", false);
        methodVisitor.visitInsn(176);
        Label label8 = new Label();
        methodVisitor.visitLabel(label8);
        methodVisitor.visitLocalVariable("index", "I", null, label62, label7, 5);
        methodVisitor.visitLocalVariable("entry", "Ljava/util/Map$Entry;", "Ljava/util/Map$Entry<Ljava/lang/String;Ljava/lang/Object;>;", label52, label7, 4);
        methodVisitor.visitLocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", label02, label8, 0);
        methodVisitor.visitLocalVariable("size", "I", null, label12, label8, 1);
        methodVisitor.visitLocalVariable("elements", "[Ljava/lang/Object;", null, label22, label8, 2);
        methodVisitor.visitMaxs(5, 6);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "hashCode", "()I", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", "Lscala/runtime/TupleXXL;");
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "hashCode", "(Ljava/lang/Object;)I", false);
        methodVisitor.visitInsn(172);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        label1 = new Label();
        methodVisitor.visitJumpInsn(166, label1);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(label1);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(193, generatedClassName);
        label2 = new Label();
        methodVisitor.visitJumpInsn(154, label2);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, generatedClassName);
        methodVisitor.visitVarInsn(58, 2);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", "Lscala/runtime/TupleXXL;");
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", "Lscala/runtime/TupleXXL;");
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
        methodVisitor.visitInsn(172);
        label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label4, 0);
        methodVisitor.visitLocalVariable("o", "Ljava/lang/Object;", null, label0, label4, 1);
        methodVisitor.visitLocalVariable("that", generatedClassDescriptor, null, label3, label4, 2);
        methodVisitor.visitMaxs(2, 3);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "tuple", "Lscala/runtime/TupleXXL;");
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "toString", "(Ljava/lang/Object;)Ljava/lang/String;", false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(4161, "getValue", "()Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()Lscala/runtime/TupleXXL;", false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static String classSignature(int arity) {
        assert (1 <= arity && arity <= 22) : "Invalid arity: " + arity;
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        for (int a = 1; a <= arity; ++a) {
            sb.append("T" + a + ":" + AsmConstants.javaLangObject_DESCRIPTOR);
        }
        sb.append(">");
        sb.append(AsmConstants.javaLangObject_DESCRIPTOR);
        sb.append("Lxyz/janboerman/scalaloader/configurationserializable/runtime/Adapter<");
        sb.append(Tuple.tupleSignature(arity));
        sb.append(">;");
        return sb.toString();
    }

    private static String tupleSignature(int arity) {
        assert (1 <= arity && arity <= 22) : "Invalid arity: " + arity;
        StringBuilder sb = new StringBuilder();
        sb.append("Lscala/Tuple" + arity + "<");
        for (int a = 1; a <= arity; ++a) {
            sb.append("TT" + a + ";");
        }
        sb.append(">;");
        return sb.toString();
    }

    private static String tupleName(int arity) {
        assert (1 <= arity && arity <= 22) : "Invalid arity: " + arity;
        return "scala/Tuple" + arity;
    }

    private static String tupleDescriptor(int arity) {
        assert (1 <= arity && arity <= 22) : "Invalid arity: " + arity;
        return "Lscala/Tuple" + arity + ";";
    }

    private static String tupleConstructorDescriptor(int arity) {
        assert (1 <= arity && arity <= 22) : "Invalid arity: " + arity;
        return "(" + Compat.stringRepeat("Ljava/lang/Object;", arity) + ")V";
    }

    private static String typeArguments(int arity) {
        assert (1 <= arity && arity <= 22) : "Invalid arity: " + arity;
        StringJoiner sj = new StringJoiner("", "<", ">");
        for (int a = 1; a <= arity; ++a) {
            sj.add("TT" + a + ";");
        }
        return sj.toString();
    }
}

