/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.runtime.types;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.IntStream;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import xyz.janboerman.scalaloader.bytecode.Called;
import xyz.janboerman.scalaloader.bytecode.LocalCounter;
import xyz.janboerman.scalaloader.bytecode.LocalVariable;
import xyz.janboerman.scalaloader.bytecode.LocalVariableTable;
import xyz.janboerman.scalaloader.bytecode.OperandStack;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.configurationserializable.runtime.Adapter;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterizedParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.Types;
import xyz.janboerman.scalaloader.libs.asm.AnnotationVisitor;
import xyz.janboerman.scalaloader.libs.asm.ClassWriter;
import xyz.janboerman.scalaloader.libs.asm.FieldVisitor;
import xyz.janboerman.scalaloader.libs.asm.Label;
import xyz.janboerman.scalaloader.libs.asm.MethodVisitor;
import xyz.janboerman.scalaloader.libs.asm.Type;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;
import xyz.janboerman.scalaloader.plugin.runtime.ClassDefineResult;

@Called
public abstract class ScalaMap
implements Adapter {
    static final String SCALA_MAP = "scala.collection.Map";
    static final String SCALA_IMMUTABLE_MAP = "scala.collection.immutable.Map";
    static final String SCALA_MUTABLE_MAP = "scala.collection.mutable.Map";

    @Called
    public ScalaMap() {
    }

    private static boolean isMapN(String mapClassName, int N) {
        return ("scala.collection.immutable.Map$Map" + N).equals(mapClassName);
    }

    private static Class<?> getScalaMapClass(ScalaPluginClassLoader plugin) throws ClassNotFoundException {
        return Class.forName(SCALA_MAP, false, plugin);
    }

    private static boolean isImmutableMap(Object live, ScalaPluginClassLoader plugin) {
        try {
            return Class.forName(SCALA_IMMUTABLE_MAP, false, plugin).isInstance(live);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isMutableMap(Object live, ScalaPluginClassLoader plugin) {
        try {
            return Class.forName(SCALA_MUTABLE_MAP, false, plugin).isInstance(live);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isMap(Object live, ScalaPluginClassLoader plugin) {
        try {
            return ScalaMap.getScalaMapClass(plugin).isInstance(live);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static ScalaMap serialize(Object live, ParameterType type, ScalaPluginClassLoader plugin) {
        assert (ScalaMap.isMap(live, plugin)) : "Not a scala.collection.Map";
        ParameterType keyType = type instanceof ParameterizedParameterType ? ((ParameterizedParameterType)type).getTypeParameter(0) : ParameterType.from(Object.class);
        ParameterType valueType = type instanceof ParameterizedParameterType ? ((ParameterizedParameterType)type).getTypeParameter(1) : ParameterType.from(Object.class);
        Class<?> ourMapClass = live.getClass();
        String alias = ourMapClass.getName();
        String generatedClassName = "xyz.janboerman.scalaloader.configurationserializable.runtime.types.generated.ScalaMap$" + alias;
        OptionalInt isMapN = IntStream.rangeClosed(1, 4).filter(N -> ScalaMap.isMapN(alias, N)).findAny();
        if (isMapN.isPresent()) {
            int N2 = isMapN.getAsInt();
            ClassDefineResult classDefineResult = plugin.getOrDefineClass(generatedClassName, name -> ScalaMap.makeMapN(N2, generatedClassName, ourMapClass, alias, keyType, valueType, plugin), true);
            Class<?> wrapperClass = classDefineResult.getClassDefinition();
            if (classDefineResult.isNew()) {
                ConfigurationSerialization.registerClass(wrapperClass, (String)alias);
            }
            try {
                Constructor<?> constructor = wrapperClass.getConstructor(ourMapClass);
                return (ScalaMap)constructor.newInstance(live);
            }
            catch (Exception shouldNotOccur) {
                throw new RuntimeException("Could not serialize scala map: " + live + ", of type: " + type, shouldNotOccur);
            }
        }
        if (ScalaMap.isImmutableMap(live, plugin)) {
            ClassDefineResult classDefineResult = plugin.getOrDefineClass(generatedClassName, name -> ScalaMap.makeImmutableMap(generatedClassName, ourMapClass, alias, keyType, valueType, plugin), true);
            Class<?> wrapperClass = classDefineResult.getClassDefinition();
            if (classDefineResult.isNew()) {
                ConfigurationSerialization.registerClass(wrapperClass, (String)alias);
            }
            try {
                Constructor<?> constructor = wrapperClass.getConstructor(ScalaMap.getScalaMapClass(plugin));
                return (ScalaMap)constructor.newInstance(live);
            }
            catch (Exception shouldNotOccur) {
                throw new RuntimeException("Could not serialize scala map: " + live + ", of type: " + type, shouldNotOccur);
            }
        }
        if (ScalaMap.isMutableMap(live, plugin)) {
            ClassDefineResult classDefineResult = plugin.getOrDefineClass(generatedClassName, name -> ScalaMap.makeMutableMap(generatedClassName, ourMapClass, alias, keyType, valueType, plugin), true);
            Class<?> wrapperClass = classDefineResult.getClassDefinition();
            if (classDefineResult.isNew()) {
                ConfigurationSerialization.registerClass(wrapperClass, (String)alias);
            }
            try {
                Constructor<?> constructor = wrapperClass.getConstructor(ScalaMap.getScalaMapClass(plugin));
                return (ScalaMap)constructor.newInstance(live);
            }
            catch (Exception shouldNotOccur) {
                throw new RuntimeException("Could not serialize scala map: " + live + ", of type: " + type, shouldNotOccur);
            }
        }
        throw new RuntimeException("Could not serialize scala map: " + live + ", of type: " + type);
    }

    private static byte[] makeImmutableMap(String generatedClassName, Class<?> theMapType, String alias, ParameterType keyType, ParameterType valueType, ScalaPluginClassLoader plugin) {
        String classNameUsingDots = generatedClassName;
        generatedClassName = generatedClassName.replace('.', '/');
        String generatedClassDescriptor = "L" + generatedClassName + ";";
        String ourMapClassName = theMapType.getName().replace('.', '/');
        String ourMapCompanionObjectName = ourMapClassName + "$";
        String ourMapCompanionObjectDescriptor = "L" + ourMapCompanionObjectName + ";";
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(52, 49, generatedClassName, null, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap", null);
        classWriter.visitSource("xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap.java", null);
        AnnotationVisitor annotationVisitor0 = classWriter.visitAnnotation("Lorg/bukkit/configuration/serialization/SerializableAs;", true);
        annotationVisitor0.visit("value", alias);
        annotationVisitor0.visitEnd();
        classWriter.visitInnerClass("java/util/Map$Entry", "java/util/Map", "Entry", 1545);
        FieldVisitor fieldVisitor = classWriter.visitField(18, "map", "Lscala/collection/Map;", null, null);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "(Lscala/collection/Map;)V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap", "<init>", "()V", false);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, generatedClassName, "map", "Lscala/collection/Map;");
        Label label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitInsn(177);
        Label label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label3, 0);
        methodVisitor.visitLocalVariable("map", "Lscala/collection/Map;", null, label0, label3, 1);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "getValue", "()Lscala/collection/Map;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "map", "Lscala/collection/Map;");
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "serialize", "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitTypeInsn(187, "java/util/LinkedHashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "map", "Lscala/collection/Map;");
        methodVisitor.visitMethodInsn(185, "scala/collection/Map", "iterator", "()Lscala/collection/Iterator;", true);
        methodVisitor.visitVarInsn(58, 2);
        label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(1, 2, new Object[]{"java/util/Map", "scala/collection/Iterator"}, 0, null);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "scala/collection/Iterator", "hasNext", "()Z", true);
        label3 = new Label();
        methodVisitor.visitJumpInsn(153, label3);
        Label label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "scala/collection/Iterator", "next", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "scala/Tuple2");
        methodVisitor.visitVarInsn(58, 3);
        Label label5 = new Label();
        methodVisitor.visitLabel(label5);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(182, "scala/Tuple2", "_1", "()Ljava/lang/Object;", false);
        Types.genParameterType(methodVisitor, keyType, new OperandStack());
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "serialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(25, 3);
        Label label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitMethodInsn(182, "scala/Tuple2", "_2", "()Ljava/lang/Object;", false);
        Types.genParameterType(methodVisitor, valueType, new OperandStack());
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "serialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        Label label7 = new Label();
        methodVisitor.visitLabel(label7);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
        methodVisitor.visitInsn(87);
        Label label8 = new Label();
        methodVisitor.visitLabel(label8);
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitLdcInsn("map");
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(184, "java/util/Collections", "singletonMap", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", false);
        methodVisitor.visitInsn(176);
        Label label9 = new Label();
        methodVisitor.visitLabel(label9);
        methodVisitor.visitLocalVariable("entry", "Lscala/Tuple2;", null, label5, label8, 3);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label9, 0);
        methodVisitor.visitLocalVariable("serialized", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/Object;Ljava/lang/Object;>;", label1, label9, 1);
        methodVisitor.visitLocalVariable("iterator", "Lscala/collection/Iterator;", null, label2, label9, 2);
        methodVisitor.visitMaxs(5, 4);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(9, "deserialize", "(Ljava/util/Map;)" + generatedClassDescriptor, "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)" + generatedClassDescriptor, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn("map");
        methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/util/Map");
        methodVisitor.visitVarInsn(58, 1);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitFieldInsn(178, ourMapCompanionObjectName, "MODULE$", ourMapCompanionObjectDescriptor);
        methodVisitor.visitMethodInsn(182, ourMapCompanionObjectName, "newBuilder", "()Lscala/collection/mutable/ReusableBuilder;", false);
        methodVisitor.visitVarInsn(58, 2);
        label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "entrySet", "()Ljava/util/Set;", true);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;", true);
        methodVisitor.visitVarInsn(58, 3);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitFrame(1, 3, new Object[]{"java/util/Map", "scala/collection/mutable/Builder", "java/util/Iterator"}, 0, null);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        label4 = new Label();
        methodVisitor.visitJumpInsn(153, label4);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/util/Map$Entry");
        methodVisitor.visitVarInsn(58, 4);
        label5 = new Label();
        methodVisitor.visitLabel(label5);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(187, "scala/Tuple2");
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 4);
        label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getKey", "()Ljava/lang/Object;", true);
        Types.genParameterType(methodVisitor, keyType, new OperandStack());
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "deserialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(25, 4);
        label7 = new Label();
        methodVisitor.visitLabel(label7);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getValue", "()Ljava/lang/Object;", true);
        Types.genParameterType(methodVisitor, valueType, new OperandStack());
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "deserialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        methodVisitor.visitMethodInsn(183, "scala/Tuple2", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", false);
        label8 = new Label();
        methodVisitor.visitLabel(label8);
        methodVisitor.visitMethodInsn(185, "scala/collection/mutable/Builder", "addOne", "(Ljava/lang/Object;)Lscala/collection/mutable/Growable;", true);
        methodVisitor.visitInsn(87);
        label9 = new Label();
        methodVisitor.visitLabel(label9);
        methodVisitor.visitJumpInsn(167, label3);
        methodVisitor.visitLabel(label4);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        methodVisitor.visitTypeInsn(187, generatedClassName);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "scala/collection/mutable/Builder", "result", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "scala/collection/Map");
        methodVisitor.visitMethodInsn(183, generatedClassName, "<init>", "(Lscala/collection/Map;)V", false);
        methodVisitor.visitInsn(176);
        Label label10 = new Label();
        methodVisitor.visitLabel(label10);
        methodVisitor.visitLocalVariable("entry", "Ljava/util/Map$Entry;", null, label5, label9, 4);
        methodVisitor.visitLocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", label0, label10, 0);
        methodVisitor.visitLocalVariable("serialized", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/Object;Ljava/lang/Object;>;", label1, label10, 1);
        methodVisitor.visitLocalVariable("builder", "Lscala/collection/mutable/Builder;", null, label2, label10, 2);
        methodVisitor.visitMaxs(7, 5);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "hashCode", "()I", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()Lscala/collection/Map;", false);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "hashCode", "(Ljava/lang/Object;)I", false);
        methodVisitor.visitInsn(172);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        label1 = new Label();
        methodVisitor.visitJumpInsn(166, label1);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(label1);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(193, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap");
        label2 = new Label();
        methodVisitor.visitJumpInsn(154, label2);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap");
        methodVisitor.visitVarInsn(58, 2);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()Lscala/collection/Map;", false);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(182, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap", "getValue", "()Ljava/lang/Object;", false);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
        methodVisitor.visitInsn(172);
        label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label4, 0);
        methodVisitor.visitLocalVariable("o", "Ljava/lang/Object;", null, label0, label4, 1);
        methodVisitor.visitLocalVariable("that", "Lxyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap;", null, label3, label4, 2);
        methodVisitor.visitMaxs(2, 3);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()Lscala/collection/Map;", false);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "toString", "(Ljava/lang/Object;)Ljava/lang/String;", false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(4161, "getValue", "()Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()Lscala/collection/Map;", false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static byte[] makeMutableMap(String generatedClassName, Class<?> theMapType, String alias, ParameterType keyType, ParameterType valueType, ScalaPluginClassLoader plugin) {
        String classNameUsingDots = generatedClassName;
        generatedClassName = generatedClassName.replace('.', '/');
        String generatedClassDescriptor = "L" + generatedClassName + ";";
        String ourMapClassName = theMapType.getName().replace('.', '/');
        String ourMapCompanionObjectName = ourMapClassName + "$";
        String ourMapCompanionObjectDescriptor = "L" + ourMapCompanionObjectName + ";";
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(52, 49, generatedClassName, null, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap", null);
        classWriter.visitSource("xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap.java", null);
        AnnotationVisitor annotationVisitor0 = classWriter.visitAnnotation("Lorg/bukkit/configuration/serialization/SerializableAs;", true);
        annotationVisitor0.visit("value", alias);
        annotationVisitor0.visitEnd();
        classWriter.visitInnerClass("java/util/Map$Entry", "java/util/Map", "Entry", 1545);
        FieldVisitor fieldVisitor = classWriter.visitField(18, "map", "Lscala/collection/Map;", null, null);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "(Lscala/collection/Map;)V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap", "<init>", "()V", false);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, generatedClassName, "map", "Lscala/collection/Map;");
        Label label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitInsn(177);
        Label label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label3, 0);
        methodVisitor.visitLocalVariable("map", "Lscala/collection/Map;", null, label0, label3, 1);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "getValue", "()Lscala/collection/Map;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "map", "Lscala/collection/Map;");
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "serialize", "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitTypeInsn(187, "java/util/LinkedHashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "map", "Lscala/collection/Map;");
        methodVisitor.visitMethodInsn(185, "scala/collection/Map", "iterator", "()Lscala/collection/Iterator;", true);
        methodVisitor.visitVarInsn(58, 2);
        label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(1, 2, new Object[]{"java/util/Map", "scala/collection/Iterator"}, 0, null);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "scala/collection/Iterator", "hasNext", "()Z", true);
        label3 = new Label();
        methodVisitor.visitJumpInsn(153, label3);
        Label label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "scala/collection/Iterator", "next", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "scala/Tuple2");
        methodVisitor.visitVarInsn(58, 3);
        Label label5 = new Label();
        methodVisitor.visitLabel(label5);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(182, "scala/Tuple2", "_1", "()Ljava/lang/Object;", false);
        Types.genParameterType(methodVisitor, keyType, new OperandStack());
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "serialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(25, 3);
        Label label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitMethodInsn(182, "scala/Tuple2", "_2", "()Ljava/lang/Object;", false);
        Types.genParameterType(methodVisitor, valueType, new OperandStack());
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "serialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        Label label7 = new Label();
        methodVisitor.visitLabel(label7);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
        methodVisitor.visitInsn(87);
        Label label8 = new Label();
        methodVisitor.visitLabel(label8);
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitLdcInsn("map");
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(184, "java/util/Collections", "singletonMap", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", false);
        methodVisitor.visitInsn(176);
        Label label9 = new Label();
        methodVisitor.visitLabel(label9);
        methodVisitor.visitLocalVariable("entry", "Lscala/Tuple2;", null, label5, label8, 3);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label9, 0);
        methodVisitor.visitLocalVariable("serialized", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/Object;Ljava/lang/Object;>;", label1, label9, 1);
        methodVisitor.visitLocalVariable("iterator", "Lscala/collection/Iterator;", null, label2, label9, 2);
        methodVisitor.visitMaxs(5, 4);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(9, "deserialize", "(Ljava/util/Map;)" + generatedClassDescriptor, "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)" + generatedClassDescriptor, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn("map");
        methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/util/Map");
        methodVisitor.visitVarInsn(58, 1);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitFieldInsn(178, ourMapCompanionObjectName, "MODULE$", ourMapCompanionObjectDescriptor);
        methodVisitor.visitMethodInsn(182, ourMapCompanionObjectName, "newBuilder", "()Lscala/collection/mutable/Builder;", false);
        methodVisitor.visitVarInsn(58, 2);
        label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "entrySet", "()Ljava/util/Set;", true);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;", true);
        methodVisitor.visitVarInsn(58, 3);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitFrame(1, 3, new Object[]{"java/util/Map", "scala/collection/mutable/Builder", "java/util/Iterator"}, 0, null);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        label4 = new Label();
        methodVisitor.visitJumpInsn(153, label4);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/util/Map$Entry");
        methodVisitor.visitVarInsn(58, 4);
        label5 = new Label();
        methodVisitor.visitLabel(label5);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(187, "scala/Tuple2");
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 4);
        label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getKey", "()Ljava/lang/Object;", true);
        Types.genParameterType(methodVisitor, keyType, new OperandStack());
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "deserialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(25, 4);
        label7 = new Label();
        methodVisitor.visitLabel(label7);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getValue", "()Ljava/lang/Object;", true);
        Types.genParameterType(methodVisitor, valueType, new OperandStack());
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "deserialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        methodVisitor.visitMethodInsn(183, "scala/Tuple2", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", false);
        label8 = new Label();
        methodVisitor.visitLabel(label8);
        methodVisitor.visitMethodInsn(185, "scala/collection/mutable/Builder", "addOne", "(Ljava/lang/Object;)Lscala/collection/mutable/Growable;", true);
        methodVisitor.visitInsn(87);
        label9 = new Label();
        methodVisitor.visitLabel(label9);
        methodVisitor.visitJumpInsn(167, label3);
        methodVisitor.visitLabel(label4);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        methodVisitor.visitTypeInsn(187, generatedClassName);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "scala/collection/mutable/Builder", "result", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "scala/collection/Map");
        methodVisitor.visitMethodInsn(183, generatedClassName, "<init>", "(Lscala/collection/Map;)V", false);
        methodVisitor.visitInsn(176);
        Label label10 = new Label();
        methodVisitor.visitLabel(label10);
        methodVisitor.visitLocalVariable("entry", "Ljava/util/Map$Entry;", null, label5, label9, 4);
        methodVisitor.visitLocalVariable("map", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", label0, label10, 0);
        methodVisitor.visitLocalVariable("serialized", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/Object;Ljava/lang/Object;>;", label1, label10, 1);
        methodVisitor.visitLocalVariable("builder", "Lscala/collection/mutable/Builder;", null, label2, label10, 2);
        methodVisitor.visitMaxs(7, 5);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "hashCode", "()I", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()Lscala/collection/Map;", false);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "hashCode", "(Ljava/lang/Object;)I", false);
        methodVisitor.visitInsn(172);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        label1 = new Label();
        methodVisitor.visitJumpInsn(166, label1);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(label1);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(193, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap");
        label2 = new Label();
        methodVisitor.visitJumpInsn(154, label2);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap");
        methodVisitor.visitVarInsn(58, 2);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()Lscala/collection/Map;", false);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(182, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap", "getValue", "()Ljava/lang/Object;", false);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
        methodVisitor.visitInsn(172);
        label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label4, 0);
        methodVisitor.visitLocalVariable("o", "Ljava/lang/Object;", null, label0, label4, 1);
        methodVisitor.visitLocalVariable("that", "Lxyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap;", null, label3, label4, 2);
        methodVisitor.visitMaxs(2, 3);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()Lscala/collection/Map;", false);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "toString", "(Ljava/lang/Object;)Ljava/lang/String;", false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(4161, "getValue", "()Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()Lscala/collection/Map;", false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static byte[] makeMapN(int N, String generatedClassName, Class<?> theMapType, String alias, ParameterType keyType, ParameterType valueType, ScalaPluginClassLoader plugin) {
        String classNameUsingDots = generatedClassName;
        generatedClassName = generatedClassName.replace('.', '/');
        String generatedClassDescriptor = "L" + generatedClassName + ";";
        String mapNClassName = theMapType.getName().replace('.', '/');
        String mapNClassDescriptor = "L" + mapNClassName + ";";
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(52, 49, generatedClassName, null, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap", null);
        classWriter.visitSource("xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap.java", null);
        AnnotationVisitor annotationVisitor0 = classWriter.visitAnnotation("Lorg/bukkit/configuration/serialization/SerializableAs;", true);
        annotationVisitor0.visit("value", alias);
        annotationVisitor0.visitEnd();
        classWriter.visitInnerClass(mapNClassName, "scala/collection/immutable/Map", "Map" + N, 25);
        classWriter.visitInnerClass("java/util/Map$Entry", "java/util/Map", "Entry", 1545);
        FieldVisitor fieldVisitor = classWriter.visitField(18, "map", mapNClassDescriptor, null, null);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "(" + mapNClassDescriptor + ")V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap", "<init>", "()V", false);
        Label label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, generatedClassName, "map", mapNClassDescriptor);
        Label label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitInsn(177);
        Label label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label3, 0);
        methodVisitor.visitLocalVariable("map", mapNClassDescriptor, null, label0, label3, 1);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "getValue", "()" + mapNClassDescriptor, null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "map", mapNClassDescriptor);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "serialize", "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitTypeInsn(187, "java/util/LinkedHashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, generatedClassName, "map", mapNClassDescriptor);
        methodVisitor.visitMethodInsn(182, mapNClassName, "iterator", "()Lscala/collection/Iterator;", false);
        methodVisitor.visitVarInsn(58, 2);
        label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(1, 2, new Object[]{"java/util/Map", "scala/collection/Iterator"}, 0, null);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "scala/collection/Iterator", "hasNext", "()Z", true);
        label3 = new Label();
        methodVisitor.visitJumpInsn(153, label3);
        Label label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "scala/collection/Iterator", "next", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "scala/Tuple2");
        methodVisitor.visitVarInsn(58, 3);
        Label label5 = new Label();
        methodVisitor.visitLabel(label5);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(182, "scala/Tuple2", "_1", "()Ljava/lang/Object;", false);
        Types.genParameterType(methodVisitor, keyType, new OperandStack());
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "serialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(25, 3);
        Label label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitMethodInsn(182, "scala/Tuple2", "_2", "()Ljava/lang/Object;", false);
        Types.genParameterType(methodVisitor, valueType, new OperandStack());
        Types.genScalaPluginClassLoader(methodVisitor, plugin, new OperandStack());
        methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "serialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
        Label label7 = new Label();
        methodVisitor.visitLabel(label7);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
        methodVisitor.visitInsn(87);
        Label label8 = new Label();
        methodVisitor.visitLabel(label8);
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitLdcInsn("map");
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(184, "java/util/Collections", "singletonMap", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;", false);
        methodVisitor.visitInsn(176);
        Label label9 = new Label();
        methodVisitor.visitLabel(label9);
        methodVisitor.visitLocalVariable("entry", "Lscala/Tuple2;", null, label5, label8, 3);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label9, 0);
        methodVisitor.visitLocalVariable("serialized", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/Object;Ljava/lang/Object;>;", label1, label9, 1);
        methodVisitor.visitLocalVariable("iterator", "Lscala/collection/Iterator;", null, label2, label9, 2);
        methodVisitor.visitMaxs(5, 4);
        methodVisitor.visitEnd();
        OperandStack operandStack = new OperandStack();
        LocalVariableTable localVariableTable = new LocalVariableTable();
        LocalCounter localCounter = new LocalCounter();
        Label startLabel = new Label();
        Label endLabel = new Label();
        int argumentMapIndex = localCounter.getSlotIndex();
        int argumentMapFrameIndex = localCounter.getFrameIndex();
        LocalVariable argumentMapVariable = new LocalVariable("map", "Ljava/util/Map;", null, startLabel, endLabel, argumentMapIndex, argumentMapFrameIndex);
        localVariableTable.add(argumentMapVariable);
        localCounter.add(Type.getType(Map.class));
        methodVisitor = classWriter.visitMethod(9, "deserialize", "(Ljava/util/Map;)" + generatedClassDescriptor, "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)" + generatedClassDescriptor, null);
        methodVisitor.visitCode();
        methodVisitor.visitLabel(startLabel);
        methodVisitor.visitVarInsn(25, argumentMapIndex);
        operandStack.push(Type.getType(Map.class));
        methodVisitor.visitLdcInsn("map");
        operandStack.push(Type.getType(Object.class));
        methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        operandStack.replaceTop(2, Type.getType(Object.class));
        methodVisitor.visitTypeInsn(192, "java/util/Map");
        operandStack.replaceTop(Type.getType(Map.class));
        int serializedMapIndex = localCounter.getSlotIndex();
        int serializedMapFrameIndex = localCounter.getFrameIndex();
        methodVisitor.visitVarInsn(58, serializedMapIndex);
        operandStack.pop();
        Label label12 = new Label();
        methodVisitor.visitLabel(label12);
        LocalVariable serializedMapVariable = new LocalVariable("serialized", "Ljava/util/Map;", null, label12, endLabel, serializedMapIndex, serializedMapFrameIndex);
        localVariableTable.add(serializedMapVariable);
        localCounter.add(Type.getType(Map.class));
        methodVisitor.visitVarInsn(25, serializedMapIndex);
        operandStack.push(Type.getType(Map.class));
        methodVisitor.visitMethodInsn(185, "java/util/Map", "entrySet", "()Ljava/util/Set;", true);
        operandStack.replaceTop(Type.getType(Set.class));
        methodVisitor.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;", true);
        operandStack.replaceTop(Type.getType(Iterator.class));
        int iteratorIndex = localCounter.getSlotIndex();
        int iteratorFrameIndex = localCounter.getFrameIndex();
        methodVisitor.visitVarInsn(58, iteratorIndex);
        operandStack.pop();
        Label label32 = new Label();
        methodVisitor.visitLabel(label32);
        LocalVariable iteratorVariable = new LocalVariable("iterator", "Ljava/util/Iterator;", null, label32, endLabel, iteratorIndex, iteratorFrameIndex);
        localVariableTable.add(iteratorVariable);
        localCounter.add(Type.getType(Iterator.class));
        methodVisitor.visitTypeInsn(187, generatedClassName);
        operandStack.push(Type.getType(generatedClassDescriptor));
        methodVisitor.visitInsn(89);
        operandStack.push(Type.getType(generatedClassDescriptor));
        methodVisitor.visitTypeInsn(187, mapNClassName);
        operandStack.push(Type.getType(mapNClassDescriptor));
        methodVisitor.visitInsn(89);
        operandStack.push(Type.getType(mapNClassDescriptor));
        for (int k = 1; k <= N; ++k) {
            methodVisitor.visitVarInsn(25, iteratorIndex);
            operandStack.push(Type.getType(Iterator.class));
            methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
            operandStack.replaceTop(Type.getType(Object.class));
            methodVisitor.visitTypeInsn(192, "java/util/Map$Entry");
            operandStack.replaceTop(Type.getType(Map.Entry.class));
            int entryKIndex = localCounter.getSlotIndex();
            int entryKFrameIndex = localCounter.getFrameIndex();
            methodVisitor.visitVarInsn(58, entryKIndex);
            operandStack.pop();
            Label entryKLabel = new Label();
            methodVisitor.visitLabel(entryKLabel);
            LocalVariable entryKVariable = new LocalVariable("entry" + k, "Ljava/util/Map$Entry;", null, entryKLabel, endLabel, entryKIndex, entryKFrameIndex);
            localVariableTable.add(entryKVariable);
            localCounter.add(Type.getType(Map.Entry.class));
            methodVisitor.visitVarInsn(25, entryKIndex);
            operandStack.push(Type.getType(Map.Entry.class));
            methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getKey", "()Ljava/lang/Object;", true);
            operandStack.replaceTop(Type.getType(Object.class));
            Types.genParameterType(methodVisitor, keyType, operandStack);
            Types.genScalaPluginClassLoader(methodVisitor, plugin, operandStack);
            methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "deserialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
            operandStack.replaceTop(3, Type.getType(Object.class));
            methodVisitor.visitVarInsn(25, entryKIndex);
            operandStack.push(Type.getType(Map.Entry.class));
            methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getValue", "()Ljava/lang/Object;", true);
            operandStack.replaceTop(Type.getType(Object.class));
            Types.genParameterType(methodVisitor, valueType, operandStack);
            Types.genScalaPluginClassLoader(methodVisitor, plugin, operandStack);
            methodVisitor.visitMethodInsn(184, "xyz/janboerman/scalaloader/configurationserializable/runtime/RuntimeConversions", "deserialize", "(Ljava/lang/Object;Lxyz/janboerman/scalaloader/configurationserializable/runtime/ParameterType;Lxyz/janboerman/scalaloader/plugin/ScalaPluginClassLoader;)Ljava/lang/Object;", false);
            operandStack.replaceTop(3, Type.getType(Object.class));
        }
        methodVisitor.visitMethodInsn(183, mapNClassName, "<init>", "(" + Compat.stringRepeat("Ljava/lang/Object;Ljava/lang/Object;", N) + ")V", false);
        operandStack.pop(N + 1);
        methodVisitor.visitMethodInsn(183, generatedClassName, "<init>", "(" + mapNClassDescriptor + ")V", false);
        operandStack.pop(2);
        methodVisitor.visitInsn(176);
        methodVisitor.visitLabel(endLabel);
        for (LocalVariable local : localVariableTable) {
            methodVisitor.visitLocalVariable(local.name, local.descriptor, local.signature, local.startLabel, local.endLabel, local.tableSlot);
        }
        methodVisitor.visitMaxs(operandStack.maxStack(), localVariableTable.maxLocals());
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "hashCode", "()I", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()" + mapNClassDescriptor, false);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "hashCode", "(Ljava/lang/Object;)I", false);
        methodVisitor.visitInsn(172);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        label1 = new Label();
        methodVisitor.visitJumpInsn(166, label1);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(label1);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(193, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap");
        label2 = new Label();
        methodVisitor.visitJumpInsn(154, label2);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap");
        methodVisitor.visitVarInsn(58, 2);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()" + mapNClassDescriptor, false);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(182, "xyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap", "getValue", "()Ljava/lang/Object;", false);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
        methodVisitor.visitInsn(172);
        label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label4, 0);
        methodVisitor.visitLocalVariable("o", "Ljava/lang/Object;", null, label0, label4, 1);
        methodVisitor.visitLocalVariable("that", "Lxyz/janboerman/scalaloader/configurationserializable/runtime/types/ScalaMap;", null, label3, label4, 2);
        methodVisitor.visitMaxs(2, 3);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()" + mapNClassDescriptor, false);
        methodVisitor.visitMethodInsn(184, "java/util/Objects", "toString", "(Ljava/lang/Object;)Ljava/lang/String;", false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(4161, "getValue", "()Ljava/lang/Object;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedClassName, "getValue", "()" + mapNClassDescriptor, false);
        methodVisitor.visitInsn(176);
        label1 = new Label();
        methodVisitor.visitLabel(label1);
        methodVisitor.visitLocalVariable("this", generatedClassDescriptor, null, label0, label1, 0);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }
}

