/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.runtime.types;

import java.util.Objects;
import xyz.janboerman.scalaloader.bytecode.Called;
import xyz.janboerman.scalaloader.configurationserializable.runtime.Adapter;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterizedParameterType;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;

public abstract class ScalaCollection {
    static final String SCALA_SEQ = "scala.collection.Seq";
    static final String SCALA_SET = "scala.collection.Set";
    static final String SCALA_IMMUTABLE_SEQ = "scala.collection.immutable.Seq";
    static final String SCALA_IMMUTABLE_SET = "scala.collection.immutable.Set";
    static final String SCALA_MUTABLE_SEQ = "scala.collection.mutable.Seq";
    static final String SCALA_MUTABLE_SET = "scala.collection.mutable.Set";
    static final String SCALA_IMMUTABLE_RANGE = "scala.collection.immutable.Range";
    static final String SCALA_IMMUTABLE_WRAPPED_STRING = "scala.collection.immutable.WrappedString";
    static final String SCALA_IMMUTABLE_ARRAY_SEQ = "scala.collection.immutable.ArraySeq";
    static final String SCALA_MUTABLE_ARRAY_SEQ = "scala.collection.mutable.ArraySeq";
    static final String SCALA_IMMUTABLE_LIST = "scala.collection.immutable.List";

    private static boolean isSetN(String setClassName, int N) {
        return ("scala.collection.immutable.Set$Set" + N).equals(setClassName);
    }

    private static boolean is(Object live, String className, ScalaPluginClassLoader plugin) {
        try {
            return Class.forName(className, false, plugin).isInstance(live);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isWrappedString(Object live, ScalaPluginClassLoader plugin) {
        return ScalaCollection.is(live, SCALA_IMMUTABLE_WRAPPED_STRING, plugin);
    }

    private static boolean isRange(Object live, ScalaPluginClassLoader plugin) {
        return ScalaCollection.is(live, SCALA_IMMUTABLE_RANGE, plugin);
    }

    private static boolean isImmutableArraySeq(Object live, ScalaPluginClassLoader plugin) {
        return ScalaCollection.is(live, SCALA_IMMUTABLE_ARRAY_SEQ, plugin);
    }

    private static boolean isMutableArraySeq(Object live, ScalaPluginClassLoader plugin) {
        return ScalaCollection.is(live, SCALA_MUTABLE_ARRAY_SEQ, plugin);
    }

    private static boolean isList(Object live, ScalaPluginClassLoader plugin) {
        return ScalaCollection.is(live, SCALA_IMMUTABLE_LIST, plugin);
    }

    private static Class<?> getScalaSeqClass(ScalaPluginClassLoader plugin) throws ClassNotFoundException {
        return Class.forName(SCALA_SEQ, false, plugin);
    }

    private static Class<?> getScalaSetClass(ScalaPluginClassLoader plugin) throws ClassNotFoundException {
        return Class.forName(SCALA_SET, false, plugin);
    }

    private static boolean isSeq(Object live, ScalaPluginClassLoader plugin) {
        try {
            return ScalaCollection.getScalaSeqClass(plugin).isInstance(live);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isSet(Object live, ScalaPluginClassLoader plugin) {
        try {
            return ScalaCollection.getScalaSetClass(plugin).isInstance(live);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isCollection(Object live, ScalaPluginClassLoader plugin) {
        return ScalaCollection.isSeq(live, plugin) || ScalaCollection.isSet(live, plugin);
    }

    public static ScalaCollection serialize(Object live, ParameterType type, ScalaPluginClassLoader plugin) {
        assert (ScalaCollection.isCollection(live, plugin)) : "Not a scala.collection.Seq or scala.collection.Set";
        ParameterType elementType = type instanceof ParameterizedParameterType ? ((ParameterizedParameterType)type).getTypeParameter(0) : ParameterType.from(Object.class);
        Class<?> ourCollectionClass = live.getClass();
        String alias = ourCollectionClass.getName();
        String generatedClassName = "xyz.janboerman.scalaloader.configurationserializable.runtime.types.generated.$ScalaCollection$" + alias;
        throw new RuntimeException("Could not serialize scala collection: " + live + ", of type: " + type);
    }

    @Called
    public static abstract class ScalaSet
    extends ScalaCollection
    implements Adapter {
        @Called
        public ScalaSet() {
        }

        public int hashCode() {
            return Objects.hashCode(this.getValue());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScalaSet)) {
                return false;
            }
            ScalaSet that = (ScalaSet)o;
            return Objects.equals(this.getValue(), that.getValue());
        }

        public String toString() {
            return Objects.toString(this.getValue());
        }
    }

    @Called
    public static abstract class ScalaSeq
    extends ScalaCollection
    implements Adapter {
        @Called
        public ScalaSeq() {
        }

        public int hashCode() {
            return Objects.hashCode(this.getValue());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScalaSeq)) {
                return false;
            }
            ScalaSeq that = (ScalaSeq)o;
            return Objects.equals(this.getValue(), that.getValue());
        }

        public String toString() {
            return Objects.toString(this.getValue());
        }
    }
}

