/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.runtime.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.configuration.serialization.SerializableAs;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterizedParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.RuntimeConversions;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;

public abstract class Option<T>
implements ConfigurationSerializable {
    private static final String OPTION = "scala.Option";
    private static final String SOME = "scala.Some";
    private static final String NONE = "scala.None$";

    Option() {
    }

    public static void registerWithConfigurationSerialization() {
        Some.register();
        None.register();
    }

    public static boolean isOption(Object live, ScalaPluginClassLoader classLoader) {
        try {
            Class<?> optionClass = Class.forName(OPTION, false, classLoader);
            return optionClass.isInstance(live);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static ConfigurationSerializable serialize(Object scalaOption, ParameterType type, ScalaPluginClassLoader plugin) {
        assert (Option.isOption(scalaOption, plugin)) : "Not a scala.Option";
        RuntimeException ex = new RuntimeException("Could not serialize option: " + scalaOption + ", of type: " + type);
        try {
            Class<?> someClass = Class.forName(SOME, false, plugin);
            if (someClass.isInstance(scalaOption)) {
                Method get = someClass.getMethod("get", new Class[0]);
                Object containedValue = get.invoke(scalaOption, new Object[0]);
                ParameterType containedValueType = type instanceof ParameterizedParameterType ? ((ParameterizedParameterType)type).getTypeParameter(0) : ParameterType.from(Object.class);
                Object serializedValue = RuntimeConversions.serialize(containedValue, containedValueType, plugin);
                return new Some<Object>(serializedValue);
            }
            Class<?> noneClass = Class.forName(NONE, false, plugin);
            if (noneClass.isInstance(scalaOption)) {
                return None.INSTANCE;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            ex.addSuppressed(e);
        }
        throw ex;
    }

    public static boolean isSerializedOption(Object o) {
        return o instanceof Some || o instanceof None;
    }

    public static Object deserialize(Object serializedOption, ParameterType type, ScalaPluginClassLoader plugin) {
        if (serializedOption instanceof Some) {
            Some some = (Some)serializedOption;
            Object serializedValue = some.getValue();
            ParameterType containedValueType = type instanceof ParameterizedParameterType ? ((ParameterizedParameterType)type).getTypeParameter(0) : ParameterType.from(Object.class);
            Object containedValue = RuntimeConversions.deserialize(serializedValue, containedValueType, plugin);
            try {
                Class<?> someClass = Class.forName(SOME, true, plugin);
                Constructor<?> constructor = someClass.getConstructor(Object.class);
                return constructor.newInstance(containedValue);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Can't use reflection to return new scala.Some(deserializedValue)", e);
            }
        }
        if (serializedOption instanceof None) {
            try {
                Class<?> noneClass = Class.forName(NONE, true, plugin);
                Field field = noneClass.getField("MODULE$");
                return field.get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Can't use reflection to get the scala.None$ singleton instance!", e);
            }
        }
        throw new RuntimeException("Could not deserialize option: " + serializedOption + ", to type: " + type);
    }

    @SerializableAs(value="Some")
    public static final class Some<T>
    extends Option<T> {
        private final T serializedValue;

        private static void register() {
            ConfigurationSerialization.registerClass(Some.class, (String)"Some");
        }

        public Some(T value) {
            this.serializedValue = value;
        }

        public T getValue() {
            return this.serializedValue;
        }

        public Map<String, Object> serialize() {
            return Compat.singletonMap("value", this.serializedValue);
        }

        public static <T> Some<T> deserialize(Map<String, Object> map) {
            return new Some<Object>(map.get("value"));
        }

        public int hashCode() {
            return Objects.hashCode(this.serializedValue);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Some)) {
                return false;
            }
            Some that = (Some)obj;
            return Objects.equals(this.serializedValue, that.serializedValue);
        }

        public String toString() {
            return "Some(" + this.serializedValue + ")";
        }
    }

    @SerializableAs(value="None")
    public static final class None
    extends Option {
        public static final None INSTANCE = new None();

        private static void register() {
            ConfigurationSerialization.registerClass(None.class, (String)"None");
        }

        private None() {
        }

        public Map<String, Object> serialize() {
            return Compat.emptyMap();
        }

        public static None deserialize(Map<String, Object> map) {
            return INSTANCE;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof None;
        }

        public String toString() {
            return "None";
        }
    }
}

