/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.runtime.types;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.configuration.serialization.SerializableAs;
import xyz.janboerman.scalaloader.bytecode.Called;

@Called
public abstract class NumericRange<I> {
    private static final String START = "start";
    private static final String STEP = "step";
    private static final String END = "end";
    private static final String INCLUSIVE = "inclusive";
    private final I start;
    private final I step;
    private final I end;
    private final boolean inclusive;

    public static void registerWithConfigurationSerialization() {
        OfByte.register();
        OfShort.register();
        OfInteger.register();
        OfLong.register();
        OfBigInteger.register();
    }

    protected NumericRange(I start, I step, I end, boolean inclusive) {
        this.start = start;
        this.step = step;
        this.end = end;
        this.inclusive = inclusive;
    }

    @Called
    public final I getStart() {
        return this.start;
    }

    @Called
    public final I getStep() {
        return this.step;
    }

    @Called
    public final I getEnd() {
        return this.end;
    }

    @Called
    public final boolean isInclusive() {
        return this.inclusive;
    }

    public int hashCode() {
        return Objects.hash(this.getStart(), this.getStep(), this.getEnd(), this.isInclusive());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NumericRange)) {
            return false;
        }
        NumericRange that = (NumericRange)obj;
        return Objects.equals(this.getStart(), that.getStart()) && Objects.equals(this.getStep(), that.getStep()) && Objects.equals(this.getEnd(), that.getEnd()) && this.isInclusive() == that.isInclusive();
    }

    public String toString() {
        return "NumericRange " + this.getStart() + (this.isInclusive() ? " to " : " until ") + this.getEnd() + " by " + this.getStep();
    }

    @SerializableAs(value="NumericRange.OfByte")
    @Called
    public static class OfByte
    extends NumericRange<Byte>
    implements ConfigurationSerializable {
        private static void register() {
            ConfigurationSerialization.registerClass(OfByte.class, (String)"NumericRange.OfByte");
        }

        @Called
        public OfByte(Byte start, Byte step, Byte end, boolean inclusive) {
            super(start, step, end, inclusive);
        }

        public OfByte(byte start, byte step, byte end, boolean inclusive) {
            super(start, step, end, inclusive);
        }

        public byte start() {
            return (Byte)super.getStart();
        }

        public byte step() {
            return (Byte)super.getStep();
        }

        public byte end() {
            return (Byte)super.getEnd();
        }

        public Map<String, Object> serialize() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(NumericRange.START, ((Byte)this.getStart()).intValue());
            map.put(NumericRange.STEP, ((Byte)this.getStep()).intValue());
            map.put(NumericRange.END, ((Byte)this.getEnd()).intValue());
            map.put(NumericRange.INCLUSIVE, this.isInclusive());
            return map;
        }

        public static OfByte valueOf(Map<String, Object> map) {
            Integer start = (Integer)map.get(NumericRange.START);
            Integer step = (Integer)map.get(NumericRange.STEP);
            Integer end = (Integer)map.get(NumericRange.END);
            Boolean inclusive = (Boolean)map.get(NumericRange.INCLUSIVE);
            return new OfByte(start.byteValue(), step.byteValue(), end.byteValue(), (boolean)inclusive);
        }
    }

    @SerializableAs(value="NumericRange.OfShort")
    @Called
    public static class OfShort
    extends NumericRange<Short>
    implements ConfigurationSerializable {
        private static void register() {
            ConfigurationSerialization.registerClass(OfShort.class, (String)"NumericRange.OfShort");
        }

        @Called
        public OfShort(Short start, Short step, Short end, boolean inclusive) {
            super(start, step, end, inclusive);
        }

        public OfShort(short start, short step, short end, boolean inclusive) {
            super(start, step, end, inclusive);
        }

        public short start() {
            return (Short)super.getStart();
        }

        public short step() {
            return (Short)super.getStep();
        }

        public short end() {
            return (Short)super.getEnd();
        }

        public Map<String, Object> serialize() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(NumericRange.START, ((Short)this.getStart()).intValue());
            map.put(NumericRange.STEP, ((Short)this.getStep()).intValue());
            map.put(NumericRange.END, ((Short)this.getEnd()).intValue());
            map.put(NumericRange.INCLUSIVE, this.isInclusive());
            return map;
        }

        public static OfShort valueOf(Map<String, Object> map) {
            Integer start = (Integer)map.get(NumericRange.START);
            Integer step = (Integer)map.get(NumericRange.STEP);
            Integer end = (Integer)map.get(NumericRange.END);
            Boolean inclusive = (Boolean)map.get(NumericRange.INCLUSIVE);
            return new OfShort(start.shortValue(), step.shortValue(), end.shortValue(), (boolean)inclusive);
        }
    }

    @SerializableAs(value="NumericRange.OfInteger")
    @Called
    public static class OfInteger
    extends NumericRange<Integer>
    implements ConfigurationSerializable {
        private static void register() {
            ConfigurationSerialization.registerClass(OfInteger.class, (String)"NumericRange.OfInteger");
        }

        @Called
        public OfInteger(Integer start, Integer step, Integer end, boolean inclusive) {
            super(start, step, end, inclusive);
        }

        @Called
        public OfInteger(int start, int step, int end, boolean inclusive) {
            super(start, step, end, inclusive);
        }

        @Called
        public int start() {
            return (Integer)super.getStart();
        }

        @Called
        public int step() {
            return (Integer)super.getStep();
        }

        @Called
        public int end() {
            return (Integer)super.getEnd();
        }

        public Map<String, Object> serialize() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(NumericRange.START, this.getStart());
            map.put(NumericRange.STEP, this.getStep());
            map.put(NumericRange.END, this.getEnd());
            map.put(NumericRange.INCLUSIVE, this.isInclusive());
            return map;
        }

        public static OfInteger valueOf(Map<String, Object> map) {
            Integer start = (Integer)map.get(NumericRange.START);
            Integer step = (Integer)map.get(NumericRange.STEP);
            Integer end = (Integer)map.get(NumericRange.END);
            Boolean inclusive = (Boolean)map.get(NumericRange.INCLUSIVE);
            return new OfInteger((int)start, (int)step, (int)end, (boolean)inclusive);
        }
    }

    @SerializableAs(value="NumericRange.OfLong")
    @Called
    public static class OfLong
    extends NumericRange<Long>
    implements ConfigurationSerializable {
        private static void register() {
            ConfigurationSerialization.registerClass(OfLong.class, (String)"NumericRange.OfLong");
        }

        @Called
        public OfLong(Long start, Long step, Long end, boolean inclusive) {
            super(start, step, end, inclusive);
        }

        public OfLong(long start, long step, long end, boolean inclusive) {
            super(start, step, end, inclusive);
        }

        public long start() {
            return (Long)super.getStart();
        }

        public long step() {
            return (Long)super.getStep();
        }

        public long end() {
            return (Long)super.getEnd();
        }

        public Map<String, Object> serialize() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(NumericRange.START, ((Long)this.getStart()).toString());
            map.put(NumericRange.STEP, ((Long)this.getStep()).toString());
            map.put(NumericRange.END, ((Long)this.getEnd()).toString());
            map.put(NumericRange.INCLUSIVE, this.isInclusive());
            return map;
        }

        public static OfLong valueOf(Map<String, Object> map) {
            String start = (String)map.get(NumericRange.START);
            String step = (String)map.get(NumericRange.STEP);
            String end = (String)map.get(NumericRange.END);
            Boolean inclusive = (Boolean)map.get(NumericRange.INCLUSIVE);
            return new OfLong(Long.parseLong(start), Long.parseLong(step), Long.parseLong(end), (boolean)inclusive);
        }
    }

    @SerializableAs(value="NumericRange.OfBigInteger")
    @Called
    public static class OfBigInteger
    extends NumericRange<BigInteger>
    implements ConfigurationSerializable {
        private static void register() {
            ConfigurationSerialization.registerClass(OfBigInteger.class, (String)"NumericRange.OfBigInteger");
        }

        @Called
        public OfBigInteger(BigInteger start, BigInteger step, BigInteger end, boolean inclusive) {
            super(start, step, end, inclusive);
        }

        public BigInteger start() {
            return (BigInteger)super.getStart();
        }

        public BigInteger step() {
            return (BigInteger)super.getStep();
        }

        public BigInteger end() {
            return (BigInteger)super.getEnd();
        }

        public Map<String, Object> serialize() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(NumericRange.START, ((BigInteger)this.getStart()).toString());
            map.put(NumericRange.STEP, ((BigInteger)this.getStep()).toString());
            map.put(NumericRange.END, ((BigInteger)this.getEnd()).toString());
            map.put(NumericRange.INCLUSIVE, this.isInclusive());
            return map;
        }

        public static OfBigInteger valueOf(Map<String, Object> map) {
            String start = (String)map.get(NumericRange.START);
            String step = (String)map.get(NumericRange.STEP);
            String end = (String)map.get(NumericRange.END);
            Boolean inclusive = (Boolean)map.get(NumericRange.INCLUSIVE);
            return new OfBigInteger(new BigInteger(start), new BigInteger(step), new BigInteger(end), (boolean)inclusive);
        }
    }
}

