/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.runtime.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.configuration.serialization.SerializableAs;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterizedParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.RuntimeConversions;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;

public abstract class Either<L, R>
implements ConfigurationSerializable {
    private static final String EITHER = "scala.util.Either";
    private static final String LEFT = "scala.util.Left";
    private static final String RIGHT = "scala.util.Right";

    Either() {
    }

    public static void registerWithConfigurationSerialization() {
        Left.register();
        Right.register();
    }

    public static boolean isEither(Object live, ScalaPluginClassLoader plugin) {
        try {
            Class<?> eitherClazz = Class.forName(EITHER, false, plugin);
            return eitherClazz.isInstance(live);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static ConfigurationSerializable serialize(Object scalaEither, ParameterType type, ScalaPluginClassLoader plugin) {
        assert (Either.isEither(scalaEither, plugin)) : "Not a scala.util.Either";
        RuntimeException ex = new RuntimeException("Could not serialize either: " + scalaEither + ", of type: " + type);
        try {
            Class<?> leftClass = Class.forName(LEFT, false, plugin);
            if (leftClass.isInstance(scalaEither)) {
                Method method = leftClass.getMethod("value", new Class[0]);
                Object liveValue = method.invoke(scalaEither, new Object[0]);
                ParameterType elementType = type instanceof ParameterizedParameterType ? ((ParameterizedParameterType)type).getTypeParameter(0) : ParameterType.from(Object.class);
                Object serializedValue = RuntimeConversions.serialize(liveValue, elementType, plugin);
                return new Left(serializedValue);
            }
            Class<?> rightClass = Class.forName(RIGHT, false, plugin);
            if (rightClass.isInstance(scalaEither)) {
                Method method = rightClass.getMethod("value", new Class[0]);
                Object liveValue = method.invoke(scalaEither, new Object[0]);
                ParameterType elementType = type instanceof ParameterizedParameterType ? ((ParameterizedParameterType)type).getTypeParameter(1) : ParameterType.from(Object.class);
                Object serializedValue = RuntimeConversions.serialize(liveValue, elementType, plugin);
                return new Right(serializedValue);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            ex.addSuppressed(e);
        }
        throw ex;
    }

    public static boolean isSerializedEither(Object o) {
        return o instanceof Left || o instanceof Right;
    }

    public static Object deserialize(Object serializedEither, ParameterType type, ScalaPluginClassLoader plugin) {
        if (serializedEither instanceof Left) {
            Left left = (Left)serializedEither;
            Object serializedValue = left.getValue();
            ParameterType containedValueType = type instanceof ParameterizedParameterType ? ((ParameterizedParameterType)type).getTypeParameter(0) : ParameterType.from(Object.class);
            Object containedValue = RuntimeConversions.deserialize(serializedValue, containedValueType, plugin);
            try {
                Class<?> leftClass = Class.forName(LEFT, true, plugin);
                Constructor<?> constructor = leftClass.getConstructor(Object.class);
                return constructor.newInstance(containedValue);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Can't use reflection to return new scala.util.Left(deserializedValue)", e);
            }
        }
        if (serializedEither instanceof Right) {
            Right right = (Right)serializedEither;
            Object serializedValue = right.getValue();
            ParameterType containedValueType = type instanceof ParameterizedParameterType ? ((ParameterizedParameterType)type).getTypeParameter(1) : ParameterType.from(Object.class);
            Object containedValue = RuntimeConversions.deserialize(serializedValue, containedValueType, plugin);
            try {
                Class<?> rightClass = Class.forName(RIGHT, true, plugin);
                Constructor<?> constructor = rightClass.getConstructor(Object.class);
                return constructor.newInstance(containedValue);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Can't use reflfection to return new scala.util.Right(deserializedValue)", e);
            }
        }
        throw new RuntimeException("Could not deserialize either: " + serializedEither + ", to type: " + type);
    }

    @SerializableAs(value="Left")
    public static final class Left<L, R>
    extends Either<L, R> {
        private final L serializedValue;

        private static void register() {
            ConfigurationSerialization.registerClass(Left.class, (String)"Left");
        }

        public Left(L serializedValue) {
            this.serializedValue = serializedValue;
        }

        public L getValue() {
            return this.serializedValue;
        }

        public Map<String, Object> serialize() {
            return Compat.singletonMap("value", this.serializedValue);
        }

        public static <L, R> Left<L, R> deserialize(Map<String, Object> map) {
            return new Left<Object, R>(map.get("value"));
        }

        public int hashCode() {
            return Objects.hashCode(this.serializedValue);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Left)) {
                return false;
            }
            Left that = (Left)obj;
            return Objects.equals(this.serializedValue, that.serializedValue);
        }

        public String toString() {
            return "Left(" + this.serializedValue + ")";
        }
    }

    @SerializableAs(value="Right")
    public static final class Right<L, R>
    extends Either<L, R> {
        private final R serializedValue;

        private static void register() {
            ConfigurationSerialization.registerClass(Right.class, (String)"Right");
        }

        public Right(R serializedValue) {
            this.serializedValue = serializedValue;
        }

        public R getValue() {
            return this.serializedValue;
        }

        public Map<String, Object> serialize() {
            return Compat.singletonMap("value", this.serializedValue);
        }

        public static <L, R> Right<L, R> deserialize(Map<String, Object> map) {
            return new Right<L, Object>(map.get("value"));
        }

        public int hashCode() {
            return Objects.hashCode(this.serializedValue);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Right)) {
                return false;
            }
            Right that = (Right)obj;
            return Objects.equals(this.serializedValue, that.serializedValue);
        }

        public String toString() {
            return "Right(" + this.serializedValue + ")";
        }
    }
}

