/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

class TypeUtils {
    private TypeUtils() {
    }

    static Class<?> asRawType(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type t = pt.getRawType();
            return TypeUtils.asRawType(t);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Type t = gat.getGenericComponentType();
            Class<?> rawComponentType = TypeUtils.asRawType(t);
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Type t = tv.getBounds()[0];
            return TypeUtils.asRawType(t);
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type t = wt.getUpperBounds()[0];
            return TypeUtils.asRawType(t);
        }
        throw new IllegalArgumentException("Unrecognized type: " + type + ". Are you using a programming language that is not Java?");
    }
}

