/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import xyz.janboerman.scalaloader.bytecode.Called;
import xyz.janboerman.scalaloader.configurationserializable.runtime.Adapter;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ArrayParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.Codec;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterizedParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.BigDecimal;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.BigInteger;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.Either;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.Enum;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.JavaCollection;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.JavaMap;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.Option;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.Primitives;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.ScalaCollection;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.ScalaMap;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.Tuple;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.UUID;
import xyz.janboerman.scalaloader.configurationserializable.transform.ConfigurationSerializableError;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;
import xyz.janboerman.scalaloader.util.Maybe;

public class RuntimeConversions {
    private static final Map<ScalaPluginClassLoader, Registrations> registrations = new HashMap<ScalaPluginClassLoader, Registrations>();

    private RuntimeConversions() {
    }

    public static boolean registerCodec(ScalaPluginClassLoader pluginClassLoader, ParameterType type, Codec<?, ?> codec) {
        Objects.requireNonNull(pluginClassLoader, "plugin classloader cannot be null!");
        return RuntimeConversions.registrations.computeIfAbsent(pluginClassLoader, x$0 -> new Registrations((ScalaPluginClassLoader)x$0)).register(type, codec);
    }

    public static boolean registerCodec(ScalaPluginClassLoader pluginClassLoader, Predicate<? super ParameterType> whenToUse, Function<? super ParameterType, ? extends Codec<?, ?>> codecFactory) {
        Objects.requireNonNull(pluginClassLoader, "plugin classloader cannot be null!");
        return RuntimeConversions.registrations.computeIfAbsent(pluginClassLoader, x$0 -> new Registrations((ScalaPluginClassLoader)x$0)).register(whenToUse, codecFactory);
    }

    public static <T> boolean registerCodec(ScalaPluginClassLoader pluginClassLoader, Class<T> clazz, Codec<T, ?> codec) {
        return RuntimeConversions.registerCodec(pluginClassLoader, ParameterType.from(clazz), codec);
    }

    @Deprecated
    public static void clearCodecs(ScalaPluginClassLoader scalaPlugin) {
        registrations.remove(scalaPlugin);
    }

    @Called
    public static Object serialize(Object live, ParameterType type, ScalaPluginClassLoader pluginClassLoader) {
        Maybe maybe;
        if (live == null) {
            return null;
        }
        Class<?> rawType = type.getRawType();
        assert (rawType.isInstance(live)) : "live object is not an instance of " + type;
        if (ConfigurationSerializable.class.isAssignableFrom(rawType) || rawType == String.class || rawType == Integer.class || rawType == Integer.TYPE || rawType == Double.class || rawType == Double.TYPE || rawType == Boolean.class || rawType == Boolean.TYPE) {
            return live;
        }
        if (rawType == Byte.class || rawType == Byte.TYPE) {
            return ((Byte)live).intValue();
        }
        if (rawType == Short.class || rawType == Short.TYPE) {
            return ((Short)live).intValue();
        }
        if (rawType == Long.class || rawType == Long.TYPE) {
            return ((Long)live).toString();
        }
        if (rawType == Float.class || rawType == Float.TYPE) {
            return ((Float)live).doubleValue();
        }
        if (rawType == Character.class || rawType == Character.TYPE) {
            return ((Character)live).toString();
        }
        if (rawType == Void.class || rawType == Void.TYPE) {
            return null;
        }
        if (rawType == java.util.UUID.class) {
            return ((java.util.UUID)live).toString();
        }
        if (rawType == java.math.BigInteger.class) {
            return ((java.math.BigInteger)live).toString();
        }
        if (rawType == java.math.BigDecimal.class) {
            return ((java.math.BigDecimal)live).toString();
        }
        if (rawType.isEnum()) {
            return ((java.lang.Enum)live).name();
        }
        if (type instanceof ArrayParameterType) {
            return RuntimeConversions.serializeArray(live, (ArrayParameterType)type, pluginClassLoader);
        }
        if (type instanceof ParameterizedParameterType && live instanceof Collection) {
            return RuntimeConversions.serializeCollection(live, (ParameterizedParameterType)type, pluginClassLoader);
        }
        if (type instanceof ParameterizedParameterType && live instanceof Map) {
            return RuntimeConversions.serializeMap(live, (ParameterizedParameterType)type, pluginClassLoader);
        }
        if (JavaCollection.isRawtypeCollection(live, type)) {
            return JavaCollection.serialize(live, type, pluginClassLoader);
        }
        if (JavaMap.isRawtypeMap(live, type)) {
            return JavaMap.serialize(live, type, pluginClassLoader);
        }
        if (Tuple.isTuple(live)) {
            return Tuple.serialize(live, type, pluginClassLoader);
        }
        if (Option.isOption(live, pluginClassLoader)) {
            return Option.serialize(live, type, pluginClassLoader);
        }
        if (Either.isEither(live, pluginClassLoader)) {
            return Either.serialize(live, type, pluginClassLoader);
        }
        if (ScalaMap.isMap(live, pluginClassLoader)) {
            return ScalaMap.serialize(live, type, pluginClassLoader);
        }
        if (ScalaCollection.isCollection(live, pluginClassLoader)) {
            return ScalaCollection.serialize(live, type, pluginClassLoader);
        }
        Registrations registrations = RuntimeConversions.registrations.get(pluginClassLoader);
        if (registrations != null && (maybe = registrations.serialize(type, live)).isPresent()) {
            Object serializedInstance = maybe.get();
            if (!(serializedInstance instanceof ConfigurationSerializable || serializedInstance instanceof String || serializedInstance instanceof Integer || serializedInstance instanceof Double || serializedInstance instanceof Boolean || serializedInstance instanceof List || serializedInstance instanceof Map || serializedInstance instanceof Set)) {
                Logger logger = pluginClassLoader.getPlugin().getLogger();
                logger.warning("Serialized type " + serializedInstance.getClass().getName() + " is not supported out of the box by Bukkit's configuration serialization api.");
                logger.warning("Please let your Codec serialize to a type that implements org.bukkit.configuration.serialization.ConfigurationSerializable,");
                logger.warning("or one of the supported types out of Java's standard library:");
                logger.warning("java.lang.String, java.lang.Integer, java.lang.Double, java.lang.Boolean, java.util.List, java.util.Set or java.util.Map");
            }
            return serializedInstance;
        }
        if (live instanceof Byte) {
            return new Primitives.Byte((Byte)live);
        }
        if (live instanceof Short) {
            return new Primitives.Short((Short)live);
        }
        if (live instanceof Integer) {
            return new Primitives.Integer((Integer)live);
        }
        if (live instanceof Long) {
            return new Primitives.Long((Long)live);
        }
        if (live instanceof Float) {
            return new Primitives.Float((Float)live);
        }
        if (live instanceof Double) {
            return new Primitives.Double((Double)live);
        }
        if (live instanceof Boolean) {
            return new Primitives.Boolean((Boolean)live);
        }
        if (live instanceof Character) {
            return new Primitives.Character((Character)live);
        }
        if (live instanceof java.util.UUID) {
            return new UUID((java.util.UUID)live);
        }
        if (live instanceof java.math.BigInteger) {
            return new BigInteger((java.math.BigInteger)live);
        }
        if (live instanceof java.math.BigDecimal) {
            return new BigDecimal((java.math.BigDecimal)live);
        }
        if (live instanceof java.lang.Enum) {
            return Enum.forEnum((java.lang.Enum)live, pluginClassLoader);
        }
        if (!(live instanceof ConfigurationSerializable) && pluginClassLoader.getPluginLoader().debugSettings().logMissingCodecs()) {
            pluginClassLoader.getPlugin().getLogger().warning("No Codec found for " + live.getClass().getName() + ", please register one using " + RuntimeConversions.class.getName() + "#registerCodec");
            pluginClassLoader.getPlugin().getLogger().warning("If you don't do this, then behaviour might break in the future!");
        }
        return live;
    }

    private static Object serializeArray(Object live, ArrayParameterType arrayType, ScalaPluginClassLoader plugin) {
        if (live instanceof byte[]) {
            byte[] bytes = (byte[])live;
            ArrayList<Integer> list = new ArrayList<Integer>(bytes.length);
            for (int index = 0; index < bytes.length; ++index) {
                list.add(Integer.valueOf(bytes[index]));
            }
            return list;
        }
        if (live instanceof short[]) {
            short[] shorts = (short[])live;
            ArrayList<Integer> list = new ArrayList<Integer>(shorts.length);
            for (int index = 0; index < shorts.length; ++index) {
                list.add(Integer.valueOf(shorts[index]));
            }
            return list;
        }
        if (live instanceof int[]) {
            int[] ints = (int[])live;
            ArrayList<Integer> list = new ArrayList<Integer>(ints.length);
            for (int index = 0; index < ints.length; ++index) {
                list.add(ints[index]);
            }
            return list;
        }
        if (live instanceof long[]) {
            long[] longs = (long[])live;
            ArrayList<String> list = new ArrayList<String>(longs.length);
            for (int index = 0; index < longs.length; ++index) {
                list.add(Long.toString(longs[index]));
            }
            return list;
        }
        if (live instanceof float[]) {
            float[] floats = (float[])live;
            ArrayList<Double> list = new ArrayList<Double>(floats.length);
            for (int index = 0; index < floats.length; ++index) {
                list.add(Double.valueOf(floats[index]));
            }
            return list;
        }
        if (live instanceof double[]) {
            double[] doubles = (double[])live;
            ArrayList<Double> list = new ArrayList<Double>(doubles.length);
            for (int index = 0; index < doubles.length; ++index) {
                list.add(doubles[index]);
            }
            return list;
        }
        if (live instanceof char[]) {
            char[] chars = (char[])live;
            ArrayList<String> list = new ArrayList<String>(chars.length);
            for (int index = 0; index < chars.length; ++index) {
                list.add(Character.toString(chars[index]));
            }
            return list;
        }
        if (live instanceof boolean[]) {
            boolean[] booleans = (boolean[])live;
            ArrayList<Boolean> list = new ArrayList<Boolean>(booleans.length);
            for (int index = 0; index < booleans.length; ++index) {
                list.add(booleans[index]);
            }
            return list;
        }
        if (live instanceof Object[]) {
            Object[] objects = (Object[])live;
            ArrayList<Object> list = new ArrayList<Object>(objects.length);
            for (int index = 0; index < objects.length; ++index) {
                list.add(RuntimeConversions.serialize(objects[index], arrayType.getComponentType(), plugin));
            }
            return list;
        }
        throw new IllegalArgumentException("live object must have an array type!");
    }

    private static Object serializeCollection(Object live, ParameterizedParameterType type, ScalaPluginClassLoader plugin) {
        if (live instanceof Set) {
            Set sourceSet = (Set)live;
            LinkedHashSet<Object> resultSet = new LinkedHashSet<Object>();
            for (Object item : sourceSet) {
                resultSet.add(RuntimeConversions.serialize(item, type.getTypeParameters().get(0), plugin));
            }
            return resultSet;
        }
        if (live instanceof List) {
            List sourceList = (List)live;
            ArrayList<Object> resultList = new ArrayList<Object>(sourceList.size());
            for (Object item : sourceList) {
                resultList.add(RuntimeConversions.serialize(item, type.getTypeParameters().get(0), plugin));
            }
            return resultList;
        }
        Collection sourceList = (Collection)live;
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Object item : sourceList) {
            resultList.add(RuntimeConversions.serialize(item, type.getTypeParameters().get(0), plugin));
        }
        return resultList;
    }

    private static Object serializeMap(Object live, ParameterizedParameterType type, ScalaPluginClassLoader plugin) {
        Map sourceMap = (Map)live;
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry entry : sourceMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            resultMap.put(RuntimeConversions.serialize(key, type.getTypeParameters().get(0), plugin), RuntimeConversions.serialize(value, type.getTypeParameters().get(1), plugin));
        }
        return resultMap;
    }

    @Called
    public static Object deserialize(Object serialized, ParameterType type, ScalaPluginClassLoader pluginClassLoader) {
        Maybe maybe;
        if (serialized == null) {
            return null;
        }
        Class<?> rawType = type.getRawType();
        if (ConfigurationSerializable.class.isAssignableFrom(rawType) || rawType == String.class || rawType == Integer.class || rawType == Integer.TYPE || rawType == Double.class || rawType == Double.TYPE || rawType == Boolean.class || rawType == Boolean.TYPE) {
            return serialized;
        }
        if (rawType == Byte.class || rawType == Byte.TYPE) {
            return ((Integer)serialized).byteValue();
        }
        if (rawType == Short.class || rawType == Short.TYPE) {
            return ((Integer)serialized).shortValue();
        }
        if (rawType == Long.class || rawType == Long.TYPE) {
            return Long.parseLong((String)serialized);
        }
        if (rawType == Float.class || rawType == Float.TYPE) {
            return Float.valueOf(((Double)serialized).floatValue());
        }
        if (rawType == Character.class || rawType == Character.TYPE) {
            return Character.valueOf(((String)serialized).charAt(0));
        }
        if (rawType == Void.class || rawType == Void.TYPE) {
            return null;
        }
        if (rawType == java.util.UUID.class) {
            return java.util.UUID.fromString((String)serialized);
        }
        if (rawType == java.math.BigInteger.class) {
            return new java.math.BigInteger((String)serialized);
        }
        if (rawType == java.math.BigDecimal.class) {
            return new java.math.BigDecimal((String)serialized);
        }
        if (rawType.isEnum()) {
            return java.lang.Enum.valueOf(rawType, (String)serialized);
        }
        if (type instanceof ArrayParameterType) {
            return RuntimeConversions.deserializeArray((List)serialized, (ArrayParameterType)type, pluginClassLoader);
        }
        if (type instanceof ParameterizedParameterType && Collection.class.isAssignableFrom(type.getRawType())) {
            return RuntimeConversions.deserializeCollection((Collection)serialized, (ParameterizedParameterType)type, pluginClassLoader);
        }
        if (type instanceof ParameterizedParameterType && Map.class.isAssignableFrom(type.getRawType())) {
            return RuntimeConversions.deserializeMap((Map)serialized, (ParameterizedParameterType)type, pluginClassLoader);
        }
        if (Option.isSerializedOption(serialized)) {
            return Option.deserialize(serialized, type, pluginClassLoader);
        }
        if (Either.isSerializedEither(serialized)) {
            return Either.deserialize(serialized, type, pluginClassLoader);
        }
        Registrations registrations = RuntimeConversions.registrations.get(pluginClassLoader);
        if (registrations != null && (maybe = registrations.deserialize(type, serialized)).isPresent()) {
            Object live = maybe.get();
            return live;
        }
        if (serialized instanceof Adapter) {
            return ((Adapter)serialized).getValue();
        }
        if (!(serialized instanceof ConfigurationSerializable) && pluginClassLoader.getPluginLoader().debugSettings().logMissingCodecs()) {
            pluginClassLoader.getPlugin().getLogger().warning("No Codec found for " + type.toString() + ", please register one using " + RuntimeConversions.class.getName() + "#registerCodec");
            pluginClassLoader.getPlugin().getLogger().warning("If you don't do this, then behaviour might break in the future!");
        }
        return serialized;
    }

    private static Object deserializeArray(List<?> serialized, ArrayParameterType type, ScalaPluginClassLoader plugin) {
        ParameterType componentType = type.getComponentType();
        Class<?> componentClass = Array.newInstance(componentType.getRawType(), 0).getClass();
        Object array = Array.newInstance(componentClass, serialized.size());
        for (int index = 0; index < serialized.size(); ++index) {
            Array.set(array, index, RuntimeConversions.deserialize(serialized.get(index), componentType, plugin));
        }
        return array;
    }

    private static Object deserializeCollection(Collection<?> serialized, ParameterizedParameterType type, ScalaPluginClassLoader plugin) {
        Collection<Object> resultCollection;
        Class<?> rawType = type.getRawType();
        if (rawType.isInterface()) {
            resultCollection = BlockingDeque.class.isAssignableFrom(rawType) ? new LinkedBlockingDeque() : (TransferQueue.class.isAssignableFrom(rawType) ? new LinkedTransferQueue() : (BlockingQueue.class.isAssignableFrom(rawType) ? new LinkedBlockingQueue() : (Deque.class.isAssignableFrom(rawType) ? new ArrayDeque(serialized.size()) : (Queue.class.isAssignableFrom(rawType) ? new LinkedList() : (SortedSet.class.isAssignableFrom(rawType) ? new TreeSet() : (Set.class.isAssignableFrom(rawType) ? new LinkedHashSet() : new ArrayList(serialized.size())))))));
        } else if (rawType == EnumSet.class) {
            resultCollection = EnumSet.noneOf(type.getTypeParameters().get(0).getRawType());
        } else {
            try {
                Constructor<?> nullaryConstructor = rawType.getConstructor(new Class[0]);
                resultCollection = (Collection)nullaryConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                ConfigurationSerializableError error = new ConfigurationSerializableError("Could not instantiate an instance of " + rawType.getName() + ". It has no public constructor with zero parameters.");
                error.addSuppressed(e);
                throw error;
            }
        }
        for (Object item : serialized) {
            resultCollection.add(RuntimeConversions.deserialize(item, type.getTypeParameters().get(0), plugin));
        }
        return resultCollection;
    }

    private static Object deserializeMap(Map<?, ?> serialized, ParameterizedParameterType type, ScalaPluginClassLoader plugin) {
        Map<Object, Object> resultMap;
        Class<?> rawType = type.getRawType();
        if (rawType.isInterface()) {
            resultMap = ConcurrentNavigableMap.class.isAssignableFrom(rawType) ? new ConcurrentSkipListMap() : (ConcurrentMap.class.isAssignableFrom(rawType) ? new ConcurrentHashMap() : (SortedMap.class.isAssignableFrom(rawType) ? new TreeMap() : new LinkedHashMap()));
        } else if (rawType == EnumMap.class) {
            resultMap = new EnumMap(type.getTypeParameters().get(0).getRawType());
        } else {
            try {
                Constructor<?> nullaryConstructor = rawType.getConstructor(new Class[0]);
                resultMap = (Map)nullaryConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                ConfigurationSerializableError error = new ConfigurationSerializableError("Could not instantiate an instance of " + rawType.getName() + ". It has no public constructor with zero parameters.");
                error.addSuppressed(e);
                throw error;
            }
        }
        for (Map.Entry<?, ?> entry : serialized.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            resultMap.put(RuntimeConversions.deserialize(key, type.getTypeParameters().get(0), plugin), RuntimeConversions.deserialize(value, type.getTypeParameters().get(1), plugin));
        }
        return resultMap;
    }

    private static class Registrations {
        private final ScalaPluginClassLoader classLoader;
        private final Map<ParameterType, Codec<?, ?>> absoluteCodecs = new HashMap();
        private final Map<Predicate<? super ParameterType>, Function<? super ParameterType, ? extends Codec<?, ?>>> bestEffortCodecs = new LinkedHashMap();

        private Registrations(ScalaPluginClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        private boolean register(ParameterType type, Codec<?, ?> codec) {
            return this.absoluteCodecs.putIfAbsent(type, codec) == null;
        }

        private boolean register(Predicate<? super ParameterType> type, Function<? super ParameterType, ? extends Codec<?, ?>> codecFactory) {
            return this.bestEffortCodecs.putIfAbsent(type, codecFactory) == null;
        }

        private Maybe<Object> serialize(ParameterType parameterType, Object live) {
            Codec<?, ?> codec = this.absoluteCodecs.get(parameterType);
            if (codec != null) {
                return Maybe.just(codec.serialize(live));
            }
            for (Map.Entry<Predicate<ParameterType>, Function<ParameterType, Codec<?, ?>>> entry : this.bestEffortCodecs.entrySet()) {
                Predicate<? super ParameterType> predicate = entry.getKey();
                Function<ParameterType, Codec<?, ?>> codecFactory = entry.getValue();
                if (!predicate.test(parameterType)) continue;
                return Maybe.just(codecFactory.apply(parameterType).serialize(live));
            }
            return Maybe.nothing();
        }

        private Maybe<Object> deserialize(ParameterType parameterType, Object serialized) {
            Codec<?, ?> codec = this.absoluteCodecs.get(parameterType);
            if (codec != null) {
                return Maybe.just(codec.deserialize(serialized));
            }
            for (Map.Entry<Predicate<ParameterType>, Function<ParameterType, Codec<?, ?>>> entry : this.bestEffortCodecs.entrySet()) {
                Predicate<? super ParameterType> predicate = entry.getKey();
                Function<ParameterType, Codec<?, ?>> codecFactory = entry.getValue();
                if (!predicate.test(parameterType)) continue;
                return Maybe.just(codecFactory.apply(parameterType).deserialize(serialized));
            }
            return Maybe.nothing();
        }
    }
}

