/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import xyz.janboerman.scalaloader.bytecode.Called;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ArrayParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterizedParameterType;
import xyz.janboerman.scalaloader.configurationserializable.runtime.TypeUtils;

@Called
public class ParameterType {
    private final Set<? extends Annotation> annotations;
    private final Class<?> rawType;
    private Map<Class<? extends Annotation>, Annotation> lazyAnnotations = null;

    ParameterType(Set<? extends Annotation> annotations, Class<?> rawType) {
        Objects.requireNonNull(annotations);
        Objects.requireNonNull(rawType);
        this.annotations = annotations.isEmpty() ? Compat.emptySet() : Compat.setCopy(annotations);
        this.rawType = rawType;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public Set<? extends Annotation> getAnnotations() {
        return this.annotations;
    }

    private synchronized Map<Class<? extends Annotation>, Annotation> getAnnotationsMap() {
        if (this.lazyAnnotations != null) {
            return this.lazyAnnotations;
        }
        Set<? extends Annotation> annotations = this.getAnnotations();
        if (annotations.isEmpty()) {
            this.lazyAnnotations = Compat.emptyMap();
        } else {
            this.lazyAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation annotation : annotations) {
                this.lazyAnnotations.put(annotation.annotationType(), annotation);
            }
        }
        return this.lazyAnnotations;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return (A)((Annotation)annotationClass.cast(this.getAnnotationsMap().get(annotationClass)));
    }

    public static ParameterType from(Set<? extends Annotation> annotations, Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return ArrayParameterType.from(annotations, ParameterType.from(clazz.getComponentType()), false);
            }
            return new ParameterType(annotations, clazz);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Class<?> rawType = TypeUtils.asRawType(pt.getRawType());
            Type[] typeArguments = pt.getActualTypeArguments();
            ParameterType[] typeParameters = new ParameterType[typeArguments.length];
            for (int i = 0; i < typeParameters.length; ++i) {
                typeParameters[i] = ParameterType.from(typeArguments[i]);
            }
            return ParameterizedParameterType.from(annotations, rawType, typeParameters);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Type componentType = gat.getGenericComponentType();
            return ArrayParameterType.from(annotations, ParameterType.from(componentType), false);
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            AnnotatedType annotatedBound = tv.getAnnotatedBounds()[0];
            HashSet<? extends Annotation> newAnnotations = new HashSet<Annotation>(annotations);
            newAnnotations.addAll(Arrays.asList(annotatedBound.getAnnotations()));
            Type bound = annotatedBound.getType();
            return ParameterType.from(newAnnotations, bound);
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type upperBound = wt.getUpperBounds()[0];
            return ParameterType.from(annotations, upperBound);
        }
        return new ParameterType(annotations, TypeUtils.asRawType(type));
    }

    @Called
    public static ParameterType from(Type type) {
        return ParameterType.from(Compat.emptySet(), type);
    }

    public static ParameterType from(Parameter parameter) {
        if (parameter.isVarArgs()) {
            AnnotatedArrayType annotatedArrayType = (AnnotatedArrayType)parameter.getAnnotatedType();
            return ParameterType.from(annotatedArrayType, true);
        }
        return ParameterType.from(parameter.getAnnotatedType());
    }

    public static ParameterType from(AnnotatedType type) {
        if (type instanceof AnnotatedArrayType) {
            return ParameterType.from((AnnotatedArrayType)type, false);
        }
        if (type instanceof AnnotatedParameterizedType) {
            return ParameterType.from((AnnotatedParameterizedType)type);
        }
        if (type instanceof AnnotatedTypeVariable) {
            AnnotatedTypeVariable atv = (AnnotatedTypeVariable)type;
            AnnotatedType[] bounds = atv.getAnnotatedBounds();
            return ParameterType.from(bounds[0]);
        }
        if (type instanceof AnnotatedWildcardType) {
            AnnotatedWildcardType awt = (AnnotatedWildcardType)type;
            AnnotatedType[] bounds = awt.getAnnotatedUpperBounds();
            return ParameterType.from(bounds[0]);
        }
        Class<?> rawType = TypeUtils.asRawType(type.getType());
        Set<Annotation> annotations = Compat.setOf(type.getAnnotations());
        return ParameterType.from(annotations, rawType);
    }

    private static ArrayParameterType from(AnnotatedArrayType arrayType, boolean varArgs) {
        Set<Annotation> baseAnnotations = Compat.setOf(arrayType.getAnnotations());
        AnnotatedType componentType = arrayType.getAnnotatedGenericComponentType();
        ParameterType componentParameterType = ParameterType.from(componentType);
        return ArrayParameterType.from(baseAnnotations, componentParameterType, varArgs);
    }

    private static ParameterizedParameterType from(AnnotatedParameterizedType parameterizedType) {
        Class<?> rawType = TypeUtils.asRawType(parameterizedType.getType());
        Set<Annotation> baseAnnotations = Compat.setOf(parameterizedType.getAnnotations());
        AnnotatedType[] actualTypeArguments = parameterizedType.getAnnotatedActualTypeArguments();
        ParameterType[] typeParameters = new ParameterType[actualTypeArguments.length];
        for (int i = 0; i < typeParameters.length; ++i) {
            AnnotatedType annotatedType = actualTypeArguments[i];
            typeParameters[i] = ParameterType.from(annotatedType);
        }
        return ParameterizedParameterType.from(baseAnnotations, rawType, typeParameters);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set<? extends Annotation> annotations = this.getAnnotations();
        if (!annotations.isEmpty()) {
            StringJoiner annotationJoiner = new StringJoiner(" ");
            for (Annotation annotation : annotations) {
                annotationJoiner.add(annotation.toString());
            }
            stringBuilder.append(annotationJoiner.toString()).append(" ");
        }
        stringBuilder.append(this.getRawType().getName());
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterType)) {
            return false;
        }
        ParameterType that = (ParameterType)o;
        return Objects.equals(this.getRawType(), that.getRawType()) && Objects.equals(this.getAnnotations(), that.getAnnotations());
    }

    public int hashCode() {
        return Objects.hash(this.getRawType(), this.getAnnotations());
    }
}

