/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.configurationserializable.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import xyz.janboerman.scalaloader.bytecode.Called;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.configurationserializable.runtime.ParameterType;

@Called
public class ArrayParameterType
extends ParameterType {
    private final ParameterType componentType;
    private final boolean varArgs;

    ArrayParameterType(Set<? extends Annotation> annotations, ParameterType componentType, boolean varArgs) {
        super(annotations, Array.newInstance(componentType.getRawType(), 0).getClass());
        this.componentType = Objects.requireNonNull(componentType);
        this.varArgs = varArgs;
    }

    public static ArrayParameterType from(Set<? extends Annotation> annotations, ParameterType componentType, boolean varArgs) {
        return new ArrayParameterType(annotations, componentType, varArgs);
    }

    @Called
    public static ArrayParameterType from(ParameterType componentType, boolean varArgs) {
        return ArrayParameterType.from(Compat.emptySet(), componentType, varArgs);
    }

    public ParameterType getComponentType() {
        return this.componentType;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayParameterType)) {
            return false;
        }
        ArrayParameterType that = (ArrayParameterType)o;
        return super.equals(that) && this.getComponentType().equals(that.getComponentType()) && this.isVarArgs() == that.isVarArgs();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getComponentType(), this.isVarArgs());
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set<? extends Annotation> annotations = this.getAnnotations();
        if (!annotations.isEmpty()) {
            StringJoiner annotationJoiner = new StringJoiner(" ");
            for (Annotation annotation : annotations) {
                annotationJoiner.add(annotation.toString());
            }
            stringBuilder.append(annotationJoiner.toString()).append(" ");
        }
        stringBuilder.append(this.getComponentType().toString());
        if (this.isVarArgs()) {
            stringBuilder.append("...");
        } else {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }
}

