/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.compat;

import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.bukkit.Server;
import org.bukkit.UnsafeValues;
import org.bukkit.plugin.PluginDescriptionFile;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;
import xyz.janboerman.scalaloader.plugin.description.ApiVersion;

public enum Platform {
    CRAFTBUKKIT{
        private MethodHandle commodoreConvert = null;
        private boolean attempted = false;

        @Override
        public byte[] transform(String jarEntryPath, byte[] classBytes, ScalaPluginClassLoader pluginClassLoader) throws Throwable {
            if (!this.attempted) {
                this.attempted = true;
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Server craftServer = pluginClassLoader.getServer();
                try {
                    Class<?> commodoreClass = Class.forName(Compat.getPackageName(craftServer.getClass()) + ".util.Commodore");
                    String methodName = "convert";
                    MethodType methodType = MethodType.methodType(byte[].class, new Class[]{byte[].class, Boolean.TYPE});
                    this.commodoreConvert = lookup.findStatic(commodoreClass, methodName, methodType);
                }
                catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (this.commodoreConvert != null) {
                boolean isModern = pluginClassLoader.getApiVersion() != ApiVersion.LEGACY;
                classBytes = this.commodoreConvert.invoke(classBytes, isModern);
            }
            return classBytes;
        }
    }
    ,
    GLOWSTONE{}
    ,
    UNKNOWN;

    private Boolean conversionMethodExists = null;

    public byte[] transform(String jarEntryPath, byte[] original, ScalaPluginClassLoader currentPluginClassLoader) throws Throwable {
        if (this.conversionMethodExists == null || this.conversionMethodExists.booleanValue()) {
            try {
                Server server = currentPluginClassLoader.getServer();
                UnsafeValues unsafeValues = server.getUnsafe();
                String fakeDescription = "name: Fake" + System.lineSeparator() + "version: 1.0" + System.lineSeparator() + "main: xyz.janboerman.scalaloader.FakePlugin" + System.lineSeparator();
                ApiVersion apiVersion = currentPluginClassLoader.getApiVersion();
                if (apiVersion != ApiVersion.LEGACY) {
                    fakeDescription = fakeDescription + "api-version: " + apiVersion.getVersionString() + System.lineSeparator();
                }
                PluginDescriptionFile pluginDescriptionFile = new PluginDescriptionFile((Reader)new StringReader(fakeDescription));
                byte[] processed = unsafeValues.processClass(pluginDescriptionFile, jarEntryPath, original);
                this.conversionMethodExists = true;
                return processed;
            }
            catch (NoSuchMethodError e) {
                this.conversionMethodExists = false;
            }
        }
        return original;
    }

    public static Platform detect(Server server) {
        if (server.getClass().getName().startsWith("org.bukkit.craftbukkit.")) {
            return CRAFTBUKKIT;
        }
        if (server.getClass().getName().startsWith("net.glowstone.")) {
            return GLOWSTONE;
        }
        return UNKNOWN;
    }
}

