/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.commands;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import xyz.janboerman.scalaloader.ScalaLoader;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.plugin.PluginScalaVersion;
import xyz.janboerman.scalaloader.plugin.description.ScalaVersion;

public class ResetScalaUrls
implements TabExecutor {
    private final ScalaLoader scalaLoader;

    public ResetScalaUrls(ScalaLoader scalaLoader) {
        this.scalaLoader = scalaLoader;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        String version = args[0];
        if ("all".equals(version)) {
            this.scalaLoader.saveScalaVersionsToConfig((PluginScalaVersion[])Arrays.stream(ScalaVersion.values()).map(PluginScalaVersion::fromScalaVersion).toArray(PluginScalaVersion[]::new));
            sender.sendMessage(ChatColor.GREEN + "All URLs for built-in scala versions were reset!");
        } else {
            ScalaVersion scalaVersion = ScalaVersion.fromVersionString(version);
            if (scalaVersion != null) {
                this.scalaLoader.saveScalaVersionsToConfig(PluginScalaVersion.fromScalaVersion(scalaVersion));
                sender.sendMessage(ChatColor.GREEN + "URLs for scala version " + scalaVersion.getVersion() + " were reset.");
            } else {
                sender.sendMessage(new String[]{ChatColor.RED + "Unrecognized scala version: " + version + ".", ChatColor.RED + "Please use one of the following: " + this.onTabComplete(sender, command, label, new String[0]) + "."});
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            LinkedList scalaVersions = Arrays.stream(ScalaVersion.values()).map(ScalaVersion::getVersion).collect(Collectors.toCollection(LinkedList::new));
            scalaVersions.addFirst("all");
            return scalaVersions;
        }
        return Compat.emptyList();
    }
}

