/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.StringUtil;
import xyz.janboerman.scalaloader.ScalaLoader;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.libs.asm.ClassReader;
import xyz.janboerman.scalaloader.libs.asm.util.ASMifier;
import xyz.janboerman.scalaloader.libs.asm.util.Printer;
import xyz.janboerman.scalaloader.libs.asm.util.Textifier;
import xyz.janboerman.scalaloader.libs.asm.util.TraceClassVisitor;
import xyz.janboerman.scalaloader.plugin.ScalaPlugin;
import xyz.janboerman.scalaloader.plugin.ScalaPluginClassLoader;

public class DumpClass
implements TabExecutor {
    private static final String TEXTIFIED = "Textified";
    private static final String ASMIFIED = "ASMified";
    private final ScalaLoader scalaLoader;

    public DumpClass(ScalaLoader scalaLoader) {
        this.scalaLoader = scalaLoader;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 2) {
            return false;
        }
        String pluginInput = args[0];
        String classFileInput = args[1];
        String formatInput = args.length >= 3 && ASMIFIED.equalsIgnoreCase(args[2]) ? ASMIFIED : TEXTIFIED;
        PluginManager pluginManager = this.scalaLoader.getServer().getPluginManager();
        Plugin plugin = pluginManager.getPlugin(pluginInput);
        if (plugin == null) {
            sender.sendMessage(ChatColor.RED + "Unknown plugin: " + pluginInput);
            return true;
        }
        try {
            File jarFile = DumpClass.getJarFile(plugin);
            if (jarFile == null) {
                sender.sendMessage(ChatColor.RED + "Could not detect plugin's jar file. Currently this command only supports ScalaPlugins and JavaPlugins.");
                return true;
            }
            JarFile jar = Compat.jarFile(jarFile);
            JarEntry jarEntry = jar.getJarEntry(classFileInput);
            if (jarEntry == null) {
                sender.sendMessage(ChatColor.RED + "Class file " + classFileInput + " does not exist in plugin " + plugin.getName());
                return true;
            }
            try (InputStream inputStream = jar.getInputStream(jarEntry);){
                Printer printer;
                switch (formatInput) {
                    case "ASMified": {
                        printer = new ASMifier();
                        break;
                    }
                    case "Textified": {
                        printer = new Textifier();
                        break;
                    }
                    default: {
                        assert (false) : "format was not ASMified or Textified?";
                        printer = null;
                    }
                }
                DumpClass.dump(inputStream, printer);
            }
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.scalaLoader.getLogger().log(Level.WARNING, "Unable to open jar file for plugin: " + plugin.getName(), e);
            sender.sendMessage(ChatColor.RED + "Could not read class file from plugin.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        PluginManager pluginManager = this.scalaLoader.getServer().getPluginManager();
        if (args.length == 0) {
            return Arrays.stream(pluginManager.getPlugins()).map(Plugin::getName).collect(Collectors.toList());
        }
        if (args.length == 1) {
            String pluginNameInput = args[0];
            return Arrays.stream(pluginManager.getPlugins()).map(Plugin::getName).filter(pluginName -> StringUtil.startsWithIgnoreCase((String)pluginName, (String)pluginNameInput)).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String pluginNameInput = args[0];
            String classFileInput = args[1];
            ArrayList<String> result = new ArrayList<String>();
            Plugin plugin = pluginManager.getPlugin(pluginNameInput);
            File jarFile = null;
            try {
                jarFile = DumpClass.getJarFile(plugin);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                this.scalaLoader.getLogger().log(Level.WARNING, "Could not read plugin's jar file.", e);
                sender.sendMessage(ChatColor.RED + "Could not read plugin's jar file.");
            }
            if (jarFile != null) {
                try {
                    JarFile jar = Compat.jarFile(jarFile);
                    Enumeration<JarEntry> enumeration = jar.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry entry = enumeration.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.endsWith(".class") || !entryName.startsWith(classFileInput)) continue;
                        result.add(entryName);
                    }
                }
                catch (IOException e) {
                    this.scalaLoader.getLogger().log(Level.WARNING, "Could not get entries from jar file.", e);
                    sender.sendMessage(ChatColor.RED + "Could not get entries from jar file.");
                }
            } else {
                result.add(classFileInput);
            }
            return result;
        }
        if (args.length == 3) {
            String formatInput = args[2];
            if (formatInput.isEmpty()) {
                return Compat.listOf(TEXTIFIED, ASMIFIED);
            }
            if (StringUtil.startsWithIgnoreCase((String)TEXTIFIED, (String)formatInput)) {
                return Compat.singletonList(TEXTIFIED);
            }
            if (StringUtil.startsWithIgnoreCase((String)ASMIFIED, (String)formatInput)) {
                return Compat.singletonList(ASMIFIED);
            }
            return Compat.emptyList();
        }
        return Compat.emptyList();
    }

    private static File getJarFile(Plugin plugin) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        File jarFile;
        if (plugin instanceof JavaPlugin) {
            JavaPlugin javaPlugin = (JavaPlugin)plugin;
            Method getFile = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            getFile.setAccessible(true);
            jarFile = (File)getFile.invoke((Object)javaPlugin, new Object[0]);
        } else if (plugin instanceof ScalaPlugin) {
            ScalaPlugin scalaPlugin = (ScalaPlugin)plugin;
            ScalaPluginClassLoader classLoader = scalaPlugin.getClassLoader();
            jarFile = classLoader.getPluginJarFile();
        } else {
            jarFile = null;
        }
        return jarFile;
    }

    private static void dump(InputStream classBytes, Printer printer) throws IOException {
        ClassReader debugReader = new ClassReader(classBytes);
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, printer, new PrintWriter(System.out));
        debugReader.accept(traceClassVisitor, 0);
    }
}

