/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.bytecode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.libs.asm.Type;
import xyz.janboerman.scalaloader.libs.asm.signature.SignatureReader;
import xyz.janboerman.scalaloader.libs.asm.signature.SignatureVisitor;
import xyz.janboerman.scalaloader.util.BoolOps;

public final class TypeSignature {
    private static final String ARRAY = "array";
    public static final TypeSignature OBJECT_TYPE_SIGNATURE = new TypeSignature("java/lang/Object", Compat.emptyList());
    private final String typeName;
    private final List<TypeSignature> typeArguments;

    public TypeSignature(String typeName, List<TypeSignature> typeArguments) {
        assert (typeName != null) : "type name cannot be null";
        assert (typeArguments != null) : "type arguments cannot be null";
        assert (BoolOps.implies(ARRAY.equals(typeName), typeArguments.size() == 1)) : "array type signature must have exactly one type argument";
        this.typeName = typeName;
        this.typeArguments = typeArguments;
    }

    public boolean isArray() {
        return ARRAY.equals(this.getTypeName());
    }

    public boolean hasTypeArguments() {
        return !this.typeArguments.isEmpty();
    }

    public boolean hasTypeArguments(int n) {
        if (n == 1) {
            return this.hasTypeArguments();
        }
        return this.typeArguments.size() >= n;
    }

    public static TypeSignature ofDescriptor(String descriptor) {
        if (descriptor.startsWith("[")) {
            return new TypeSignature(ARRAY, Compat.singletonList(TypeSignature.ofDescriptor(descriptor.substring(1))));
        }
        if (descriptor.startsWith("T")) {
            return OBJECT_TYPE_SIGNATURE;
        }
        return new TypeSignature(Type.getType(descriptor).getInternalName(), Compat.emptyList());
    }

    public static TypeSignature ofSignature(String signature) {
        SignatureReader signatureReader = new SignatureReader(signature);
        MySignatureVisitor signatureVisitor = new MySignatureVisitor();
        signatureReader.acceptType(signatureVisitor);
        return TypeSignature.toTypeSignature(signatureVisitor);
    }

    private static TypeSignature toTypeSignature(MySignatureVisitor mySignatureVisitor) {
        if ("java/lang/Object".equals(mySignatureVisitor.rawTypeName)) {
            return OBJECT_TYPE_SIGNATURE;
        }
        String name = mySignatureVisitor.rawTypeName;
        List<TypeSignature> typeArguments = mySignatureVisitor.typeArgs.stream().map(TypeSignature::toTypeSignature).collect(Collectors.toList());
        return new TypeSignature(name, typeArguments);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String internalName() {
        if (ARRAY.equals(this.typeName)) {
            return '[' + this.getTypeArgument(0).internalName();
        }
        return this.typeName;
    }

    public List<TypeSignature> getTypeArguments() {
        return Collections.unmodifiableList(this.typeArguments);
    }

    public int countTypeArguments() {
        return this.typeArguments.size();
    }

    public TypeSignature getTypeArgument(int index) {
        return this.typeArguments.get(index);
    }

    public final String toDescriptor() {
        String typeName;
        switch (typeName = this.getTypeName()) {
            case "array": {
                return "[" + this.getTypeArguments().get(0).toDescriptor();
            }
            case "B": 
            case "S": 
            case "I": 
            case "J": 
            case "F": 
            case "D": 
            case "Z": 
            case "C": 
            case "V": {
                return typeName;
            }
        }
        return 'L' + typeName + ';';
    }

    public final String toSignature() {
        String typeName;
        switch (typeName = this.getTypeName()) {
            case "array": {
                return "[" + this.getTypeArgument(0).toSignature();
            }
            case "B": 
            case "S": 
            case "I": 
            case "J": 
            case "F": 
            case "D": 
            case "Z": 
            case "C": 
            case "V": {
                return typeName;
            }
        }
        List<TypeSignature> typeArgumentSignatures = this.getTypeArguments();
        String typeArguments = typeArgumentSignatures.isEmpty() ? "" : this.getTypeArguments().stream().map(TypeSignature::toSignature).collect(Collectors.joining("", "<", ">"));
        return "L" + typeName + typeArguments + ";";
    }

    public int hashCode() {
        return Objects.hash(this.getTypeName(), this.getTypeArguments());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypeSignature)) {
            return false;
        }
        TypeSignature that = (TypeSignature)obj;
        return Objects.equals(this.getTypeName(), that.getTypeName()) && Objects.equals(this.getTypeArguments(), that.getTypeArguments());
    }

    public String toString() {
        return "TypeSignature(typeName=" + this.getTypeName() + ", typeArguments=" + this.getTypeArguments() + ")";
    }

    private static class MySignatureVisitor
    extends SignatureVisitor {
        private String rawTypeName;
        private final List<MySignatureVisitor> typeArgs = new ArrayList<MySignatureVisitor>(0);

        private MySignatureVisitor() {
            super(589824);
        }

        @Override
        public void visitBaseType(char descriptor) {
            this.rawTypeName = "" + descriptor;
            super.visitBaseType(descriptor);
        }

        @Override
        public void visitTypeVariable(String name) {
            this.rawTypeName = "java/lang/Object";
            super.visitTypeVariable(name);
        }

        @Override
        public SignatureVisitor visitArrayType() {
            this.rawTypeName = TypeSignature.ARRAY;
            MySignatureVisitor child = new MySignatureVisitor();
            this.typeArgs.add(child);
            return child;
        }

        @Override
        public void visitClassType(String name) {
            this.rawTypeName = name;
            super.visitClassType(name);
        }

        @Override
        public void visitInnerClassType(String name) {
            this.rawTypeName = this.rawTypeName + '$' + name;
            this.typeArgs.clear();
            super.visitInnerClassType(name);
        }

        @Override
        public void visitTypeArgument() {
            super.visitTypeArgument();
        }

        @Override
        public SignatureVisitor visitTypeArgument(char wildcard) {
            MySignatureVisitor child = new MySignatureVisitor();
            this.typeArgs.add(child);
            return child;
        }

        @Override
        public void visitEnd() {
            assert (this.rawTypeName != null) : "end of type signature visitor, didn't set a type name";
            super.visitEnd();
        }
    }
}

