/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.bytecode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import xyz.janboerman.scalaloader.libs.asm.Opcodes;
import xyz.janboerman.scalaloader.libs.asm.Type;

public final class OperandStack {
    private int maxCount = 0;
    private final ArrayList<Type> operandTypes = new ArrayList(3);

    public void push(Type type) {
        if (!Type.VOID_TYPE.equals(type)) {
            this.operandTypes.add(type);
            this.maxCount = Math.max(this.maxCount, this.stackSize());
        }
    }

    public void push(Type ... types) {
        for (Type type : types) {
            if (Type.VOID_TYPE.equals(type)) continue;
            this.operandTypes.add(type);
        }
        this.maxCount = Math.max(this.maxCount, this.stackSize());
    }

    public Type replaceTop(Type type) {
        int lastIndex = this.operandTypes.size() - 1;
        Type lastElement = this.operandTypes.get(lastIndex);
        if (Type.VOID_TYPE.equals(type)) {
            this.operandTypes.remove(lastIndex);
        } else {
            this.operandTypes.set(lastIndex, type);
            this.maxCount = Math.max(this.maxCount, this.stackSize());
        }
        return lastElement;
    }

    public void replaceTop(int popAmount, Type type) {
        this.pop(popAmount);
        this.push(type);
    }

    public Type pop() {
        assert (!this.operandTypes.isEmpty()) : "can't pop from an empty stack";
        int lastIndex = this.operandTypes.size() - 1;
        Type operandType = this.operandTypes.remove(lastIndex);
        return operandType;
    }

    public void pop(int amount) {
        int initialSize = this.operandTypes.size();
        assert (initialSize >= amount) : "Tried to pop more operands than available (pop=" + amount + ", available=" + initialSize + ")";
        for (int i = 0; i < amount; ++i) {
            this.operandTypes.remove(initialSize - 1 - i);
        }
    }

    public int stackSize() {
        int size = 0;
        for (Type operandType : this.operandTypes) {
            size += operandType.getSize();
        }
        return size;
    }

    public int operandsSize() {
        return this.operandTypes.size();
    }

    public int maxStack() {
        return this.maxCount;
    }

    public List<Type> getOperands() {
        return Collections.unmodifiableList(this.operandTypes);
    }

    public Object[] frame() {
        return this.operandTypes.stream().map(type -> {
            String internalName;
            switch (internalName = type.getInternalName()) {
                case "B": 
                case "S": 
                case "I": 
                case "C": 
                case "Z": {
                    return Opcodes.INTEGER;
                }
                case "J": {
                    return Opcodes.LONG;
                }
                case "F": {
                    return Opcodes.FLOAT;
                }
                case "D": {
                    return Opcodes.DOUBLE;
                }
                case "V": {
                    return Opcodes.TOP;
                }
            }
            return internalName;
        }).toArray();
    }

    public String toString() {
        return this.operandTypes.toString();
    }
}

