/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.bytecode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import xyz.janboerman.scalaloader.libs.asm.Type;
import xyz.janboerman.scalaloader.libs.asm.signature.SignatureReader;
import xyz.janboerman.scalaloader.libs.asm.signature.SignatureVisitor;
import xyz.janboerman.scalaloader.libs.asm.signature.SignatureWriter;

public final class MethodHeader {
    public final int access;
    public final String name;
    public final String descriptor;
    public final String signature;
    public final String[] exceptions;
    private Type[] argumentTypes;
    private Type returnType;
    private String returnSignature;
    private String[] parameterSignatures;
    boolean initSignatures;

    public MethodHeader(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.access = access;
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        this.exceptions = exceptions;
    }

    public String getReturnDescriptor() {
        if (this.returnType == null) {
            this.returnType = Type.getReturnType(this.descriptor);
        }
        return this.returnType.getDescriptor();
    }

    public String getParameterDescriptor(int index) {
        if (this.argumentTypes == null) {
            this.argumentTypes = Type.getArgumentTypes(this.descriptor);
        }
        return this.argumentTypes[index].getDescriptor();
    }

    public String getReturnSignature() {
        if (!this.initSignatures) {
            this.initSignatures();
        }
        if (this.returnSignature == null) {
            return null;
        }
        return this.returnSignature;
    }

    public String getParameterSignature(int index) {
        if (!this.initSignatures) {
            this.initSignatures();
        }
        if (this.parameterSignatures == null) {
            return null;
        }
        return this.parameterSignatures[index];
    }

    private void initSignatures() {
        this.initSignatures = true;
        if (this.signature == null) {
            return;
        }
        SignatureReader signatureReader = new SignatureReader(this.signature);
        signatureReader.accept(new SignatureVisitor(589824){
            List<String> parameterSignatures;

            @Override
            public SignatureVisitor visitParameterType() {
                return new SignatureWriter(){

                    @Override
                    public void visitEnd() {
                        super.visitEnd();
                        if (parameterSignatures == null) {
                            parameterSignatures = new ArrayList<String>(1);
                        }
                        parameterSignatures.add(super.toString());
                    }
                };
            }

            @Override
            public SignatureVisitor visitReturnType() {
                return new SignatureWriter(){

                    @Override
                    public void visitEnd() {
                        super.visitEnd();
                        MethodHeader.this.returnSignature = super.toString();
                    }
                };
            }

            @Override
            public void visitEnd() {
                super.visitEnd();
                if (this.parameterSignatures != null) {
                    MethodHeader.access$102(MethodHeader.this, this.parameterSignatures.toArray(new String[0]));
                }
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodHeader)) {
            return false;
        }
        MethodHeader that = (MethodHeader)o;
        return this.access == that.access && this.name.equals(that.name) && this.descriptor.equals(that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.access, this.name, this.descriptor);
    }

    public String toString() {
        String accessString = (this.access & 2) == 2 ? "private " : ((this.access & 4) == 4 ? "protected " : ((this.access & 1) == 1 ? "public " : "(package-private) "));
        StringBuilder stringBuilder = new StringBuilder(accessString);
        if ((this.access & 8) == 8) {
            stringBuilder.append("static ");
        }
        stringBuilder.append(this.name);
        stringBuilder.append(' ');
        if (this.signature != null) {
            stringBuilder.append(this.signature);
        } else {
            stringBuilder.append(this.descriptor);
        }
        if (this.exceptions != null) {
            stringBuilder.append("throws ");
            stringBuilder.append(Arrays.toString(this.exceptions));
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ String[] access$102(MethodHeader x0, String[] x1) {
        x0.parameterSignatures = x1;
        return x1;
    }
}

