/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.bytecode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import xyz.janboerman.scalaloader.bytecode.LocalVariable;
import xyz.janboerman.scalaloader.libs.asm.Opcodes;
import xyz.janboerman.scalaloader.libs.asm.Type;

public final class LocalVariableTable
implements Iterable<LocalVariable> {
    private int maxCount = 0;
    private final Set<LocalVariable> localVariables = new LinkedHashSet<LocalVariable>();
    private final ArrayList<LocalVariable> frameData = new ArrayList(0);

    public void add(LocalVariable localVariable) {
        assert (localVariable != null) : "can't add a null localVariable";
        int tableSlot = localVariable.tableSlot;
        int frameIndex = localVariable.frameIndex;
        assert (0 <= tableSlot) : "index in the local variable table below 0";
        assert (tableSlot <= this.maxLocals()) : "local variable " + localVariable + " is more than 1 higher than the currently known highest local variable in the table " + this + ", maxLocals = " + this.maxLocals();
        assert (tableSlot <= this.localsSize()) : "local variable " + localVariable + " does not 'replace' another, nor, is it the 'next' local variable in the table " + this;
        assert (frameIndex == this.frameData.size()) : "local variable " + localVariable + " can't be appended at the end of the frame: " + this.frameData;
        this.localVariables.add(localVariable);
        this.maxCount = Math.max(this.maxCount, tableSlot + Type.getType(localVariable.descriptor).getSize());
        this.addFrame(localVariable);
        assert (this.frameData.stream().noneMatch(Objects::isNull)) : "a local variable in the frame is null";
        assert (IntStream.range(0, this.frameData.size()).allMatch(index -> this.frameData.get((int)index).frameIndex == index));
    }

    public void add(LocalVariable ... localVariables) {
        for (LocalVariable localVariable : localVariables) {
            assert (localVariable != null) : "local variable can't be null!";
            this.localVariables.add(localVariable);
            this.maxCount = Math.max(this.maxCount, localVariable.tableSlot + Type.getType(localVariable.descriptor).getSize());
            this.addFrame(localVariable);
        }
        assert (this.noGapsBetweenEntries());
        assert (this.frameData.stream().allMatch(Objects::nonNull)) : "a local variable in the frame is null";
        assert (IntStream.range(0, this.frameData.size()).allMatch(index -> this.frameData.get((int)index).frameIndex == index));
    }

    private boolean noGapsBetweenEntries() {
        Set indicesToGo = IntStream.range(0, this.localsSize()).collect(HashSet::new, Set::add, Set::addAll);
        for (LocalVariable local : this) {
            int size = Type.getType(local.descriptor).getSize();
            for (int i = local.tableSlot; i < local.tableSlot + size; ++i) {
                indicesToGo.remove(i);
            }
        }
        return indicesToGo.isEmpty();
    }

    private void addFrame(LocalVariable localVariable) {
        assert (localVariable != null) : "local variable can't be null!";
        int frameIndex = localVariable.frameIndex;
        if (frameIndex < this.frameData.size()) {
            this.frameData.set(frameIndex, localVariable);
        } else if (frameIndex == this.frameData.size()) {
            this.frameData.add(localVariable);
        } else {
            for (int i = this.frameData.size(); i < frameIndex; ++i) {
                this.frameData.add(null);
            }
            this.addFrame(localVariable);
            assert (this.frameData.get(this.frameData.size() - 1) != null) : "last local in the frame cannot be null!";
        }
    }

    public int maxLocals() {
        return this.maxCount;
    }

    private int localsSize() {
        return this.localVariables.stream().mapToInt(local -> Type.getType(local.descriptor).getSize()).sum();
    }

    public void removeFramesFromIndex(int frameIndex) {
        int size = this.frameData.size();
        for (int i = size - 1; i >= frameIndex; --i) {
            this.frameData.remove(i);
        }
        this.frameData.trimToSize();
        assert (this.frameData.stream().noneMatch(Objects::isNull)) : "there is a null localvariable in the frame data";
    }

    @Override
    public Iterator<LocalVariable> iterator() {
        return this.getLocalVariables().iterator();
    }

    public Set<LocalVariable> getLocalVariables() {
        return Collections.unmodifiableSet(this.localVariables);
    }

    public List<LocalVariable> getFrameLocals() {
        return Collections.unmodifiableList(this.frameData);
    }

    public Object[] frame() {
        return this.frameData.stream().map(localVariable -> {
            String desc;
            switch (desc = localVariable.descriptor) {
                case "B": 
                case "S": 
                case "I": 
                case "C": 
                case "Z": {
                    return Opcodes.INTEGER;
                }
                case "J": {
                    return Opcodes.LONG;
                }
                case "F": {
                    return Opcodes.FLOAT;
                }
                case "D": {
                    return Opcodes.DOUBLE;
                }
                case "V": {
                    return Opcodes.TOP;
                }
            }
            return Type.getType(desc).getInternalName();
        }).toArray();
    }

    public String toString() {
        return this.localVariables.toString();
    }
}

