/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.bytecode;

import xyz.janboerman.scalaloader.libs.asm.Type;

public final class LocalCounter
implements Cloneable {
    private int nextSlot;
    private int nextFrame;

    public LocalCounter() {
    }

    public LocalCounter(int slotIndex, int frameIndex) {
        this.reset(slotIndex, frameIndex);
    }

    public int getSlotIndex() {
        return this.nextSlot;
    }

    public int getFrameIndex() {
        return this.nextFrame;
    }

    public void reset(int slotIndex, int frameIndex) {
        this.nextSlot = slotIndex;
        this.nextFrame = frameIndex;
    }

    public void add(Type type) {
        assert (!Type.VOID_TYPE.equals(type)) : "Tried to store a variable of type 'void' in the local variable table";
        this.nextSlot += type.getSize();
        ++this.nextFrame;
    }

    public LocalCounter clone() {
        return new LocalCounter(this.nextSlot, this.nextFrame);
    }

    public String toString() {
        return "LocalCounter[slot=" + this.getSlotIndex() + ",frame=" + this.getFrameIndex() + "]";
    }
}

