/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader;

import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ScalaRelease
implements Comparable<ScalaRelease> {
    private static final Comparator<String> AS_INT_COMPARATOR = Comparator.comparingInt(Integer::parseInt);
    private static final Pattern VERSION_SCHEME = Pattern.compile("(?<epoch>\\d+)\\.(?<major>\\d+)\\.(?<minor>\\d+).*");
    public static final Comparator<String> VERSION_COMPARATOR = (first, second) -> {
        Matcher matcher1 = VERSION_SCHEME.matcher((CharSequence)first);
        Matcher matcher2 = VERSION_SCHEME.matcher((CharSequence)second);
        if (matcher1.matches() && matcher2.matches()) {
            String minor2;
            String major2;
            String epoch2;
            String epoch1 = matcher1.group("epoch");
            int res = AS_INT_COMPARATOR.compare(epoch1, epoch2 = matcher2.group("epoch"));
            if (res != 0) {
                return res;
            }
            String major1 = matcher1.group("major");
            res = AS_INT_COMPARATOR.compare(major1, major2 = matcher2.group("major"));
            if (res != 0) {
                return res;
            }
            String minor1 = matcher1.group("minor");
            res = AS_INT_COMPARATOR.compare(minor1, minor2 = matcher2.group("minor"));
            if (res != 0) {
                return res;
            }
            int endMinor1 = matcher1.end("minor");
            int endMinor2 = matcher2.end("minor");
            return first.substring(endMinor1).compareTo(second.substring(endMinor2));
        }
        return first.compareTo((String)second);
    };
    private static final ScalaRelease SCALA_2_11 = new ScalaRelease("2.11");
    public static final ScalaRelease SCALA_2_12 = new ScalaRelease("2.12");
    public static final ScalaRelease SCALA_2_13 = new ScalaRelease("2.13");
    public static final ScalaRelease SCALA_3_0 = new ScalaRelease("3.0");
    public static final ScalaRelease SCALA_3_1 = new ScalaRelease("3.1");
    private static final ScalaRelease SCALA_3_2 = new ScalaRelease("3.2");
    private final String compatVersion;

    private ScalaRelease(String compatVersion) {
        this.compatVersion = compatVersion;
    }

    public static ScalaRelease fromScalaVersion(String scalaVersion) {
        Objects.requireNonNull(scalaVersion, "scalaVersion cannot be null!");
        if (scalaVersion.startsWith("2.11.")) {
            return SCALA_2_11;
        }
        if (scalaVersion.startsWith("2.12.")) {
            return SCALA_2_12;
        }
        if (scalaVersion.startsWith("2.13.")) {
            return SCALA_2_13;
        }
        if (scalaVersion.startsWith("3.0.")) {
            return SCALA_3_0;
        }
        if (scalaVersion.startsWith("3.1.")) {
            return SCALA_3_1;
        }
        int lastDot = scalaVersion.lastIndexOf(46);
        String compatVersion = lastDot != -1 ? scalaVersion.substring(0, lastDot) : scalaVersion;
        return new ScalaRelease(compatVersion);
    }

    public String getCompatVersion() {
        return this.compatVersion;
    }

    public String toString() {
        return "ScalaRelease " + this.compatVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScalaRelease)) {
            return false;
        }
        ScalaRelease that = (ScalaRelease)o;
        return this.compatVersion.equals(that.compatVersion);
    }

    public int hashCode() {
        return this.compatVersion.hashCode();
    }

    @Override
    public int compareTo(ScalaRelease that) {
        int thatEpoch;
        String[] thisVersions = this.compatVersion.split("\\.");
        String[] thatVersions = that.compatVersion.split("\\.");
        int thisEpoch = Integer.parseInt(thisVersions[0]);
        int res = Integer.compare(thisEpoch, thatEpoch = Integer.parseInt(thatVersions[0]));
        if (res != 0) {
            return res;
        }
        int thisMajor = Integer.parseInt(thisVersions[1]);
        int thatMajor = Integer.parseInt(thatVersions[1]);
        res = Integer.compare(thisMajor, thatMajor);
        return res;
    }
}

