/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import xyz.janboerman.scalaloader.DebugSettings;
import xyz.janboerman.scalaloader.ScalaLibraryClassLoader;
import xyz.janboerman.scalaloader.ScalaRelease;
import xyz.janboerman.scalaloader.commands.DumpClass;
import xyz.janboerman.scalaloader.commands.ListScalaPlugins;
import xyz.janboerman.scalaloader.commands.ResetScalaUrls;
import xyz.janboerman.scalaloader.commands.SetDebug;
import xyz.janboerman.scalaloader.compat.Compat;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.BigDecimal;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.BigInteger;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.Either;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.NumericRange;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.Option;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.Primitives;
import xyz.janboerman.scalaloader.configurationserializable.runtime.types.UUID;
import xyz.janboerman.scalaloader.libs.bstats.bukkit.Metrics;
import xyz.janboerman.scalaloader.libs.bstats.charts.DrilldownPie;
import xyz.janboerman.scalaloader.plugin.PluginScalaVersion;
import xyz.janboerman.scalaloader.plugin.ScalaPlugin;
import xyz.janboerman.scalaloader.plugin.ScalaPluginLoader;
import xyz.janboerman.scalaloader.plugin.ScalaPluginLoaderException;
import xyz.janboerman.scalaloader.plugin.description.ScalaVersion;
import xyz.janboerman.scalaloader.plugin.runtime.ClassFile;

public final class ScalaLoader
extends JavaPlugin {
    private final Map<String, ScalaLibraryClassLoader> scalaLibraryClassLoaders = new HashMap<String, ScalaLibraryClassLoader>();
    private final DebugSettings debugSettings = new DebugSettings(this);
    private final boolean iActuallyManagedToOverrideTheDefaultJavaPluginLoader;
    private final File scalaPluginsFolder;
    private JavaPluginLoader weFoundTheJavaPluginLoader;
    private Map<Pattern, PluginLoader> pluginLoaderMap;
    private Pattern[] javaPluginLoaderPatterns;
    private final Map<File, UnknownDependencyException> scalaPluginsWaitingOnJavaPlugins = new HashMap<File, UnknownDependencyException>();

    public ScalaLoader() {
        boolean myHackWorked;
        this.scalaPluginsFolder = new File(this.getDataFolder(), "scalaplugins");
        if (!this.scalaPluginsFolder.exists()) {
            this.scalaPluginsFolder.mkdirs();
        }
        Server server = Bukkit.getServer();
        try {
            SimplePluginManager pluginManager = (SimplePluginManager)server.getPluginManager();
            Field fileAssociationsField = pluginManager.getClass().getDeclaredField("fileAssociations");
            fileAssociationsField.setAccessible(true);
            this.pluginLoaderMap = (Map)fileAssociationsField.get(pluginManager);
            Iterator<Map.Entry<Pattern, PluginLoader>> iterator = this.pluginLoaderMap.entrySet().iterator();
            ScalaPluginLoader scalaPluginLoader = new ScalaPluginLoader(this);
            while (iterator.hasNext()) {
                Map.Entry<Pattern, PluginLoader> entry = iterator.next();
                if (!(entry.getValue() instanceof JavaPluginLoader)) continue;
                this.weFoundTheJavaPluginLoader = (JavaPluginLoader)entry.getValue();
                this.javaPluginLoaderPatterns = this.weFoundTheJavaPluginLoader.getPluginFileFilters();
                entry.setValue(scalaPluginLoader);
            }
            myHackWorked = true;
        }
        catch (Throwable iGiveUp) {
            myHackWorked = false;
            this.getLogger().log(Level.WARNING, "Error while trying to replace the standard JavaPluginLoader.", iGiveUp);
        }
        this.iActuallyManagedToOverrideTheDefaultJavaPluginLoader = myHackWorked;
        if (this.iActuallyManagedToOverrideTheDefaultJavaPluginLoader) {
            this.getLogger().info("Managed to override the default .jar file association!");
        } else {
            this.getLogger().info("Did not manage to override the default .jar file association. Plugins may not load in the expected order.");
        }
    }

    public DebugSettings getDebugSettings() {
        return this.debugSettings;
    }

    public File getScalaPluginsFolder() {
        return this.scalaPluginsFolder;
    }

    public Pattern[] getJavaPluginLoaderPatterns() {
        return this.javaPluginLoaderPatterns;
    }

    public void onLoad() {
        this.configure();
        if (this.iActuallyManagedToOverrideTheDefaultJavaPluginLoader) {
            for (File file : this.scalaPluginsFolder.listFiles((dir, name) -> name.endsWith(".jar"))) {
                try {
                    this.getServer().getPluginManager().loadPlugin(file);
                }
                catch (UnknownDependencyException ude) {
                    ScalaPluginLoader.getInstance().loadWhenDependenciesComeAvailable(file);
                    this.scalaPluginsWaitingOnJavaPlugins.put(file, ude);
                }
                catch (InvalidDescriptionException | InvalidPluginException e) {
                    this.getLogger().log(Level.SEVERE, "Could not load plugin from file: " + file.getAbsolutePath(), e);
                }
            }
        } else {
            this.getServer().getPluginManager().registerInterface(ScalaPluginLoader.class);
        }
    }

    public void onEnable() {
        this.getCommand("resetScalaUrls").setExecutor((CommandExecutor)new ResetScalaUrls(this));
        this.getCommand("dumpClass").setExecutor((CommandExecutor)new DumpClass(this));
        this.getCommand("setDebug").setExecutor((CommandExecutor)new SetDebug(this.getDebugSettings()));
        this.getCommand("listScalaPlugins").setExecutor((CommandExecutor)new ListScalaPlugins());
        if (this.iActuallyManagedToOverrideTheDefaultJavaPluginLoader) {
            Iterator<File> iterator = ScalaPluginLoader.getInstance().getPluginsWaitingForDependencies().iterator();
            if (iterator.hasNext()) {
                File file = iterator.next();
                UnknownDependencyException ude = this.scalaPluginsWaitingOnJavaPlugins.get(file);
                assert (ude != null) : "found plugin file that didn't load, but hasn't got any missing dependencies: " + file.getAbsolutePath();
                throw ude;
            }
            this.scalaPluginsWaitingOnJavaPlugins.clear();
            ScalaPluginLoader.getInstance().clearPluginsWaitingForDependencies();
        } else {
            Plugin[] plugins;
            for (Plugin plugin : plugins = this.getServer().getPluginManager().loadPlugins(this.scalaPluginsFolder)) {
                this.getServer().getPluginManager().enablePlugin(plugin);
            }
        }
        int pluginId = 9150;
        Metrics metrics = new Metrics(this, 9150);
        metrics.addCustomChart(new DrilldownPie("declared_scala_version", () -> {
            HashMap<String, Map> stats = new HashMap<String, Map>();
            for (ScalaPlugin scalaPlugin : ScalaPluginLoader.getInstance().getScalaPlugins()) {
                String scalaVersion = scalaPlugin.getDeclaredScalaVersion();
                String compatVersion = ScalaRelease.fromScalaVersion(scalaVersion).getCompatVersion();
                stats.computeIfAbsent(compatVersion, k -> new HashMap()).compute(scalaVersion, (v, amount) -> amount == null ? 1 : amount + 1);
            }
            return stats;
        }));
    }

    public void onDisable() {
    }

    @Deprecated
    public void runInMainThread(Runnable runnable) {
        Server server = this.getServer();
        if (server.isPrimaryThread()) {
            runnable.run();
        } else {
            server.getScheduler().runTask((Plugin)this, runnable);
        }
    }

    private void configure() {
        this.saveDefaultConfig();
        PluginScalaVersion.register();
        ClassFile.register();
        FileConfiguration config = this.getConfig();
        if (!config.isList("scala-versions")) {
            this.getConfig().set("scala-versions", Arrays.stream(ScalaVersion.values()).map(PluginScalaVersion::fromScalaVersion).collect(Collectors.toList()));
            this.saveConfig();
        }
        Primitives.registerWithConfigurationSerialization();
        NumericRange.registerWithConfigurationSerialization();
        UUID.registerWithConfigurationSerialization();
        BigInteger.registerWithConfigurationSerialization();
        BigDecimal.registerWithConfigurationSerialization();
        Option.registerWithConfigurationSerialization();
        Either.registerWithConfigurationSerialization();
    }

    private boolean downloadScalaJarFiles() {
        return this.getConfig().getBoolean("load-libraries-from-disk", true);
    }

    public ScalaLibraryClassLoader loadOrGetScalaVersion(PluginScalaVersion scalaVersion) throws ScalaPluginLoaderException {
        int i;
        ScalaLibraryClassLoader scalaLibraryLoader = this.scalaLibraryClassLoaders.get(scalaVersion.getScalaVersion());
        if (scalaLibraryLoader != null) {
            return scalaLibraryLoader;
        }
        if (!this.downloadScalaJarFiles()) {
            this.getLogger().info("Loading Scala " + scalaVersion + " libraries from over the network");
            try {
                Map<String, String> urlMap = scalaVersion.getUrls();
                URL[] urls = new URL[urlMap.size()];
                int i2 = 0;
                for (String url : urlMap.values()) {
                    urls[i2++] = new URL(url);
                }
                scalaLibraryLoader = new ScalaLibraryClassLoader(scalaVersion.getScalaVersion(), urls, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (MalformedURLException e) {
                throw new ScalaPluginLoaderException("Could not load scala libraries for version " + scalaVersion + " due to a malformed URL", e);
            }
        }
        File scalaLibsFolder = new File(this.getDataFolder(), "scalalibraries");
        File versionFolder = new File(scalaLibsFolder, scalaVersion.getScalaVersion());
        versionFolder.mkdirs();
        File[] jarFiles = versionFolder.listFiles((dir, name) -> name.endsWith(".jar"));
        if (jarFiles.length == 0) {
            this.getLogger().info("Tried to load Scala " + scalaVersion + " libraries from disk, but they were not present. Downloading...");
            Map<String, String> urlMap = scalaVersion.getUrls();
            jarFiles = new File[urlMap.size()];
            i = 0;
            for (Map.Entry<String, String> entry : urlMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String fileName = key.endsWith("-url") ? key.substring(0, key.length() - 3) + scalaVersion.getScalaVersion() + ".jar" : (key.endsWith(".jar") ? key : key + "-" + scalaVersion.getScalaVersion() + ".jar");
                File scalaRuntimeJarFile = new File(versionFolder, fileName);
                try {
                    scalaRuntimeJarFile.createNewFile();
                }
                catch (IOException e) {
                    throw new ScalaPluginLoaderException("Could not create new jar file", e);
                }
                try {
                    URL url = new URL(value);
                    ScalaLoader.downloadFile(url, scalaRuntimeJarFile);
                }
                catch (MalformedURLException e) {
                    throw new ScalaPluginLoaderException("Invalid url for key: " + key, e);
                }
                catch (IOException e) {
                    throw new ScalaPluginLoaderException("Could not open or close channel", e);
                }
                jarFiles[i++] = scalaRuntimeJarFile;
            }
        }
        this.getLogger().info("Loading Scala " + scalaVersion.getScalaVersion() + " libraries from disk");
        URL[] urls = new URL[jarFiles.length];
        for (i = 0; i < jarFiles.length; ++i) {
            try {
                urls[i] = jarFiles[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new ScalaPluginLoaderException("Could not load Scala libraries for version " + scalaVersion.getScalaVersion() + " due to a malformed URL", e);
            }
        }
        scalaLibraryLoader = new ScalaLibraryClassLoader(scalaVersion.getScalaVersion(), urls, ((Object)((Object)this)).getClass().getClassLoader());
        this.scalaLibraryClassLoaders.put(scalaVersion.getScalaVersion(), scalaLibraryLoader);
        return scalaLibraryLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadFile(URL inputResourceLocation, File outputFile) throws IOException {
        ReadableByteChannel rbc = null;
        FileOutputStream fos = null;
        try {
            rbc = Channels.newChannel(inputResourceLocation.openStream());
            fos = new FileOutputStream(outputFile);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        finally {
            if (rbc != null) {
                try {
                    rbc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean saveScalaVersionsToConfig(PluginScalaVersion ... versions) {
        FileConfiguration config = this.getConfig();
        LinkedHashSet<PluginScalaVersion> scalaVersions = new LinkedHashSet<PluginScalaVersion>(Compat.listOf(versions));
        boolean wasAdded = scalaVersions.addAll(config.getList("scala-versions", Compat.emptyList()));
        config.set("scala-versions", Compat.listCopy(scalaVersions));
        this.saveConfig();
        return wasAdded;
    }
}

