/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import xyz.janboerman.scalaloader.ScalaLoader;
import xyz.janboerman.scalaloader.compat.Compat;

public class DebugSettings {
    private static final String FILE_NAME = "debug.yml";
    private static final String CLASS_NAMES = "class-names";
    private static final String FORMAT = "format";
    private static final String ANALYSIS = "analysis";
    public static final String TEXTIFIED = "Textified";
    public static final String ASMIFIED = "ASMified";
    private static final String LOG_MISSING_CODECS = "log-missing-codecs";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String ENABLED_WHEN_JVM_ASSERTIONS_ARE_ENABLED = "enabled-when-jvm-assertions-are-enabled";
    private final ScalaLoader scalaLoader;
    private File saveFile;
    private final Set<String> classNames = Collections.synchronizedSet(new LinkedHashSet());
    private String format = "Textified";
    private final Object formatLock = new Object();
    private MissingCodecLog missingCodecLog = MissingCodecLog.Default();
    private boolean logMissingCodecs = true;

    public DebugSettings(ScalaLoader scalaLoader) {
        this.scalaLoader = scalaLoader;
        this.saveFile = new File(scalaLoader.getDataFolder(), FILE_NAME);
        if (this.saveFile.exists()) {
            try {
                this.load();
            }
            catch (IOException e) {
                scalaLoader.getLogger().log(Level.WARNING, "Could not load debug classes.", e);
            }
        }
    }

    public Set<String> debugClassLoads() {
        return Collections.unmodifiableSet(this.classNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormat() {
        Object object = this.formatLock;
        synchronized (object) {
            return this.format;
        }
    }

    public boolean isDebuggingClassLoadOf(String className) {
        return this.classNames.contains(className);
    }

    public boolean debugClass(String className) {
        this.classNames.add(className);
        try {
            this.save();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean undebugClass(String className) {
        this.classNames.remove(className);
        try {
            this.save();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean logMissingCodecs() {
        return this.logMissingCodecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        if (this.saveFile != null && this.saveFile.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.saveFile);
            List classNames = config.getStringList(CLASS_NAMES);
            this.classNames.clear();
            this.classNames.addAll(classNames);
            String format = config.getString(FORMAT, TEXTIFIED);
            Object object = this.formatLock;
            synchronized (object) {
                this.format = format;
            }
            this.missingCodecLog = MissingCodecLog.fromString(config.getString(LOG_MISSING_CODECS));
            this.logMissingCodecs = this.missingCodecLog.isEnabled();
        }
    }

    private void save() throws IOException {
        YamlConfiguration config = new YamlConfiguration();
        config.set(CLASS_NAMES, Compat.listCopy(this.classNames));
        config.set(FORMAT, (Object)this.getFormat());
        config.set(LOG_MISSING_CODECS, (Object)this.missingCodecLog.toString());
        config.save(this.getSaveFile());
    }

    private File getSaveFile() throws IOException {
        if (!this.saveFile.exists()) {
            this.saveFile.createNewFile();
        }
        return this.saveFile;
    }

    private static final class MissingCodecLog
    extends Enum<MissingCodecLog> {
        public static final /* enum */ MissingCodecLog ENABLED = new MissingCodecLog();
        public static final /* enum */ MissingCodecLog DISABLED = new MissingCodecLog();
        public static final /* enum */ MissingCodecLog ENABLED_WHEN_JVM_ASSERTIONS_ARE_ENABLED = new MissingCodecLog();
        private static final /* synthetic */ MissingCodecLog[] $VALUES;

        public static MissingCodecLog[] values() {
            return (MissingCodecLog[])$VALUES.clone();
        }

        public static MissingCodecLog valueOf(String name) {
            return Enum.valueOf(MissingCodecLog.class, name);
        }

        public String toString() {
            switch (this) {
                case ENABLED: {
                    return DebugSettings.ENABLED;
                }
                case DISABLED: {
                    return DebugSettings.DISABLED;
                }
                case ENABLED_WHEN_JVM_ASSERTIONS_ARE_ENABLED: {
                    return DebugSettings.ENABLED_WHEN_JVM_ASSERTIONS_ARE_ENABLED;
                }
            }
            throw new AssertionError((Object)"unreachable");
        }

        static MissingCodecLog fromString(String string) {
            if (string == null) {
                return MissingCodecLog.Default();
            }
            switch (string) {
                case "enabled": {
                    return ENABLED;
                }
                case "disabled": {
                    return DISABLED;
                }
                case "enabled-when-jvm-assertions-are-enabled": {
                    return ENABLED_WHEN_JVM_ASSERTIONS_ARE_ENABLED;
                }
            }
            return MissingCodecLog.Default();
        }

        public boolean isEnabled() {
            switch (this) {
                case ENABLED: {
                    return true;
                }
                case DISABLED: {
                    return false;
                }
            }
            try {
                assert (false);
                return false;
            }
            catch (AssertionError ae) {
                return true;
            }
        }

        static MissingCodecLog Default() {
            return ENABLED_WHEN_JVM_ASSERTIONS_ARE_ENABLED;
        }

        private static /* synthetic */ MissingCodecLog[] $values() {
            return new MissingCodecLog[]{ENABLED, DISABLED, ENABLED_WHEN_JVM_ASSERTIONS_ARE_ENABLED};
        }

        static {
            $VALUES = MissingCodecLog.$values();
        }
    }
}

