/*
 * Decompiled with CFR 0.152.
 */
package xyz.janboerman.scalaloader.compat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Compat {
    private Compat() {
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        return inputStream.readAllBytes();
    }

    public static <T> List<T> listCopy(Collection<T> collection) {
        return List.copyOf(collection);
    }

    public static <T> List<T> listOf(T ... TArray) {
        return List.of(TArray);
    }

    public static <T> List<T> singletonList(T t) {
        return List.of(t);
    }

    public static <T> List<T> emptyList() {
        return List.of();
    }

    public static <T> Set<T> setCopy(Collection<T> collection) {
        return Set.copyOf(collection);
    }

    public static <T> Set<T> setOf(T ... TArray) {
        return Set.of(TArray);
    }

    public static <T> Set<T> singletonSet(T t) {
        return Set.of(t);
    }

    public static <T> Set<T> emptySet() {
        return Set.of();
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Map.of();
    }

    public static <K, V> Map<K, V> mapCopy(Map<K, V> map) {
        return Map.copyOf(map);
    }

    public static <K, V> Map<K, V> singletonMap(K k, V v) {
        return Map.of(k, v);
    }

    public static <K, V> Map<K, V> mapOf(Map.Entry<K, V> ... entryArray) {
        return Map.ofEntries(entryArray);
    }

    public static <K, V> Map.Entry<K, V> mapEntry(K k, V v) {
        return Map.entry(k, v);
    }

    public static String stringRepeat(String string, int n) {
        return string.repeat(n);
    }

    public static JarFile jarFile(File file) throws IOException {
        return new JarFile(file, true, 1, JarFile.runtimeVersion());
    }

    public static String getPackageName(Class<?> clazz) {
        return clazz.getPackageName();
    }
}

