/*
 * Decompiled with CFR 0.152.
 */
package com.darkender.plugins.rideableenderpearl;

import com.darkender.plugins.rideableenderpearl.ParticleTask;
import com.darkender.plugins.rideableenderpearl.REPCommand;
import com.darkender.plugins.rideableenderpearl.WorldGuardChecker;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.spigotmc.event.entity.EntityDismountEvent;

public class RideableEnderpearl
extends JavaPlugin
implements Listener {
    private ParticleTask particleTask = null;
    private final Set<UUID> allowedDismounts = new HashSet<UUID>();
    private boolean preventSuffocationDamage;
    private boolean preventThrowingWhileRiding;
    private boolean preventDismount;
    private WorldGuardChecker worldGuardChecker = null;

    public void onEnable() {
        this.getLogger().info("Trying to start");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        REPCommand repCommand = new REPCommand(this);
        this.getCommand("rideableenderpearl").setExecutor((CommandExecutor)repCommand);
        this.getCommand("rideableenderpearl").setTabCompleter((TabCompleter)repCommand);
        this.reload();
    }

    public void onLoad() {
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.getLogger().info("Enabling WorldGuard integration");
            this.worldGuardChecker = new WorldGuardChecker();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent event) {
        if (this.preventSuffocationDamage && event.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION && event.getEntity().isInsideVehicle() && event.getEntity().getVehicle().getType() == EntityType.ENDER_PEARL) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (!(event.getEntity().getShooter() instanceof Player) || event.getEntityType() != EntityType.ENDER_PEARL) {
            return;
        }
        Player p = (Player)event.getEntity().getShooter();
        if (!p.hasPermission("rideableenderpearl.ride")) {
            return;
        }
        if (this.worldGuardChecker != null && !this.worldGuardChecker.canRide(p)) {
            return;
        }
        if (this.preventThrowingWhileRiding && p.isInsideVehicle() && p.getVehicle().getType() == EntityType.ENDER_PEARL && !p.getVehicle().isDead()) {
            event.setCancelled(true);
            return;
        }
        event.getEntity().addPassenger((Entity)p);
        if (this.particleTask != null) {
            this.particleTask.addTrack(event.getEntity().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (!this.preventDismount || event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        this.allowedDismounts.add(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerDismountEnderpearl(EntityDismountEvent event) {
        if (!this.preventDismount || event.getEntityType() != EntityType.PLAYER || event.getDismounted().getType() != EntityType.ENDER_PEARL) {
            return;
        }
        Player p = (Player)event.getEntity();
        if (this.allowedDismounts.contains(p.getUniqueId())) {
            this.allowedDismounts.remove(p.getUniqueId());
        } else {
            event.setCancelled(true);
        }
    }

    void reload() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        boolean showParticles = this.getConfig().getBoolean("enderpearl-particles");
        if (showParticles && this.particleTask == null) {
            this.particleTask = new ParticleTask();
            this.particleTask.runTaskTimer((Plugin)this, 1L, 1L);
        } else if (!showParticles && this.particleTask != null) {
            this.particleTask.cancel();
            this.particleTask = null;
        }
        this.preventSuffocationDamage = this.getConfig().getBoolean("prevent-suffocation-damage");
        this.preventThrowingWhileRiding = this.getConfig().getBoolean("prevent-throwing-while-riding");
        this.preventDismount = this.getConfig().getBoolean("prevent-dismount");
    }
}

