/*
 * Decompiled with CFR 0.152.
 */
package me.mindlessly.randomitemchallenge.events;

import java.util.ArrayList;
import java.util.Random;
import me.mindlessly.randomitemchallenge.Main;
import me.mindlessly.randomitemchallenge.commands.Toggle;
import me.mindlessly.randomitemchallenge.utils.ChatUtils;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Event
implements Listener {
    private static ArrayList<Material> materials = new ArrayList();
    private static boolean activated = false;
    public static Main plugin;

    public Event(Main plugin) {
        Event.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public static void enable() {
        if (!activated) {
            materials.clear();
            for (String item : plugin.getConfig().getStringList("items")) {
                Material[] materialArray = Material.values();
                int n = materialArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Material m = materialArray[n2];
                    if (item.equalsIgnoreCase(m.name())) {
                        materials.add(m);
                    }
                    ++n2;
                }
            }
            activated = true;
            for (Player p : Toggle.getWorld().getPlayers()) {
                p.getInventory().clear();
                p.teleport(Toggle.getWorld().getSpawnLocation());
                p.setGameMode(GameMode.SURVIVAL);
                p.setHealth(20.0);
                p.setFoodLevel(20);
            }
        } else {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!activated) {
                    this.cancel();
                }
                if (activated) {
                    World world = Toggle.getWorld();
                    for (Player p : world.getPlayers()) {
                        p.sendMessage(ChatUtils.color("&6&l\u2192ITEM DROP HAS ARRIVED!"));
                        Location spawnitems = p.getLocation();
                        Random random = new Random();
                        int length = materials.size();
                        int rng = random.nextInt(length);
                        ItemStack selected = new ItemStack((Material)materials.get(rng), 1);
                        if (selected.getType().getMaxStackSize() == 16) {
                            selected = new ItemStack((Material)materials.get(rng), 16);
                        } else if (selected.getType().getMaxStackSize() == 1) {
                            selected = new ItemStack((Material)materials.get(rng), 1);
                        } else if (selected.getType().getMaxStackSize() == 64) {
                            selected = new ItemStack((Material)materials.get(rng), 64);
                        }
                        ItemMeta meta = selected.getItemMeta();
                        ArrayList<String> lore = new ArrayList<String>();
                        lore.add(ChatColor.WHITE + p.getName());
                        meta.setLore(lore);
                        selected.setItemMeta(meta);
                        int i = 0;
                        while (i < 36) {
                            world.dropItem(spawnitems, selected);
                            ++i;
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)plugin, 2400L, 2400L);
        new BukkitRunnable(){

            public void run() {
                int survivalmodecount = 0;
                for (Player p : Toggle.getWorld().getPlayers()) {
                    ++survivalmodecount;
                }
                if (survivalmodecount < 2 && Toggle.getWorld().getPlayers().size() > 2) {
                    Event.disable();
                }
            }
        }.runTaskTimer((Plugin)plugin, 5L, 5L);
    }

    public static void disable() {
        if (activated) {
            for (Player p : Toggle.getWorld().getPlayers()) {
                p.getInventory().clear();
                p.setHealth(20.0);
                p.setFoodLevel(20);
                p.teleport(Toggle.getWorld().getSpawnLocation());
                if (p.getGameMode() != GameMode.SPECTATOR) continue;
                p.setGameMode(GameMode.SURVIVAL);
            }
        } else {
            activated = false;
            return;
        }
        activated = false;
    }

    @EventHandler
    public void onDeath(EntityDeathEvent e) {
        if (activated && e.getEntity().getWorld() == Toggle.getWorld() && e.getEntity() instanceof Player) {
            Player p = (Player)e.getEntity();
            p.setGameMode(GameMode.SPECTATOR);
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent e) {
        if (activated && e.getEntity().getWorld() == Toggle.getWorld() && e.getEntity() instanceof Player) {
            Player p = (Player)e.getEntity();
            if (!e.getItem().getItemStack().hasItemMeta()) {
                e.setCancelled(true);
            } else if (!e.getItem().getItemStack().getItemMeta().hasLore()) {
                e.setCancelled(true);
            } else {
                ItemStack item = e.getItem().getItemStack();
                ItemMeta meta = item.getItemMeta();
                ArrayList lore = new ArrayList();
                if (meta.getLore().contains(ChatColor.WHITE + p.getName())) {
                    meta.setLore(lore);
                    item.setItemMeta(meta);
                } else {
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    private void onHungerDeplete(FoodLevelChangeEvent e) {
        if (activated && e.getEntity().getWorld() == Toggle.getWorld()) {
            e.getEntity().setFoodLevel(20);
            e.setCancelled(true);
        }
    }
}

