/*
 * Decompiled with CFR 0.152.
 */
package com.no1inparticular.rtp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    FileConfiguration config;
    List<String> cooldown;

    public void onEnable() {
        this.cooldown = new ArrayList<String>();
        this.config = this.getConfig();
        this.makeConfig();
    }

    public void onDisable() {
    }

    private void makeConfig() {
        this.config.addDefault("limits.cooldown", (Object)60);
        this.config.addDefault("limits.max-attempts", (Object)10);
        this.config.addDefault("limits.seconds-between-attempts", (Object)5);
        this.config.addDefault("limits.world.x.max", (Object)10000);
        this.config.addDefault("limits.world.x.min", (Object)-10000);
        this.config.addDefault("limits.world.z.max", (Object)10000);
        this.config.addDefault("limits.world.z.min", (Object)-10000);
        this.config.addDefault("force-world", (Object)false);
        this.config.addDefault("forced-world", (Object)"world");
        this.config.addDefault("enabled-worlds", Arrays.asList("world"));
        this.config.addDefault("messages.cooldown", (Object)"&cYou can only do this command every 60 seconds.");
        this.config.addDefault("messages.send-attempt-message", (Object)false);
        this.config.addDefault("messages.trying-coords", (Object)"&aAttempting a location.");
        this.config.addDefault("messages.send-trying-again-message", (Object)false);
        this.config.addDefault("messages.trying-again-in", (Object)"&aWill try again in 5 seconds.");
        this.config.addDefault("messages.teleported", (Object)"&aTeleported.");
        this.config.addDefault("messages.not-allowed-in-this-world", (Object)"&cYou can't do this in this world.");
        this.config.addDefault("messages.max-attempts", (Object)"&cCould not find a location, please try again.");
        this.config.addDefault("messages.no-permission", (Object)"&cYou do not have permission for this.");
        this.config.addDefault("messages.reloaded", (Object)"&aConfig reloaded.");
        this.config.addDefault("messages.not-a-player", (Object)"&cYou must be a player to perform this.");
        this.config.options().copyDefaults(true);
        this.saveConfig();
    }

    private String getRandomCoords(String world) {
        int maxX = this.config.getInt("limits." + world + ".x.max");
        int minX = this.config.getInt("limits." + world + ".x.min");
        int maxZ = this.config.getInt("limits." + world + ".z.max");
        int minZ = this.config.getInt("limits." + world + ".z.min");
        Random rnd = new Random();
        int rndX = rnd.nextInt(maxX - minX) + minX;
        int rndZ = rnd.nextInt(maxZ - minZ) + minZ;
        return String.valueOf(rndX) + "," + rndZ;
    }

    private void tryLoc(final Player player, final int attempt) {
        World world = null;
        world = this.config.getBoolean("force-world") ? Bukkit.getWorld((String)this.config.getString("forced-world")) : player.getWorld();
        String xz = this.getRandomCoords(world.getName());
        if (this.config.getBoolean("send-attempt-message")) {
            this.sendMessage((CommandSender)player, "trying-coords");
        }
        Location loc = new Location(world, Double.parseDouble(xz.split(",")[0]) + 0.5, 256.0, Double.parseDouble(xz.split(",")[1]) + 0.5);
        if (world.getEnvironment() == World.Environment.NETHER) {
            loc.setY((double)(world.getHighestBlockYAt(loc) - 4));
        }
        int y = loc.getBlockY();
        while (y > 3) {
            loc.setY((double)y);
            Location blockAbove = loc.clone().add(0.0, 1.0, 0.0);
            Location blockBelow = loc.clone().subtract(0.0, 1.0, 0.0);
            Location blockBelowBelow = loc.clone().subtract(0.0, 2.0, 0.0);
            if (loc.getBlock().getType() == Material.AIR && blockAbove.getBlock().getType() == Material.AIR && blockBelow.getBlock().getType().isSolid() && blockBelow.getBlock().getType() != Material.LAVA && !blockBelow.getBlock().isLiquid() && !blockBelow.getBlock().isPassable() && blockBelowBelow.getBlock().getType().isSolid() && blockBelowBelow.getBlock().getType() != Material.LAVA && !blockBelowBelow.getBlock().isLiquid() && !blockBelowBelow.getBlock().isPassable()) {
                player.teleport(loc);
                this.sendMessage((CommandSender)player, "teleported");
                return;
            }
            --y;
        }
        if (attempt < this.config.getInt("limits.max-attempts")) {
            if (this.config.getBoolean("send-trying-again-message")) {
                this.sendMessage((CommandSender)player, "trying-again-in");
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    Main.this.tryLoc(player, attempt + 1);
                }
            }, (long)(this.config.getInt("limits.seconds-between-attempts") * 20));
        } else {
            this.sendMessage((CommandSender)player, "max-attempts");
        }
    }

    private void sendMessage(CommandSender sender, String messageKey) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("messages." + messageKey)));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("rtp.reload")) {
                this.reloadConfig();
                this.saveConfig();
                this.config = this.getConfig();
                this.sendMessage(sender, "reloaded");
            } else {
                this.sendMessage(sender, "no-permission");
            }
            return false;
        }
        if (sender instanceof Player) {
            final Player player = (Player)sender;
            if (player.hasPermission("rtp.use")) {
                if (this.config.getBoolean("force-world") || this.config.getStringList("enabled-worlds").contains(player.getWorld().getName())) {
                    if (!this.cooldown.contains(player.getName())) {
                        this.sendMessage((CommandSender)player, "trying-coords");
                        this.tryLoc(player, 1);
                        this.cooldown.add(player.getName());
                        Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

                            @Override
                            public void run() {
                                Main.this.cooldown.remove(player.getName());
                            }
                        }, (long)(this.config.getInt("limits.cooldown") * 20));
                    } else {
                        this.sendMessage((CommandSender)player, "cooldown");
                    }
                } else {
                    this.sendMessage((CommandSender)player, "not-allowed-in-this-world");
                }
            } else {
                this.sendMessage((CommandSender)player, "no-permission");
            }
        } else {
            this.sendMessage(sender, "not-a-player");
        }
        return false;
    }
}

