/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.rtp.command;

import java.util.ArrayList;
import java.util.List;
import net.achymake.rtp.RTP;
import net.achymake.rtp.command.RTPSubCommand;
import net.achymake.rtp.command.sub.RTPForceCommand;
import net.achymake.rtp.command.sub.RTPReloadCommand;
import net.achymake.rtp.config.Config;
import net.achymake.rtp.settings.Settings;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RTPCommand
implements CommandExecutor,
TabCompleter {
    private ArrayList<RTPSubCommand> rtpSubCommands = new ArrayList();

    public RTPCommand() {
        this.rtpSubCommands.add(new RTPForceCommand());
        this.rtpSubCommands.add(new RTPReloadCommand());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = (Player)sender;
        if (args.length == 0) {
            if (!RTP.cooldown.containsKey(player.getUniqueId())) {
                RTP.cooldown.put(player.getUniqueId(), System.currentTimeMillis());
                Settings.newLocation(player);
            } else {
                Long timeElapsed = System.currentTimeMillis() - RTP.cooldown.get(player.getUniqueId());
                String cooldownTimer = Config.get().getString("cooldown");
                Integer integer = Integer.valueOf(cooldownTimer.replace(cooldownTimer, cooldownTimer + "000"));
                if (timeElapsed > (long)integer.intValue()) {
                    RTP.cooldown.put(player.getUniqueId(), System.currentTimeMillis());
                    Settings.newLocation(player);
                } else {
                    long timer = (long)integer.intValue() - timeElapsed;
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)("&cYou cannot use this until&f " + String.valueOf(timer).substring(0, String.valueOf(timer).length() - 3) + " &cseconds"))));
                }
            }
        } else {
            for (RTPSubCommand commands : this.getSubCommands()) {
                if (!args[0].equals(commands.getName())) continue;
                commands.perform(player, args);
            }
        }
        return true;
    }

    public ArrayList<RTPSubCommand> getSubCommands() {
        return this.rtpSubCommands;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (sender.hasPermission("rtp.reload")) {
                arrayList.add("reload");
            }
            if (sender.hasPermission("rtp.force")) {
                arrayList.add("force");
            }
            return arrayList;
        }
        return null;
    }
}

