/*
 * Decompiled with CFR 0.152.
 */
package de.tutorialwork.main;

import de.tutorialwork.commands.Credit;
import de.tutorialwork.commands.DelHome;
import de.tutorialwork.commands.DelWarp;
import de.tutorialwork.commands.Home;
import de.tutorialwork.commands.Homes;
import de.tutorialwork.commands.SetHome;
import de.tutorialwork.commands.SetLobby;
import de.tutorialwork.commands.SetSpawn;
import de.tutorialwork.commands.SetWarp;
import de.tutorialwork.commands.Spawn;
import de.tutorialwork.commands.TPA;
import de.tutorialwork.commands.TPAAccept;
import de.tutorialwork.commands.TPADeny;
import de.tutorialwork.commands.TPAToggle;
import de.tutorialwork.commands.Warp;
import de.tutorialwork.commands.Warps;
import de.tutorialwork.commands.WorldTP;
import de.tutorialwork.listener.Join;
import de.tutorialwork.listener.Lift;
import de.tutorialwork.listener.LobbySwitcherGUI;
import de.tutorialwork.listener.TeleportGUIClick;
import de.tutorialwork.utils.Metrics;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public static Main main;
    public static String Prefix;
    public static String NoPerms;
    public static String Version;
    public static Integer maxHomes;
    public static Integer maxPremiumHomes;
    public static boolean spawntp;
    public static boolean homeModule;
    public static boolean warpModule;
    public static boolean spawnModule;
    public static boolean lobbyModule;
    public static boolean elevatorModule;

    public void onEnable() {
        main = this;
        this.Config();
        this.Commands();
        this.Listener();
        this.checkVersion();
        Metrics metrics = new Metrics((Plugin)this);
    }

    private void checkVersion() {
        if (!Main.callURL("https://api.spigotmc.org/legacy/update.php?resource=70674").equals(Version)) {
            Bukkit.getConsoleSender().sendMessage("\u00a78[]===================================[]");
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lProfessionalTeleport \u00a78| \u00a77Version: \u00a7c" + Version);
            Bukkit.getConsoleSender().sendMessage("\u00a7cYou use a \u00a7c\u00a7lOUTDATED \u00a7cversion of this plugin!");
            Bukkit.getConsoleSender().sendMessage("\u00a77Update: \u00a74\u00a7lhttps://spigotmc.org/resources/70674");
            Bukkit.getConsoleSender().sendMessage("\u00a78[]===================================[]");
        }
    }

    private void Config() {
        File spawn;
        File warps;
        File homes;
        File ordner = new File(this.getDataFolder().getPath());
        if (!ordner.exists()) {
            ordner.mkdirs();
        }
        if (!(homes = new File(this.getDataFolder().getPath(), "homes.yml")).exists()) {
            try {
                homes.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(warps = new File(this.getDataFolder().getPath(), "warps.yml")).exists()) {
            try {
                warps.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(spawn = new File(this.getDataFolder().getPath(), "spawn.yml")).exists()) {
            try {
                spawn.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File config = new File(this.getDataFolder().getPath(), "config.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)config);
        if (!config.exists()) {
            try {
                config.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)cfg.getString("Prefix"));
            maxHomes = cfg.getInt("DefaultHomeLimit");
            maxPremiumHomes = cfg.getInt("PremiumHomeLimit");
            homeModule = cfg.getBoolean("Modules.HomeSystem");
            warpModule = cfg.getBoolean("Modules.WarpSystem");
            spawnModule = cfg.getBoolean("Modules.SpawnSystem");
            lobbyModule = cfg.getBoolean("Modules.LobbySwitcher.Enabled");
            elevatorModule = cfg.getBoolean("Modules.ElevatorSystem");
            spawntp = cfg.getBoolean("TeleportToSpawnOnJoin");
            this.sendModulesInitMessage();
        }
        cfg.options().copyDefaults(true);
        cfg.addDefault("Prefix", (Object)"&e&lTELEPORT &8\u00bb &7");
        cfg.addDefault("DefaultHomeLimit", (Object)2);
        cfg.addDefault("PremiumHomeLimit", (Object)5);
        cfg.addDefault("TeleportToSpawnOnJoin", (Object)false);
        cfg.addDefault("Modules.HomeSystem", (Object)true);
        cfg.addDefault("Modules.WarpSystem", (Object)true);
        cfg.addDefault("Modules.SpawnSystem", (Object)true);
        cfg.addDefault("Modules.ElevatorSystem", (Object)true);
        cfg.addDefault("Modules.LobbySwitcher.Enabled", (Object)true);
        cfg.addDefault("Modules.LobbySwitcher.Slot", (Object)9);
        cfg.addDefault("Modules.LobbySwitcher.Item.Type", (Object)"NETHER_STAR");
        cfg.addDefault("Modules.LobbySwitcher.Item.Name", (Object)"&e&lLobbySwitcher");
        cfg.addDefault("Modules.LobbySwitcher.Lobbys.1.Enabled", (Object)true);
        cfg.addDefault("Modules.LobbySwitcher.Lobbys.1.PremiumLobby", (Object)false);
        cfg.addDefault("Modules.LobbySwitcher.Lobbys.2.Enabled", (Object)true);
        cfg.addDefault("Modules.LobbySwitcher.Lobbys.2.PremiumLobby", (Object)false);
        cfg.addDefault("Modules.LobbySwitcher.Lobbys.3.Enabled", (Object)true);
        cfg.addDefault("Modules.LobbySwitcher.Lobbys.3.PremiumLobby", (Object)false);
        cfg.addDefault("Modules.LobbySwitcher.Lobbys.4.Enabled", (Object)true);
        cfg.addDefault("Modules.LobbySwitcher.Lobbys.4.PremiumLobby", (Object)false);
        try {
            cfg.save(config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void Commands() {
        if (homeModule) {
            this.getCommand("sethome").setExecutor((CommandExecutor)new SetHome());
            this.getCommand("delhome").setExecutor((CommandExecutor)new DelHome());
            this.getCommand("home").setExecutor((CommandExecutor)new Home());
            this.getCommand("homes").setExecutor((CommandExecutor)new Homes());
        }
        if (warpModule) {
            this.getCommand("setwarp").setExecutor((CommandExecutor)new SetWarp());
            this.getCommand("delwarp").setExecutor((CommandExecutor)new DelWarp());
            this.getCommand("warp").setExecutor((CommandExecutor)new Warp());
            this.getCommand("warps").setExecutor((CommandExecutor)new Warps());
        }
        if (spawnModule) {
            this.getCommand("spawn").setExecutor((CommandExecutor)new Spawn());
            this.getCommand("setspawn").setExecutor((CommandExecutor)new SetSpawn());
        }
        if (lobbyModule) {
            this.getCommand("setlobby").setExecutor((CommandExecutor)new SetLobby());
        }
        this.getCommand("worldtp").setExecutor((CommandExecutor)new WorldTP());
        this.getCommand("professionalteleport").setExecutor((CommandExecutor)new Credit());
        this.getCommand("tpa").setExecutor((CommandExecutor)new TPA());
        this.getCommand("tpaaccept").setExecutor((CommandExecutor)new TPAAccept());
        this.getCommand("tpadeny").setExecutor((CommandExecutor)new TPADeny());
        this.getCommand("tpatoggle").setExecutor((CommandExecutor)new TPAToggle());
    }

    private void Listener() {
        Bukkit.getPluginManager().registerEvents((Listener)new Lift(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new TeleportGUIClick(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new Join(), (Plugin)this);
        if (lobbyModule) {
            Bukkit.getPluginManager().registerEvents((Listener)new LobbySwitcherGUI(), (Plugin)this);
        }
    }

    public static void sendActionBar(Player p, String message) {
        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
    }

    private void sendModulesInitMessage() {
        this.sendPluginInitMessage();
        if (homeModule) {
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lHome System \u00a78| \u00a7aEnabled");
        } else {
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lHome System \u00a78| \u00a7cDisabled");
        }
        if (warpModule) {
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lWarp System \u00a78| \u00a7aEnabled");
        } else {
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lWarp System \u00a78| \u00a7cDisabled");
        }
        if (spawnModule) {
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lSpawn System \u00a78| \u00a7aEnabled");
        } else {
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lSpawn System \u00a78| \u00a7cDisabled");
        }
        if (lobbyModule) {
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lLobby Switcher \u00a78| \u00a7aEnabled");
        } else {
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lLobby Switcher \u00a78| \u00a7cDisabled");
        }
        if (elevatorModule) {
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lElevators \u00a78| \u00a7aEnabled");
        } else {
            Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lElevators \u00a78| \u00a7cDisabled");
        }
        Bukkit.getConsoleSender().sendMessage("\u00a78[]===================================[]");
    }

    private void sendPluginInitMessage() {
        Bukkit.getConsoleSender().sendMessage("\u00a78[]===================================[]");
        Bukkit.getConsoleSender().sendMessage("\u00a7e\u00a7lProfessionalTeleport \u00a78| \u00a77Version: \u00a7c" + Version);
        Bukkit.getConsoleSender().sendMessage("\u00a77Developer: \u00a7e\u00a7lTutorialwork");
        Bukkit.getConsoleSender().sendMessage("\u00a75YT \u00a77channel: \u00a7cyoutube.com/Tutorialwork");
        Bukkit.getConsoleSender().sendMessage("\u00a78[]===================================[]");
    }

    public static String callURL(String myURL) {
        StringBuilder sb = new StringBuilder();
        URLConnection urlConn = null;
        InputStreamReader in = null;
        try {
            BufferedReader bufferedReader;
            URL url = new URL(myURL);
            urlConn = url.openConnection();
            if (urlConn != null) {
                urlConn.setReadTimeout(60000);
            }
            if (urlConn != null && urlConn.getInputStream() != null && (bufferedReader = new BufferedReader(in = new InputStreamReader(urlConn.getInputStream(), Charset.defaultCharset()))) != null) {
                int cp;
                while ((cp = bufferedReader.read()) != -1) {
                    sb.append((char)cp);
                }
                bufferedReader.close();
            }
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while calling URL:" + myURL, e);
        }
        return sb.toString();
    }

    public static Main getInstance() {
        return main;
    }

    static {
        Prefix = "\u00a7e\u00a7lTELEPORT \u00a78\u00bb \u00a77";
        NoPerms = Prefix + "\u00a7cYou don't have permissions to use this command";
        Version = "1.3";
        maxHomes = 2;
        maxPremiumHomes = 5;
        spawntp = false;
        homeModule = true;
        warpModule = true;
        spawnModule = true;
        lobbyModule = true;
        elevatorModule = true;
    }
}

