/*
 * Decompiled with CFR 0.152.
 */
package fr.cocoraid.prodigyressourcepack.utils;

import com.google.common.base.Joiner;
import com.google.common.primitives.Primitives;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.util.Vector;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Config {
    private static final transient char DEFAULT_SEPARATOR = '_';
    private static final transient String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final transient String TEMP_CONFIG_SECTION = "temp";
    private transient File configFile;
    private transient List<String> header;

    protected Config(File configFile) {
        this(configFile, null);
    }

    protected Config(File configFile, List<String> header) {
        this.configFile = configFile;
        this.header = header;
    }

    public final void load() throws InvalidConfigurationException {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
            Field[] fieldArray = this.getClass().getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                this.loadField(field, this.getFieldName(field), config);
                ++n2;
            }
            this.saveConfig(config);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException((Throwable)ex);
        }
    }

    public final void save() throws InvalidConfigurationException {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
            Field[] fieldArray = this.getClass().getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                this.saveField(field, this.getFieldName(field), config);
                ++n2;
            }
            this.saveConfig(config);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException((Throwable)ex);
        }
    }

    private final String getFieldName(Field field) {
        ConfigOptions options = field.getAnnotation(ConfigOptions.class);
        if (options == null) {
            return field.getName().replace('_', '.');
        }
        String name = options.name();
        if (name.equals("")) {
            return field.getName().replace('_', '.');
        }
        return name;
    }

    private final boolean ignoreField(Field field) {
        ConfigOptions options = field.getAnnotation(ConfigOptions.class);
        if (options == null) {
            return false;
        }
        return options.ignore();
    }

    private final void saveConfig(YamlConfiguration config) throws IOException {
        if (this.header != null && this.header.size() > 0) {
            config.options().header(Joiner.on((String)LINE_SEPARATOR).join(this.header));
        }
        config.save(this.configFile);
    }

    private final void loadField(Field field, String name, YamlConfiguration config) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ParseException, InstantiationException {
        if (Modifier.isTransient(field.getModifiers()) || this.ignoreField(field)) {
            return;
        }
        Object configValue = config.get(this.getFieldName(field));
        if (configValue == null) {
            this.saveField(field, name, config);
        } else {
            field.set(this, this.deserializeObject(field.getType(), configValue));
        }
    }

    private final void saveField(Field field, String name, YamlConfiguration config) throws IllegalAccessException {
        if (Modifier.isTransient(field.getModifiers()) || this.ignoreField(field)) {
            return;
        }
        config.set(name, this.serializeObject(field.get(this), config));
    }

    private final Object deserializeObject(Class<?> clazz, Object object) throws ParseException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        if (clazz.isPrimitive()) {
            return Primitives.wrap(clazz).getMethod("valueOf", String.class).invoke((Object)this, object.toString());
        }
        if (Primitives.isWrapperType(clazz)) {
            return clazz.getMethod("valueOf", String.class).invoke((Object)this, object.toString());
        }
        if (clazz.isEnum() || object instanceof Enum) {
            return Enum.valueOf(clazz, object.toString());
        }
        if (Map.class.isAssignableFrom(clazz) || object instanceof Map) {
            ConfigurationSection section = (ConfigurationSection)object;
            HashMap<String, Object> deserializedMap = new HashMap<String, Object>();
            for (String key : section.getKeys(false)) {
                Object value = section.get(key);
                deserializedMap.put(key, this.deserializeObject(value.getClass(), value));
            }
            Object map = clazz.newInstance();
            clazz.getMethod("putAll", Map.class).invoke(map, deserializedMap);
            return map;
        }
        if (List.class.isAssignableFrom(clazz) || object instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object value : (List)object) {
                result.add(this.deserializeObject(value.getClass(), value));
            }
            return result;
        }
        if (Location.class.isAssignableFrom(clazz) || object instanceof Location) {
            JSONObject jsonObject = (JSONObject)new JSONParser().parse(object.toString());
            return new Location(Bukkit.getWorld((String)jsonObject.get((Object)"world").toString()), Double.parseDouble(jsonObject.get((Object)"x").toString()), Double.parseDouble(jsonObject.get((Object)"y").toString()), Double.parseDouble(jsonObject.get((Object)"z").toString()), Float.parseFloat(jsonObject.get((Object)"yaw").toString()), Float.parseFloat(jsonObject.get((Object)"pitch").toString()));
        }
        if (Vector.class.isAssignableFrom(clazz) || object instanceof Vector) {
            JSONObject jsonObject = (JSONObject)new JSONParser().parse(object.toString());
            return new Vector(Double.parseDouble(jsonObject.get((Object)"x").toString()), Double.parseDouble(jsonObject.get((Object)"y").toString()), Double.parseDouble(jsonObject.get((Object)"z").toString()));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)object.toString());
    }

    private final Object serializeObject(Object object, YamlConfiguration config) {
        if (object instanceof String) {
            return object.toString().replace('\u00a7', '&');
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        if (object instanceof Map) {
            ConfigurationSection section = config.createSection(TEMP_CONFIG_SECTION);
            for (Map.Entry entry : ((Map)object).entrySet()) {
                section.set(entry.getKey().toString(), this.serializeObject(entry.getValue(), config));
            }
            config.set(TEMP_CONFIG_SECTION, null);
            return section;
        }
        if (object instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object value : (List)object) {
                result.add(this.serializeObject(value, config));
            }
            return result;
        }
        if (object instanceof Location) {
            Location location = (Location)object;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"world", (Object)location.getWorld().getName());
            jsonObject.put((Object)"x", (Object)location.getX());
            jsonObject.put((Object)"y", (Object)location.getY());
            jsonObject.put((Object)"z", (Object)location.getZ());
            jsonObject.put((Object)"yaw", (Object)Float.valueOf(location.getYaw()));
            jsonObject.put((Object)"pitch", (Object)Float.valueOf(location.getPitch()));
            return jsonObject.toJSONString();
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"x", (Object)vector.getX());
            jsonObject.put((Object)"y", (Object)vector.getY());
            jsonObject.put((Object)"z", (Object)vector.getZ());
            return jsonObject.toJSONString();
        }
        return object;
    }

    public final List<String> getHeader() {
        return this.header;
    }

    public final File getFile() {
        return this.configFile;
    }

    public final void setHeader(List<String> header) {
        this.header = header;
    }

    public final void setFile(File configFile) {
        this.configFile = configFile;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface ConfigOptions {
        public String name() default "";

        public boolean ignore() default false;
    }
}

