/*
 * Decompiled with CFR 0.152.
 */
package fr.cocoraid.prodigymention.general;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ProdigyMentionConfig {
    private transient File file;
    public boolean needAtToMention = false;
    public boolean isParticleEnabled = true;
    public boolean isSoundEnabled = true;
    public String customSound = "BLOCK_NOTE_BLOCK_PLING";
    public boolean antispam = true;
    public boolean antiSpamMessageEnable = false;
    public String antispamMessage = "&cWait %time seconds to mention someone";
    public int antiSpamTime = 5;
    public boolean isBypassPermission = true;
    public boolean isChatMessageEnabled = false;
    public boolean isTitleMessageEnabled = true;
    public boolean isColoredName = true;
    public String nameColor = "\u00a7b\u00a7l";
    public String toggleOnMessage = "&aPlayers can now mention you";
    public String toggleOffMessage = "&cPlayers can no longer mention you";
    public String permissionMessage = "&cYou do not have the permission";
    public String mentionMessage = "&b%player &3mentioned you !";

    public ProdigyMentionConfig(String folderPath) {
        this.file = new File(folderPath, "config.yml");
        this.load();
    }

    public void load() {
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
                PrintWriter writer = new PrintWriter(this.file, "UTF-8");
                for (Field field : this.getClass().getDeclaredFields()) {
                    if (Modifier.isTransient(field.getModifiers())) continue;
                    if (field.getType().equals(String.class)) {
                        String s = (String)field.get(this);
                        writer.println(field.getName() + ": " + s.replace("\u00a7", "&"));
                        continue;
                    }
                    if (field.getType().equals(List.class)) continue;
                    writer.println(field.getName() + ": " + field.get(this));
                }
                writer.close();
            }
            catch (IOException | IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                List<String> list = Files.readAllLines(Paths.get(this.file.getPath(), new String[0]));
                HashMap map = new HashMap();
                list.forEach(value -> {
                    String[] crypted = value.split(":");
                    map.put(crypted[0], crypted[1].substring(1));
                });
                for (Field field : this.getClass().getDeclaredFields()) {
                    if (Modifier.isTransient(field.getModifiers()) || !map.containsKey(field.getName())) continue;
                    if (field.getType().equals(String.class)) {
                        String s = (String)map.get(field.getName());
                        field.set(this, s.replace("&", "\u00a7"));
                        continue;
                    }
                    String object = (String)map.get(field.getName());
                    if (object.equalsIgnoreCase("true") || object.equalsIgnoreCase("false")) {
                        field.set(this, Boolean.valueOf(object));
                    }
                    if (!StringUtils.isNumeric((String)object)) continue;
                    try {
                        int i = Integer.valueOf(object);
                        field.set(this, i);
                    }
                    catch (Exception e) {
                        System.out.println("Prodigymention configuration error (config.yml), a number is not integer");
                    }
                }
            }
            catch (IOException | IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

