/*
 * Decompiled with CFR 0.152.
 */
package fr.cocoraid.prodigymention.general;

import fr.cocoraid.prodigymention.NativeExecutor;
import fr.cocoraid.prodigymention.general.LocalDatabase;
import fr.cocoraid.prodigymention.general.ProdigyMentionConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public class ProdigyMention {
    private List<UUID> antispam = new ArrayList<UUID>();
    private LocalDatabase database;
    private ProdigyMentionConfig config;
    public final NativeExecutor nativeExecutor;

    public ProdigyMention(NativeExecutor nativeExecutor) {
        this.nativeExecutor = nativeExecutor;
    }

    public void disable() {
        if (this.database != null) {
            this.database.saveDatabase();
        }
    }

    public void reload() {
        this.disable();
        this.database = new LocalDatabase(this.nativeExecutor.dataFolder());
        this.config = new ProdigyMentionConfig(this.nativeExecutor.dataFolder());
        this.nativeExecutor.log(Level.INFO, "Loading configuration...");
        this.nativeExecutor.unregisterAllListeners();
        this.nativeExecutor.log(Level.INFO, "Database is ready to go!");
        this.nativeExecutor.registerListener();
    }

    public String[] getHelpMessage() {
        String[] help = new String[]{"\u00a76\u00a7lProdigy\u00a7b\u00a7lMention", "\u00a7aReload the config file: \u00a7c/pm reload", "\u00a7aToggle mode: \u00a7c/pm toggle"};
        return help;
    }

    public LocalDatabase getDatabase() {
        return this.database;
    }

    public ProdigyMentionConfig getConfig() {
        return this.config;
    }

    public List<UUID> getAntispam() {
        return this.antispam;
    }

    public void printDebugInformation() {
    }
}

