/*
 * Decompiled with CFR 0.152.
 */
package fr.cocoraid.prodigymention.general;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class LocalDatabase {
    private List<UUID> toggledoff = new ArrayList<UUID>();
    private File file;
    private String folderPath;

    public LocalDatabase(String folderPath) {
        this.folderPath = folderPath;
        File dir = new File(folderPath);
        dir.mkdirs();
        this.file = this.getFile();
        try {
            List<String> list = Files.readAllLines(Paths.get(this.file.getPath(), new String[0]));
            list.forEach(s -> this.toggledoff.add(UUID.fromString(s)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveDatabase() {
        try {
            PrintWriter writer = new PrintWriter(this.file, "UTF-8");
            this.toggledoff.forEach(uuid -> writer.println(uuid.toString()));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setToggledOff(UUID uuid) {
        this.toggledoff.add(uuid);
    }

    public void removeToggled(UUID uuid) {
        this.toggledoff.remove(uuid);
    }

    public File getFile() {
        File file = new File(this.folderPath, "database.txt");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public List<UUID> getToggledoff() {
        return this.toggledoff;
    }
}

