/*
 * Decompiled with CFR 0.152.
 */
package fr.cocoraid.prodigymention.bungee;

import fr.cocoraid.prodigymention.bungee.ProdigyMentionBungee;
import fr.cocoraid.prodigymention.general.LocalDatabase;
import fr.cocoraid.prodigymention.general.ProdigyMentionConfig;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;

public class CMDListener
extends Command {
    private ProdigyMentionBungee bungee;
    private ProdigyMentionConfig config;
    private LocalDatabase database;

    public CMDListener(ProdigyMentionBungee bungee) {
        super("prodigymention", "prodigymention.usage", new String[]{"pm"});
        this.bungee = bungee;
        this.config = bungee.getInstance().getConfig();
        this.database = bungee.getInstance().getDatabase();
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof ProxiedPlayer) {
            ProxiedPlayer pp = (ProxiedPlayer)sender;
            if (args.length <= 0) {
                for (String s : this.bungee.getInstance().getHelpMessage()) {
                    pp.sendMessage(TextComponent.fromLegacyText((String)s));
                }
            } else {
                switch (args[0].toLowerCase()) {
                    case "toggle": {
                        if (!pp.hasPermission("prodigymention.toggle")) {
                            pp.sendMessage(TextComponent.fromLegacyText((String)this.config.permissionMessage));
                            break;
                        }
                        if (this.database.getToggledoff().contains(pp.getUniqueId())) {
                            this.database.removeToggled(pp.getUniqueId());
                            pp.sendMessage(TextComponent.fromLegacyText((String)this.config.toggleOnMessage));
                            break;
                        }
                        this.database.setToggledOff(pp.getUniqueId());
                        pp.sendMessage(TextComponent.fromLegacyText((String)this.config.toggleOffMessage));
                        break;
                    }
                    case "reload": {
                        if (!pp.hasPermission("prodigymention.reload")) {
                            pp.sendMessage(TextComponent.fromLegacyText((String)this.config.permissionMessage));
                            break;
                        }
                        try {
                            this.config.load();
                            pp.sendMessage(TextComponent.fromLegacyText((String)"&aConfiguration file reloaded ! :D"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        for (String s : this.bungee.getInstance().getHelpMessage()) {
                            pp.sendMessage(TextComponent.fromLegacyText((String)s));
                        }
                        break;
                    }
                }
            }
        }
    }
}

