/*
 * Decompiled with CFR 0.152.
 */
package com.fakesaint.proactivmaps;

import com.fakesaint.proactivmaps.Commands.BaseCommand;
import com.fakesaint.proactivmaps.Events.MapClick;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ProactivMaps
extends JavaPlugin {
    private FileConfiguration config;
    public Set matBlacklist = new HashSet();
    public HashMap<UUID, Integer> playerStats = new HashMap();
    public long resetTimeStampMilli;
    public long resetIntervalMilli;

    public void onEnable() {
        this.initializeConfiguration();
        this.createTimeStamp();
        this.createBlackList();
        this.registerEvents();
        this.getCommand("proactivmaps").setExecutor((CommandExecutor)new BaseCommand(this));
    }

    private void initializeConfiguration() {
        this.config = this.getConfig();
        this.config.options().copyDefaults(true);
        this.saveDefaultConfig();
    }

    private void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new MapClick(this), (Plugin)this);
    }

    private void createTimeStamp() {
        this.resetIntervalMilli = (long)(this.config.getDouble("ResetTime") * 3600000.0);
        this.resetTimeStampMilli = System.currentTimeMillis() + this.resetIntervalMilli;
    }

    private void createBlackList() {
        for (String materialString : this.config.getStringList("BlackList")) {
            try {
                this.matBlacklist.add(Material.valueOf((String)materialString));
            }
            catch (Exception e) {
                System.out.println("ERROR! " + materialString + " is not a valid Material. Check Bukkit API");
            }
        }
    }
}

