/*
 * Decompiled with CFR 0.152.
 */
package com.fakesaint.proactivmaps.Events;

import com.fakesaint.proactivmaps.ProactivMaps;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class MapClick
implements Listener {
    private ProactivMaps plugin;

    public MapClick(ProactivMaps pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void onMapClick(PlayerInteractEvent event) {
        if (event.getItem() != null && event.getItem().getType() == Material.EMPTY_MAP && (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR)) {
            Player player = event.getPlayer();
            UUID playerID = player.getUniqueId();
            this.checkTime();
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK && this.plugin.matBlacklist.contains(event.getClickedBlock().getType())) {
                player.sendMessage(ChatColor.DARK_PURPLE + "Sorry! Not with an Empty Map!!");
                event.setCancelled(true);
                return;
            }
            if (!this.plugin.playerStats.containsKey(playerID)) {
                this.plugin.playerStats.put(playerID, 1);
                return;
            }
            int mapLimit = this.plugin.getConfig().getInt("MapLimit");
            int warningCount = this.plugin.getConfig().getInt("WarningCount");
            int playerCounter = this.plugin.playerStats.get(playerID);
            if (playerCounter >= mapLimit) {
                event.setCancelled(true);
                player.sendMessage(ChatColor.DARK_PURPLE + "ProactivMaps: Exceeded Map Limit!");
                return;
            }
            this.plugin.playerStats.put(playerID, ++playerCounter);
            this.Warn(player, playerCounter);
            return;
        }
    }

    private void Warn(Player player, int playerCounter) {
        if (playerCounter > this.plugin.getConfig().getInt("WarningCount")) {
            player.sendMessage(ChatColor.AQUA + "ProactivMaps: Watch out! You can't make more than " + this.plugin.getConfig().getInt("MapLimit") + " maps every " + this.plugin.getConfig().getDouble("ResetTime") + " hours!");
        }
    }

    public boolean checkTime() {
        long checkTimeStamp = System.currentTimeMillis() + this.plugin.resetIntervalMilli;
        if (this.plugin.resetTimeStampMilli < System.currentTimeMillis()) {
            this.plugin.playerStats.clear();
            this.plugin.resetTimeStampMilli = checkTimeStamp;
            return true;
        }
        return false;
    }
}

