/*
 * Decompiled with CFR 0.152.
 */
package com.fakesaint.proactivmaps.Commands;

import com.fakesaint.proactivmaps.ProactivMaps;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BaseCommand
implements CommandExecutor {
    private ProactivMaps plugin;
    private Player player;
    private UUID playerID;

    public BaseCommand(ProactivMaps pl) {
        this.plugin = pl;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] args) {
        String arg;
        if (args.length == 0) {
            commandSender.sendMessage(ChatColor.AQUA + "/proactivmaps clear: Resets map count for all players.");
            commandSender.sendMessage(ChatColor.AQUA + "/proactivmaps clear <player>: Resets map count for <player>.");
            commandSender.sendMessage(ChatColor.AQUA + "/proactivmaps timer: Displays the time left until map counts are cleared");
            commandSender.sendMessage(ChatColor.AQUA + "/proactivmaps settings: Displays key config Settings");
            return true;
        }
        switch (arg = args[0]) {
            case "clear": {
                if (!commandSender.hasPermission("proactivmaps.admin")) {
                    commandSender.sendMessage(ChatColor.RED + "Insufficient permission");
                    break;
                }
                if (args.length > 1) {
                    this.player = Bukkit.getPlayer((String)args[1]);
                    if (this.player == null) {
                        commandSender.sendMessage(ChatColor.RED + "Invalid Player Name");
                        break;
                    }
                    this.playerID = this.player.getUniqueId();
                    this.plugin.playerStats.remove(this.playerID);
                    commandSender.sendMessage(ChatColor.GREEN + args[1] + "'s map data has been cleared");
                    break;
                }
                this.plugin.playerStats.clear();
                commandSender.sendMessage(ChatColor.GREEN + "Cleared Player HashMap");
                break;
            }
            case "timer": {
                long timeLeftMilli = this.plugin.resetTimeStampMilli - System.currentTimeMillis();
                if (timeLeftMilli >= 3600000L) {
                    long timeLeftHours = timeLeftMilli / 3600000L;
                    this.printTimerString(timeLeftHours, TimeUnit.HOURS, commandSender);
                    break;
                }
                if (timeLeftMilli >= 60000L) {
                    long timeLeftMin = timeLeftMilli / 60000L;
                    this.printTimerString(timeLeftMin, TimeUnit.MINUTES, commandSender);
                    break;
                }
                if (timeLeftMilli >= 1000L) {
                    long timeLeftSec = timeLeftMilli / 1000L;
                    this.printTimerString(timeLeftSec, TimeUnit.SECONDS, commandSender);
                    break;
                }
                if (timeLeftMilli > 0L) {
                    commandSender.sendMessage(ChatColor.AQUA + "Less than one second until map count resets!");
                    break;
                }
                this.plugin.resetTimeStampMilli = System.currentTimeMillis() + this.plugin.resetIntervalMilli;
                this.plugin.playerStats.clear();
                commandSender.sendMessage(ChatColor.GREEN + "Map count data just reset!");
                break;
            }
            case "settings": {
                if (!commandSender.hasPermission("proactivmaps.see")) {
                    commandSender.sendMessage(ChatColor.RED + "Insufficient Permission");
                    break;
                }
                commandSender.sendMessage(ChatColor.LIGHT_PURPLE + "ProactivMaps Settings:");
                commandSender.sendMessage(ChatColor.AQUA + "Map limit per player is " + this.plugin.getConfig().getInt("MapLimit"));
                commandSender.sendMessage(ChatColor.AQUA + "Map limit resets every " + this.plugin.getConfig().getDouble("ResetTime") + " hours");
                break;
            }
            default: {
                commandSender.sendMessage(ChatColor.RED + "Invalid argument! type /proactivmaps for help");
            }
        }
        return true;
    }

    private void printTimerString(long time, Enum<TimeUnit> unit, CommandSender sender) {
        String formatString = unit.toString().toLowerCase();
        String timerString = ChatColor.AQUA + "" + time + " " + formatString + " left until next map count reset";
        sender.sendMessage(timerString);
    }
}

