/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.creepereggs.version;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotPlugin {
    private JavaPlugin plugin;
    private int id;
    private String version;

    public SpigotPlugin(int id, JavaPlugin plugin) {
        this.plugin = plugin;
        this.id = id;
    }

    public void checkForUpdate() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                HttpsURLConnection connection = (HttpsURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.id).openConnection();
                connection.setRequestMethod("GET");
                this.version = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.INFO, "Couldn't check the latest plugin version :/");
                return;
            }
            if (this.version.equals(this.plugin.getDescription().getVersion())) {
                return;
            }
            this.plugin.getLogger().log(Level.INFO, "A new build is available: " + this.version + " (you are running " + this.plugin.getDescription().getVersion() + ")");
            this.plugin.getLogger().log(Level.INFO, "Download it here: " + this.getResourceUrl());
            if (this.plugin.getConfig().getBoolean("update-notify")) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().registerEvents(new Listener(){

                    @EventHandler(priority=EventPriority.MONITOR)
                    public void onPlayerJoin(PlayerJoinEvent event) {
                        Player player = event.getPlayer();
                        if (player.hasPermission(String.valueOf(SpigotPlugin.this.plugin.getName().toLowerCase()) + ".update-notify")) {
                            SpigotPlugin.this.getOutOfDateMessage().forEach(msg -> player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg)));
                        }
                    }
                }, (Plugin)this.plugin));
            }
        });
    }

    private List<String> getOutOfDateMessage() {
        return Arrays.asList("&8--------------------------------------------", "&a" + this.plugin.getName() + " " + this.version + " is available!", "&a" + this.getResourceUrl(), "&7&oYou can disable this notification in the config file.", "&8--------------------------------------------");
    }

    public String getResourceUrl() {
        return "https://www.spigotmc.org/resources/" + this.id + "/";
    }
}

