/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.creepereggs.manager;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import net.Indyuce.creepereggs.PremiumCreeperEggs;
import net.Indyuce.creepereggs.api.CreeperEgg;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public class EggsManager {
    private Map<String, CreeperEgg> eggs = new HashMap<String, CreeperEgg>();
    private boolean creeperRegistration = true;

    public EggsManager() {
        try {
            JarFile file = new JarFile(PremiumCreeperEggs.getInstance().getJarFile());
            Enumeration<JarEntry> entry = file.entries();
            while (entry.hasMoreElements()) {
                JarEntry jarEntry = entry.nextElement();
                String name = jarEntry.getName().replace("/", ".");
                if (!name.endsWith(".class") || name.contains("$") || !name.startsWith("net.Indyuce.creepereggs.creeper.")) continue;
                this.registerEgg((CreeperEgg)Class.forName(name.substring(0, name.length() - 6)).newInstance());
            }
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerEgg(CreeperEgg egg) {
        if (!this.canRegisterCreepers()) {
            PremiumCreeperEggs.getInstance().getLogger().log(Level.WARNING, "Couldn't register " + egg.getId() + ": make sure you register creeper eggs before PCE enables (using #onLoad & a soft dependency)");
            return;
        }
        this.eggs.put(egg.getId(), egg);
    }

    public void stopRegistration() {
        this.creeperRegistration = false;
    }

    public boolean canRegisterCreepers() {
        return this.creeperRegistration;
    }

    public Collection<CreeperEgg> getAll() {
        return this.eggs.values();
    }

    public CreeperEgg get(String key) {
        return this.eggs.containsKey(key) ? this.eggs.get(key) : null;
    }

    public CreeperEgg fromName(String name) {
        for (CreeperEgg egg : PremiumCreeperEggs.getInstance().getEggs().getAll()) {
            if (!name.equals(ChatColor.BLUE + egg.getCreeperName())) continue;
            return egg;
        }
        return null;
    }

    public CreeperEgg fromItem(ItemStack item) {
        String tag = PremiumCreeperEggs.getInstance().getVersionWrapper().getNBTItem(item).getString("creeperEggId");
        return tag.equals("") ? null : this.eggs.get(tag);
    }
}

