/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.creepereggs.creeper;

import java.util.Random;
import net.Indyuce.creepereggs.PremiumCreeperEggs;
import net.Indyuce.creepereggs.api.CreeperEgg;
import net.Indyuce.creepereggs.api.EggRecipe;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Frozen
extends CreeperEgg {
    public Frozen() {
        super("Frozen Creeper Egg", 30.0, "Use this egg to entirely", "freeze a large area.");
        this.addValue("radius", 7.0);
        this.addValue("amplifier", 1.0);
        this.addValue("duration", 4.0);
        EggRecipe recipe = this.generateNewRecipe();
        recipe.shape("iti", "tet", "iti");
        recipe.setIngredient('t', Material.TNT);
        recipe.setIngredient('e', Material.EGG);
        recipe.setIngredient('i', Material.ICE);
        this.setRecipe(recipe);
    }

    @Override
    public void entityExplode(ExplosionPrimeEvent e, Creeper c) {
        Location ctr = c.getLocation();
        Location loc = c.getLocation();
        int r = (int)this.getValue("radius");
        int duration = (int)(this.getValue("duration") * 20.0);
        int pow = (int)(this.getValue("amplifier") - 1.0);
        Random rd = new Random();
        this.fakeCreeperExplosion(e, c);
        int x = -r;
        while (x < r) {
            int y = -r;
            while (y < r) {
                int z = -r;
                while (z < r) {
                    Block b;
                    loc.add((double)x, (double)y, (double)z);
                    if (loc.distanceSquared(ctr) <= Math.pow(r, 2.0) && this.canBeFrozen((b = loc.getBlock()).getType()) && !PremiumCreeperEggs.getInstance().isBlacklisted(b.getType())) {
                        b.setType(rd.nextDouble() < 0.15 ? Material.PACKED_ICE : Material.ICE);
                    }
                    loc.subtract((double)x, (double)y, (double)z);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        for (Entity t : c.getNearbyEntities((double)r, (double)r, (double)r)) {
            if (!(t instanceof LivingEntity)) continue;
            ((Player)t).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, duration, pow));
        }
    }

    private boolean canBeFrozen(Material m) {
        return m.isSolid() || m == Material.WATER;
    }
}

