/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.creepereggs.api;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.Indyuce.creepereggs.PremiumCreeperEggs;
import net.Indyuce.creepereggs.api.CreeperEgg;
import net.Indyuce.creepereggs.comp.worldguard.CustomFlag;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class PlayerData {
    private static Map<UUID, PlayerData> map = new HashMap<UUID, PlayerData>();
    private Player player;
    private Map<CreeperEgg, Long> cd = new HashMap<CreeperEgg, Long>();

    public PlayerData(Player player) {
        this.player = player;
    }

    public static void initialize(Player p) {
        map.put(p.getUniqueId(), new PlayerData(p));
    }

    public static boolean has(Player p) {
        return map.containsKey(p.getUniqueId());
    }

    public static PlayerData get(Player p) {
        return map.get(p.getUniqueId());
    }

    public void updatePlayer(Player player) {
        this.player = player;
    }

    public boolean canUse(CreeperEgg egg) {
        if (!PremiumCreeperEggs.getInstance().getWorldGuard().isFlagAllowed(this.player, CustomFlag.CUSTOM_CREEPER_EGGS)) {
            this.player.sendMessage(ChatColor.RED + PremiumCreeperEggs.getInstance().getMessage("worldguard-flag"));
            return false;
        }
        long lastUsed = this.cd.containsKey(egg) ? this.cd.get(egg) : 0L;
        double remain = (double)lastUsed / 1000.0 + egg.getValue("cooldown") - (double)System.currentTimeMillis() / 1000.0;
        if (remain > 0.0) {
            this.player.sendMessage(ChatColor.RED + PremiumCreeperEggs.getInstance().getMessage("cooldown").replace("%s%", remain >= 2.0 ? "s" : "").replace("%remain%", new DecimalFormat("0.0").format(remain)));
            return false;
        }
        this.cd.put(egg, System.currentTimeMillis());
        return true;
    }

    public double getRemainingCooldown(CreeperEgg egg) {
        return Math.max(0.0, (double)(this.cd.containsKey(egg) ? this.cd.get(egg) : 0L) + 1000.0 * egg.getValue("cooldown") - (double)System.currentTimeMillis()) / 1000.0;
    }
}

