/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.creepereggs.api;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.Indyuce.creepereggs.PremiumCreeperEggs;
import net.Indyuce.creepereggs.api.EggRecipe;
import net.Indyuce.creepereggs.version.wrapper.ItemTag;
import net.Indyuce.creepereggs.version.wrapper.NBTItem;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CreeperEgg {
    private final String id;
    private String[] lore;
    private String name;
    private String creeperName;
    private Map<String, Double> modifiers = new HashMap<String, Double>();
    private EggRecipe recipe;
    private boolean recipeEnabled;

    public CreeperEgg(String name, double cooldown, String ... lore) {
        this(name.replace(" Creeper Egg", ""), name, name.replace(" Egg", ""), cooldown, lore);
    }

    public CreeperEgg(String id, String name, String creeperName, double cooldown, String ... lore) {
        this.id = id.toUpperCase().replace("-", "_").replace(" ", "_").replaceAll("[^A-Z_]", "");
        this.name = name;
        this.creeperName = creeperName;
        this.lore = lore;
        this.addValue("cooldown", cooldown);
    }

    public String getId() {
        return this.id;
    }

    public String getLowerCaseId() {
        return this.id.toLowerCase().replace("_", "-");
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getModifiers() {
        return this.modifiers.keySet();
    }

    public double getValue(String key) {
        return this.modifiers.get(key);
    }

    public String getCreeperName() {
        return this.creeperName;
    }

    public String[] getLore() {
        return this.lore;
    }

    public EggRecipe getRecipe() {
        return this.recipe;
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public boolean isRecipeEnabled() {
        return this.recipeEnabled;
    }

    public void setRecipe(EggRecipe recipe) {
        this.recipe = recipe;
    }

    public void addValue(String path, double defaultValue) {
        this.modifiers.put(path, defaultValue);
    }

    public void creatureSpawn(Creeper creeper) {
    }

    public void entityExplode(ExplosionPrimeEvent event, Creeper creeper) {
    }

    public void fakeCreeperExplosion(ExplosionPrimeEvent event, Creeper creeper) {
        event.setCancelled(true);
        creeper.remove();
        Random rdm = new Random();
        Location loc = creeper.getLocation().add(0.0, 1.0, 0.0);
        loc.getWorld().spawnParticle(Particle.EXPLOSION_HUGE, loc, 0);
        loc.getWorld().spawnParticle(Particle.EXPLOSION_NORMAL, loc, 32, 0.0, 0.0, 0.0, 0.2);
        loc.getWorld().playSound(loc, Sound.ENTITY_GENERIC_EXPLODE, 4.0f, (1.0f + (rdm.nextFloat() - rdm.nextFloat()) * 0.2f) * 0.7f);
    }

    public void explosionDelay(final Creeper creeper, final double duration) {
        new BukkitRunnable(){
            int ti = 0;
            ArmorStand as;
            {
                this.as = (ArmorStand)creeper2.getWorld().spawnEntity(creeper2.getLocation().add(0.0, 2.0, 0.0), EntityType.ARMOR_STAND);
            }

            public void run() {
                if ((double)this.ti >= duration || creeper == null || creeper.isDead()) {
                    this.as.remove();
                    CreeperEgg.this.explodeCreeper(creeper);
                    this.cancel();
                    return;
                }
                if (this.ti == 0) {
                    this.as.setVisible(false);
                    this.as.setGravity(false);
                    this.as.setCustomNameVisible(true);
                    this.as.setMarker(true);
                }
                this.as.teleport(creeper.getLocation().add(0.0, 2.0, 0.0));
                if (this.ti % 6 == 0) {
                    creeper.getWorld().playSound(creeper.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 2.0f, (float)((double)this.ti / duration) + 1.0f);
                }
                this.as.setCustomName(ChatColor.RED + ChatColor.BOLD + new DecimalFormat("0.0").format((duration - (double)this.ti) / 20.0));
                ++this.ti;
            }
        }.runTaskTimer((Plugin)PremiumCreeperEggs.getInstance(), 0L, 1L);
    }

    public void explodeCreeper(Creeper creeper) {
        try {
            Object handle = creeper.getClass().getMethod("getHandle", new Class[0]).invoke((Object)creeper, new Object[0]);
            Field field = Class.forName("net.minecraft.server." + PremiumCreeperEggs.getInstance().getVersion().toString() + "." + "EntityCreeper").getDeclaredField("maxFuseTicks");
            field.setInt(handle, -1);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void register() {
        PremiumCreeperEggs.getInstance().getEggs().registerEgg(this);
    }

    public void update(ConfigurationSection eggs) {
        this.name = eggs.getString("name");
        this.creeperName = eggs.getString("creeper-name");
        this.lore = eggs.getStringList("lore").toArray(new String[0]);
        for (String key : this.modifiers.keySet()) {
            this.modifiers.put(key, eggs.getDouble(key));
        }
        this.recipe = EggRecipe.fromFormattedRecipe(this, eggs.getStringList("craft"));
        this.recipeEnabled = eggs.getBoolean("craft-enabled");
    }

    public ItemStack getItem() {
        ItemStack item = new ItemStack(Material.CREEPER_SPAWN_EGG);
        SpawnEggMeta meta = (SpawnEggMeta)item.getItemMeta();
        meta.setDisplayName(ChatColor.BLUE + ChatColor.translateAlternateColorCodes((char)'&', (String)this.name));
        ArrayList<String> lore = new ArrayList<String>();
        String[] stringArray = this.lore;
        int n = this.lore.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            lore.add(ChatColor.GRAY + ChatColor.translateAlternateColorCodes((char)'&', (String)s));
            ++n2;
        }
        meta.setLore(lore);
        item.setItemMeta((ItemMeta)meta);
        return NBTItem.get(item).addTag(new ItemTag("creeperEggId", this.getId())).toItem();
    }

    protected EggRecipe generateNewRecipe() {
        return new EggRecipe(this);
    }
}

