/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.creepereggs;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import net.Indyuce.creepereggs.ConfigData;
import net.Indyuce.creepereggs.api.CreeperEgg;
import net.Indyuce.creepereggs.command.MainCommand;
import net.Indyuce.creepereggs.command.completion.MainCompletion;
import net.Indyuce.creepereggs.comp.CreeperPlaceholders;
import net.Indyuce.creepereggs.comp.Metrics;
import net.Indyuce.creepereggs.comp.silkspawners.SilkSpawnerHandler;
import net.Indyuce.creepereggs.comp.silkspawners.SpawnerHandler;
import net.Indyuce.creepereggs.comp.silkspawners.VanillaSpawnerHandler;
import net.Indyuce.creepereggs.comp.worldguard.WGPlugin;
import net.Indyuce.creepereggs.comp.worldguard.WorldGuardOff;
import net.Indyuce.creepereggs.comp.worldguard.WorldGuardOn;
import net.Indyuce.creepereggs.gui.listener.GuiListener;
import net.Indyuce.creepereggs.listener.CancelRenaming;
import net.Indyuce.creepereggs.listener.CreeperListener;
import net.Indyuce.creepereggs.listener.CustomCreeperDrops;
import net.Indyuce.creepereggs.listener.PlayerListener;
import net.Indyuce.creepereggs.listener.VanillaCreeperDrops;
import net.Indyuce.creepereggs.manager.EggsManager;
import net.Indyuce.creepereggs.version.ServerVersion;
import net.Indyuce.creepereggs.version.SpigotPlugin;
import net.Indyuce.creepereggs.version.wrapper.VersionWrapper;
import net.Indyuce.creepereggs.version.wrapper.VersionWrapper_Reflection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PremiumCreeperEggs
extends JavaPlugin {
    private static PremiumCreeperEggs plugin;
    private ServerVersion version;
    private VersionWrapper nms;
    private WGPlugin wgPlugin;
    private SpawnerHandler spawnerHandler;
    private FileConfiguration eggs;
    private FileConfiguration drops;
    private EggsManager eggManager;

    public void onLoad() {
        plugin = this;
        this.version = new ServerVersion(Bukkit.getServer().getClass());
        this.eggManager = new EggsManager();
        this.wgPlugin = this.getServer().getPluginManager().getPlugin("WorldGuard") == null ? new WorldGuardOff() : new WorldGuardOn();
    }

    public void onEnable() {
        new SpigotPlugin(62669, this).checkForUpdate();
        try {
            this.getLogger().log(Level.INFO, "Detected Bukkit Version: " + this.version.toString());
            this.nms = (VersionWrapper)Class.forName("net.Indyuce.creepereggs.version.wrapper.NMSHandler_" + this.version.toString().substring(1)).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.getLogger().log(Level.SEVERE, "Your server version is handled via reflection");
            this.nms = new VersionWrapper_Reflection();
        }
        new Metrics(this);
        FileConfiguration eggs = ConfigData.getCD((Plugin)this, "", "eggs");
        for (CreeperEgg egg : this.getEggs().getAll()) {
            if (!eggs.contains(egg.getId())) {
                eggs.set(String.valueOf(egg.getId()) + ".name", (Object)egg.getName());
                eggs.set(String.valueOf(egg.getId()) + ".creeper-name", (Object)egg.getCreeperName());
                eggs.set(String.valueOf(egg.getId()) + ".lore", this.prepareLore(egg.getLore()));
                for (String s : egg.getModifiers()) {
                    eggs.set(String.valueOf(egg.getId()) + "." + s, (Object)egg.getValue(s));
                }
                if (egg.hasRecipe()) {
                    eggs.set(String.valueOf(egg.getId()) + ".craft", egg.getRecipe().getFormattedRecipe());
                    eggs.set(String.valueOf(egg.getId()) + ".craft-enabled", (Object)true);
                }
            }
            egg.update(eggs.getConfigurationSection(egg.getId()));
        }
        ConfigData.saveCD((Plugin)this, eggs, "", "eggs");
        this.saveDefaultConfig();
        this.saveDefaultFile("drops");
        this.reloadConfigFiles();
        for (CreeperEgg egg : PremiumCreeperEggs.getInstance().getEggs().getAll()) {
            if (!egg.hasRecipe() || !egg.isRecipeEnabled()) continue;
            ShapedRecipe recipe = egg.getRecipe().toShapedRecipe();
            if (recipe == null) {
                this.getLogger().log(Level.WARNING, "Couldn't register crafting recipe of " + egg.getId());
                continue;
            }
            Bukkit.addRecipe((Recipe)recipe);
        }
        Bukkit.getPluginManager().registerEvents((Listener)new CreeperListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GuiListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        if (this.drops.getBoolean("enable-drops.custom-creeper")) {
            Bukkit.getPluginManager().registerEvents((Listener)new CustomCreeperDrops(), (Plugin)this);
        }
        if (this.drops.getBoolean("enable-drops.vanilla-creeper")) {
            Bukkit.getPluginManager().registerEvents((Listener)new VanillaCreeperDrops(), (Plugin)this);
        }
        if (this.getConfig().getBoolean("cancel-renaming")) {
            Bukkit.getPluginManager().registerEvents((Listener)new CancelRenaming(), (Plugin)this);
        }
        SpawnerHandler spawnerHandler = this.spawnerHandler = this.getServer().getPluginManager().getPlugin("SilkSpawners") != null ? new SilkSpawnerHandler() : new VanillaSpawnerHandler();
        if (this.spawnerHandler instanceof SilkSpawnerHandler) {
            this.getLogger().log(Level.INFO, "Hooked onto SilkSpawners");
        }
        if (this.wgPlugin instanceof WorldGuardOn) {
            this.getLogger().log(Level.INFO, "Hooked onto WorldGuard");
        }
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new CreeperPlaceholders().register();
            this.getLogger().log(Level.INFO, "Hooked onto PlaceholderAPI");
        }
        this.getCommand("premiumcreepereggs").setExecutor((CommandExecutor)new MainCommand());
        this.getCommand("premiumcreepereggs").setTabCompleter((TabCompleter)new MainCompletion());
    }

    public static PremiumCreeperEggs getInstance() {
        return plugin;
    }

    public File getJarFile() {
        return this.getFile();
    }

    public EggsManager getEggs() {
        return this.eggManager;
    }

    public VersionWrapper getVersionWrapper() {
        return this.nms;
    }

    public ServerVersion getVersion() {
        return this.version;
    }

    public WGPlugin getWorldGuard() {
        return this.wgPlugin;
    }

    public SpawnerHandler getSpawners() {
        return this.spawnerHandler;
    }

    public FileConfiguration getEggsConfig() {
        return this.eggs;
    }

    public FileConfiguration getDropsConfig() {
        return this.drops;
    }

    public String getMessage(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)PremiumCreeperEggs.getInstance().getConfig().getString("message." + path));
    }

    public boolean isBlacklisted(Material material) {
        return PremiumCreeperEggs.getInstance().getConfig().getStringList("block-blacklist").contains(material.name());
    }

    private void saveDefaultFile(String path) {
        try {
            File file = new File(this.getDataFolder(), String.valueOf(path) + ".yml");
            if (!file.exists()) {
                Files.copy(this.getResource("default/" + path + ".yml"), file.getAbsoluteFile().toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reloadConfigFiles() {
        this.eggs = ConfigData.getCD((Plugin)this, "", "eggs");
        this.drops = ConfigData.getCD((Plugin)this, "", "drops");
    }

    public boolean hasDisplayName(ItemStack item) {
        if (item != null && item.hasItemMeta()) {
            return item.getItemMeta().hasDisplayName();
        }
        return false;
    }

    public List<String> prepareLore(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("&8&m------------------------------");
        list.addAll(Arrays.asList(array));
        list.add("&8&m------------------------------");
        list.add("&8&l[&a&l*&8&l] &7Right-click to use!");
        return list;
    }
}

