/*
 * Decompiled with CFR 0.152.
 */
package com.gamepathics.Managers;

import com.gamepathics.Interfaces.IOre;
import com.gamepathics.Main.Main;
import com.gamepathics.Managers.MessageManager;
import com.gamepathics.Ores.EnderOre;
import com.gamepathics.Ores.FireOre;
import com.gamepathics.Ores.FlightOre;
import com.gamepathics.Ores.FreezeOre;
import com.gamepathics.Ores.LightningOre;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class WorldManager
implements Listener {
    static Main plugin = (Main)Main.getPlugin(Main.class);
    static ArrayList<IOre> oresGenerated = new ArrayList();
    static ArrayList<IOre> allOres = new ArrayList();
    static int oreCount = 0;
    private static File oresFile = new File(plugin.getDataFolder(), "ores.yml");
    private static FileConfiguration file = YamlConfiguration.loadConfiguration((File)oresFile);

    public WorldManager() {
        allOres.add(new EnderOre());
        allOres.add(new FireOre());
        allOres.add(new FlightOre());
        allOres.add(new FreezeOre());
        allOres.add(new LightningOre());
        WorldManager.loadOres();
    }

    @EventHandler
    public void BlockBreakEvent(BlockBreakEvent e) {
        Player pl = e.getPlayer();
        block0: for (IOre ore : allOres) {
            if (!e.getBlock().getType().toString().contains(ore.getOre().getType().toString())) continue;
            int i = 0;
            while (i < oresGenerated.size()) {
                if (oresGenerated.get(i).getLocation().distance(e.getBlock().getLocation()) < 1.5) {
                    if (pl.hasPermission("powerfulores.ore.break")) {
                        e.setDropItems(false);
                        e.getBlock().getWorld().dropItemNaturally(oresGenerated.get(i).getLocation(), oresGenerated.get(i).getItemToDrop());
                        oresGenerated.remove(i);
                        WorldManager.saveOres();
                        continue block0;
                    }
                    e.setCancelled(true);
                    this.dontHavePerms(e.getPlayer());
                    continue block0;
                }
                ++i;
            }
        }
    }

    @EventHandler
    public void OnPlaceBlock(BlockPlaceEvent e) {
        block20: {
            if (!e.getItemInHand().hasItemMeta()) break block20;
            for (IOre ore : allOres) {
                block21: {
                    if (!e.getItemInHand().getItemMeta().getDisplayName().equals(ore.getOreName())) continue;
                    if (!e.getPlayer().hasPermission("powerfulores.ore.place")) break block21;
                    IOre newOre = null;
                    switch (ore.getOreName()) {
                        case "\u00a72Ender Ore": {
                            newOre = new EnderOre();
                            break;
                        }
                        case "\u00a78Flight Ore": {
                            newOre = new FlightOre();
                            break;
                        }
                        case "\u00a79Freeze Ore": {
                            newOre = new FreezeOre();
                            break;
                        }
                        case "\u00a7cFire Ore": {
                            newOre = new FireOre();
                            break;
                        }
                        case "\u00a7bLightning Ore": {
                            newOre = new LightningOre();
                        }
                    }
                    newOre.setLocation(e.getBlockPlaced().getLocation());
                    oresGenerated.add(newOre);
                    WorldManager.saveOres();
                    continue;
                }
                e.setCancelled(true);
                this.dontHavePerms(e.getPlayer());
            }
        }
    }

    public static void generateOre(World w) {
        int maxBlocks = 400;
        int minBlocks = 40;
        ArrayList playerList = new ArrayList(Bukkit.getOnlinePlayers());
        for (Player p : playerList) {
            int randomChoise = new Random().nextInt(5);
            IOre ore = null;
            switch (randomChoise) {
                case 0: {
                    ore = new EnderOre();
                    break;
                }
                case 1: {
                    ore = new FireOre();
                    break;
                }
                case 2: {
                    ore = new FlightOre();
                    break;
                }
                case 3: {
                    ore = new FreezeOre();
                    break;
                }
                case 4: {
                    ore = new LightningOre();
                    break;
                }
            }
            int randomX = new Random().nextInt(maxBlocks - minBlocks + 1) + minBlocks;
            int randomZ = new Random().nextInt(maxBlocks - minBlocks + 1) + minBlocks;
            double orePosX = p.getLocation().getX() + (double)randomX;
            double orePosZ = p.getLocation().getZ() + (double)randomZ;
            Location spawnLoc = new Location(w, orePosX, 5.0, orePosZ);
            ++oreCount;
            ore.setLocation(spawnLoc);
            oresGenerated.add(ore);
            w.getBlockAt(spawnLoc).setType(ore.getOreMaterial());
            WorldManager.saveOres();
        }
    }

    public static void saveOres() {
        int counter = 0;
        Map configValues = file.getValues(false);
        for (Map.Entry entry : configValues.entrySet()) {
            file.set((String)entry.getKey(), null);
            WorldManager.saveData(file, oresFile);
        }
        for (IOre ore : oresGenerated) {
            file.set(String.valueOf(++counter) + "." + ore.getOreName(), (Object)ore.getLocation());
        }
        oreCount = counter;
        WorldManager.saveData(file, oresFile);
    }

    public static void loadOres() {
        int counter = 1;
        while (file.getString(String.valueOf(counter) + "." + "\u00a7cFire Ore") != null || file.getString(String.valueOf(counter) + "." + "\u00a78Flight Ore") != null || file.getString(String.valueOf(counter) + "." + "\u00a79Freeze Ore") != null || file.getString(String.valueOf(counter) + "." + "\u00a72Ender Ore") != null || file.getString(String.valueOf(counter) + "." + "\u00a7bLightning Ore") != null) {
            Location spawnLoc;
            IOre ore;
            if (file.getString(String.valueOf(counter) + "." + "\u00a7cFire Ore") != null) {
                ore = new FireOre();
                spawnLoc = (Location)file.get(String.valueOf(counter) + "." + "\u00a7cFire Ore");
                ((FireOre)ore).setLocation(spawnLoc);
                oresGenerated.add(ore);
                ((World)Bukkit.getWorlds().get(0)).getBlockAt(spawnLoc).setType(((FireOre)ore).getOreMaterial());
            } else if (file.getString(String.valueOf(counter) + "." + "\u00a78Flight Ore") != null) {
                ore = new FlightOre();
                spawnLoc = (Location)file.get(String.valueOf(counter) + "." + "\u00a78Flight Ore");
                ((FlightOre)ore).setLocation(spawnLoc);
                oresGenerated.add(ore);
                ((World)Bukkit.getWorlds().get(0)).getBlockAt(spawnLoc).setType(((FlightOre)ore).getOreMaterial());
            } else if (file.getString(String.valueOf(counter) + "." + "\u00a79Freeze Ore") != null) {
                ore = new FreezeOre();
                spawnLoc = (Location)file.get(String.valueOf(counter) + "." + "\u00a79Freeze Ore");
                ((FreezeOre)ore).setLocation(spawnLoc);
                oresGenerated.add(ore);
                ((World)Bukkit.getWorlds().get(0)).getBlockAt(spawnLoc).setType(((FreezeOre)ore).getOreMaterial());
            } else if (file.getString(String.valueOf(counter) + "." + "\u00a72Ender Ore") != null) {
                ore = new EnderOre();
                spawnLoc = (Location)file.get(String.valueOf(counter) + "." + "\u00a72Ender Ore");
                ((EnderOre)ore).setLocation(spawnLoc);
                oresGenerated.add(ore);
                ((World)Bukkit.getWorlds().get(0)).getBlockAt(spawnLoc).setType(((EnderOre)ore).getOreMaterial());
            } else if (file.getString(String.valueOf(counter) + "." + "\u00a7bLightning Ore") != null) {
                ore = new LightningOre();
                spawnLoc = (Location)file.get(String.valueOf(counter) + "." + "\u00a7bLightning Ore");
                ((LightningOre)ore).setLocation(spawnLoc);
                oresGenerated.add(ore);
                ((World)Bukkit.getWorlds().get(0)).getBlockAt(spawnLoc).setType(((LightningOre)ore).getOreMaterial());
            }
            ++counter;
        }
        oreCount = counter;
    }

    public static void saveData(FileConfiguration ymlConfig, File ymlFile) {
        try {
            ymlConfig.save(ymlFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dontHavePerms(Player player) {
        player.sendMessage(MessageManager.dontHavePerms);
    }
}

