/*
 * Decompiled with CFR 0.152.
 */
package com.gamepathics.Managers;

import com.gamepathics.Managers.MessageManager;
import com.gamepathics.Ores.EnderOre;
import com.gamepathics.Ores.FireOre;
import com.gamepathics.Ores.FlightOre;
import com.gamepathics.Ores.FreezeOre;
import com.gamepathics.Ores.LightningOre;
import com.gamepathics.Sticks.EnderStick;
import com.gamepathics.Sticks.FireStick;
import com.gamepathics.Sticks.FlightStick;
import com.gamepathics.Sticks.FreezeStick;
import com.gamepathics.Sticks.LightningStick;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandManager
implements CommandExecutor {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command cmd, String cmdString, String[] args) {
        if (!(sender instanceof Player)) return true;
        Player player = (Player)sender;
        if (!player.hasPermission("powerfulores.commands")) {
            this.dontHavePerms(player);
            return true;
        }
        if (!cmd.getName().equalsIgnoreCase("powerfulores")) {
            this.helpCommand(player);
            return true;
        }
        if (args.length <= 0) {
            this.helpCommand(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("give")) {
            if (!player.hasPermission("powerfulores.command.give")) {
                this.dontHavePerms(player);
                return true;
            }
            if (args.length <= 1) {
                this.commandNotFound(player);
                return true;
            }
            if (args[1].equalsIgnoreCase("ore")) {
                if (args.length <= 2) {
                    this.commandNotFound(player);
                    return true;
                }
                if (args.length <= 3) {
                    this.giveOre(args, player, player);
                    return true;
                }
                if (Bukkit.getServer().getPlayer(args[3]) != null) {
                    Player otherPlayer = Bukkit.getServer().getPlayer(args[3]);
                    this.giveOre(args, player, otherPlayer);
                    return true;
                }
                this.playerNotFound(player);
                return true;
            }
            if (!args[1].equalsIgnoreCase("stick")) {
                this.commandNotFound(player);
                return true;
            }
            if (args.length <= 2) {
                this.commandNotFound(player);
                return true;
            }
            if (args.length <= 3) {
                this.giveStick(args, player, player);
                return true;
            }
            if (Bukkit.getServer().getPlayer(args[3]) != null) {
                Player otherPlayer = Bukkit.getServer().getPlayer(args[3]);
                this.giveStick(args, player, otherPlayer);
                return true;
            }
            this.playerNotFound(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            this.helpCommand(player);
            return true;
        }
        if (!player.hasPermission("powerfulores.command.lists")) {
            this.dontHavePerms(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("orelist")) {
            this.oreListCommand(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("sticklist")) {
            this.stickListCommand(player);
            return true;
        }
        this.commandNotFound(player);
        return true;
    }

    public boolean giveOre(String[] args, Player player, Player otherPlayer) {
        switch (args[2].toLowerCase()) {
            case "ender": {
                EnderOre o = new EnderOre();
                otherPlayer.getInventory().addItem(new ItemStack[]{o.getOre()});
                player.sendMessage("\u00a7a[PowerfulOres] \u00a73" + o.getOreName() + " \u00a73gived to " + otherPlayer.getName());
                return true;
            }
            case "freeze": {
                FreezeOre f = new FreezeOre();
                otherPlayer.getInventory().addItem(new ItemStack[]{f.getOre()});
                player.sendMessage("\u00a7a[PowerfulOres] \u00a73" + f.getOreName() + " \u00a73gived to " + otherPlayer.getName());
                return true;
            }
            case "flight": {
                FlightOre fl = new FlightOre();
                otherPlayer.getInventory().addItem(new ItemStack[]{fl.getOre()});
                player.sendMessage("\u00a7a[PowerfulOres] \u00a73" + fl.getOreName() + " \u00a73gived to " + otherPlayer.getName());
                return true;
            }
            case "fire": {
                FireOre fi = new FireOre();
                otherPlayer.getInventory().addItem(new ItemStack[]{fi.getOre()});
                player.sendMessage("\u00a7a[PowerfulOres] \u00a73" + fi.getOreName() + " \u00a73gived to " + otherPlayer.getName());
                return true;
            }
            case "lightning": {
                LightningOre l = new LightningOre();
                otherPlayer.getInventory().addItem(new ItemStack[]{l.getOre()});
                player.sendMessage("\u00a7a[PowerfulOres] \u00a73" + l.getOreName() + " \u00a73gived to " + otherPlayer.getName());
                return true;
            }
        }
        player.sendMessage(MessageManager.oreDoesNotExist);
        return false;
    }

    public boolean giveStick(String[] args, Player player, Player otherPlayer) {
        switch (args[2].toLowerCase()) {
            case "ender": {
                EnderStick o = new EnderStick();
                otherPlayer.getInventory().addItem(new ItemStack[]{o.getStick()});
                player.sendMessage("\u00a7a[PowerfulOres] \u00a73" + o.getStickName() + " \u00a73gived to " + otherPlayer.getName());
                return true;
            }
            case "freeze": {
                FreezeStick f = new FreezeStick();
                otherPlayer.getInventory().addItem(new ItemStack[]{f.getStick()});
                player.sendMessage("\u00a7a[PowerfulOres] \u00a73" + f.getStickName() + " \u00a73gived to " + otherPlayer.getName());
                return true;
            }
            case "flight": {
                FlightStick fl = new FlightStick();
                otherPlayer.getInventory().addItem(new ItemStack[]{fl.getStick()});
                player.sendMessage("\u00a7a[PowerfulOres] \u00a73" + fl.getStickName() + " \u00a73gived to " + otherPlayer.getName());
                return true;
            }
            case "fire": {
                FireStick fi = new FireStick();
                otherPlayer.getInventory().addItem(new ItemStack[]{fi.getStick()});
                player.sendMessage("\u00a7a[PowerfulOres] \u00a73" + fi.getStickName() + " \u00a73gived to " + otherPlayer.getName());
                return true;
            }
            case "lightning": {
                LightningStick l = new LightningStick();
                otherPlayer.getInventory().addItem(new ItemStack[]{l.getStick()});
                player.sendMessage("\u00a7a[PowerfulOres] \u00a73" + l.getStickName() + " \u00a73gived to " + otherPlayer.getName());
                return true;
            }
        }
        player.sendMessage(MessageManager.stickDoesNotExist);
        return false;
    }

    public void commandNotFound(Player player) {
        player.sendMessage(MessageManager.commandNotFound);
    }

    public void helpCommand(Player player) {
        player.sendMessage("\u00a73==============================================\n\u00a73||                           \u00a7aPOWERFUL ORES                     \u00a73||\n==============================================\n\u00a7b/powerfulores help \u00a73- plugin commands\n\u00a7b/powerfulores orelist \u00a73- get a list of all ores\n\u00a7b/powerfulores sticklist \u00a73- get a list of all sticks\n\u00a7b/powerfulores give ore [ore name] [player] \u00a73- get a specified ore\n\u00a7b/powerfulores give stick [stick name] [player]\u00a73- get a specified stick\n");
    }

    public void oreListCommand(Player player) {
        player.sendMessage(MessageManager.oreListCommand);
    }

    public void stickListCommand(Player player) {
        player.sendMessage(MessageManager.stickListCommand);
    }

    public void playerNotFound(Player player) {
        player.sendMessage(MessageManager.playerNotFound);
    }

    public void dontHavePerms(Player player) {
        player.sendMessage(MessageManager.dontHavePerms);
    }
}

