/*
 * Decompiled with CFR 0.152.
 */
package eu.taigacraft.powerperms.addon.wildcards;

import eu.taigacraft.core.Logger;
import eu.taigacraft.core.Plugin;
import eu.taigacraft.core.TaigaPlugin;
import eu.taigacraft.core.update.UpdateChecker;
import eu.taigacraft.powerperms.addon.wildcards.PowerPermsPermissible;
import java.lang.reflect.Field;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private Field perm;
    Logger logger;
    private UpdateChecker updater;

    public void onEnable() {
        this.updater = new UpdateChecker("powerperms.notify", null, (JavaPlugin)this, null, Plugin.POWERPERMS_WILDCARDS, false);
        String craftserver = this.getServer().getClass().getPackage().getName();
        String version = craftserver.substring(craftserver.lastIndexOf(46) + 1);
        String pack = "org.bukkit.craftbukkit." + version + ".entity.";
        this.logger = ((TaigaPlugin)this.getServer().getPluginManager().getPlugin((String)"PowerPerms")).logger;
        this.logger.info("Using package " + pack);
        try {
            this.perm = Class.forName(pack + "CraftHumanEntity").getDeclaredField("perm");
        }
        catch (NoSuchFieldException e) {
            this.logger.error("Couldn't get field", (Throwable)e);
            return;
        }
        catch (SecurityException e) {
            this.logger.error("Security issue", (Throwable)e);
            return;
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Couldn't get class", (Throwable)e);
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.onPlayerJoin(new PlayerJoinEvent(player, ""));
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (org.bukkit.plugin.Plugin)this);
        this.logger.info("PowerPerms Wildcards v1.0 has been enabled.");
    }

    public void onDisable() {
        this.updater.cancel();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.onPlayerQuit(new PlayerQuitEvent(player, ""));
        }
        this.logger.info("PowerPerms Wildcards v1.0 has been disabled.");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        try {
            this.perm.setAccessible(true);
            this.perm.set(event.getPlayer(), (Object)new PowerPermsPermissible((ServerOperator)event.getPlayer()));
            this.perm.setAccessible(false);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Illegal argument", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Illegal access", (Throwable)e);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        try {
            this.perm.setAccessible(true);
            this.perm.set(event.getPlayer(), new PermissibleBase((ServerOperator)event.getPlayer()));
            this.perm.setAccessible(false);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Illegal argument", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Illegal access", (Throwable)e);
        }
    }
}

