/*
 * Decompiled with CFR 0.152.
 */
package me.ford.potionstacker;

import me.ford.potionstacker.InventoryListener;
import me.ford.potionstacker.ReflectionUtil;
import me.ford.potionstacker.ReloadCommand;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PotionStacker
extends JavaPlugin {
    private int stackPotion;
    private int stackSplash;
    private InventoryListener listener = null;

    public void onEnable() {
        this.loadConfiguration();
        this.changePotionStackSizes();
        this.getCommand("potionstackerreload").setExecutor((CommandExecutor)new ReloadCommand(this));
    }

    public void loadConfiguration() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.stackPotion = this.getConfig().getInt("potion");
        this.stackSplash = this.getConfig().getInt("splash-potion");
        if (this.stackPotion != 1 || this.stackSplash != 1) {
            if (this.listener == null) {
                this.listener = new InventoryListener(this, this.stackPotion, this.stackSplash);
                this.getServer().getPluginManager().registerEvents((Listener)this.listener, (Plugin)this);
            } else {
                this.listener.setStacks(this.stackPotion, this.stackSplash);
            }
        } else if (this.listener != null) {
            HandlerList.unregisterAll((Listener)this.listener);
            this.listener = null;
        }
    }

    public void reload() {
        this.reloadConfig();
        this.loadConfiguration();
        this.changePotionStackSizes();
    }

    private void changePotionStackSizes() {
        String potionName = "POTION";
        boolean potionReg = ReflectionUtil.setFor(potionName, this.stackPotion);
        boolean potionNMS = ReflectionUtil.setForNMS("POTION", this.stackPotion);
        if (potionReg && potionNMS) {
            this.getLogger().info("Set the maxStack size of " + potionName + " to " + this.stackPotion);
        } else {
            this.getLogger().warning("Problem setting maxStack size of " + potionName + ".\norg.bukkit.Material:" + (potionReg ? "WORKED" : "FAILED") + "\nNMS.Items:" + (potionNMS ? "WORKED" : "FAILED"));
        }
        String splashPotionName = "SPLASH_POTION";
        boolean splashReg = ReflectionUtil.setFor(splashPotionName, this.stackSplash);
        boolean splashNMS = ReflectionUtil.setForNMS(splashPotionName, this.stackSplash);
        if (splashReg && splashNMS) {
            this.getLogger().info("Set the maxStack size of (NMS)" + splashPotionName + " to " + this.stackSplash);
        } else {
            this.getLogger().warning("Problem setting maxStack size of " + splashPotionName + ".\norg.bukkit.Material:" + (splashReg ? "WORKED" : "FAILED") + "\nNMS.Items:" + (splashNMS ? "WORKED" : "FAILED"));
            this.getLogger().info("The above warning is normal when on 1.8");
        }
    }
}

