/*
 * Decompiled with CFR 0.152.
 */
package me.ford.potionstacker;

import java.util.EnumSet;
import me.ford.potionstacker.PotionStacker;
import me.ford.potionstacker.ReflectionUtil;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InventoryListener
implements Listener {
    private final PotionStacker stacker;
    private EnumSet<Material> potions;
    public int stackPotion;
    public int stackSplash;
    boolean lookPotion;
    boolean lookSplash;
    private final Material POTION;
    private final Material SPLASH_POTION;

    public InventoryListener(PotionStacker plugin, int potion, int splash) {
        this.stacker = plugin;
        this.stackPotion = potion;
        this.stackSplash = splash;
        this.POTION = Material.POTION;
        this.SPLASH_POTION = Material.matchMaterial((String)"SPLASH_POTION");
        this.setupLook();
    }

    private void setupLook() {
        this.lookPotion = this.stackPotion > 1;
        boolean bl = this.lookSplash = this.stackSplash > 1;
        this.potions = this.lookPotion && this.lookSplash ? (this.SPLASH_POTION != null ? EnumSet.of(this.POTION, this.SPLASH_POTION) : EnumSet.of(this.POTION)) : (this.lookPotion ? EnumSet.of(this.POTION) : EnumSet.of(this.SPLASH_POTION));
    }

    public void setStacks(int potion, int splash) {
        this.stackPotion = potion;
        this.stackSplash = splash;
        this.setupLook();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryAction action = event.getAction();
        if (action == InventoryAction.CLONE_STACK || action == InventoryAction.HOTBAR_SWAP || action == InventoryAction.NOTHING) {
            return;
        }
        this.handleInventoryInteractEvent((InventoryInteractEvent)event, event.getCurrentItem(), event.getCursor());
    }

    @EventHandler
    public void onIventoryDrag(InventoryDragEvent event) {
        this.handleInventoryInteractEvent((InventoryInteractEvent)event, event.getOldCursor(), event.getCursor());
    }

    @EventHandler
    public void onInventoryCreative(InventoryCreativeEvent event) {
        this.handleInventoryInteractEvent((InventoryInteractEvent)event, event.getCurrentItem(), event.getCursor());
    }

    private void handleInventoryInteractEvent(InventoryInteractEvent event, ItemStack stack, ItemStack alt) {
        ItemStack cur = stack == null || stack.getType() == Material.AIR ? alt : stack;
        if (cur == null || !this.potions.contains(cur.getType())) {
            return;
        }
        this.stacker.getServer().getScheduler().runTask((Plugin)this.stacker, () -> ReflectionUtil.updateInventory((Player)event.getWhoClicked()));
    }
}

