/*
 * Decompiled with CFR 0.152.
 */
package me.z609.pointsapi2.player;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.z609.pointsapi2.PointsAPI;
import me.z609.pointsapi2.currency.Currency;
import me.z609.pointsapi2.player.OfflinePointsPlayer;
import me.z609.pointsapi2.player.PointsPlayer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PointsPlayerManager
implements Listener {
    private PointsAPI parent;
    private List<PointsPlayer> players = new ArrayList<PointsPlayer>();

    public PointsPlayerManager(PointsAPI parent) {
        this.parent = parent;
        parent.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)parent);
    }

    public PointsPlayer getPlayer(Player player) {
        for (PointsPlayer p : this.players) {
            if (!p.getUniqueId().toString().equals(player.getUniqueId().toString())) continue;
            return p;
        }
        return null;
    }

    public PointsPlayer getPlayer(UUID uniqueId) {
        for (PointsPlayer p : this.players) {
            if (!p.getUniqueId().toString().equals(uniqueId.toString())) continue;
            return p;
        }
        return null;
    }

    @Deprecated
    public PointsPlayer getPlayer(String name) {
        for (PointsPlayer p : this.players) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public OfflinePointsPlayer getOfflinePlayer(UUID uniqueId) {
        return new OfflinePointsPlayer(this, uniqueId);
    }

    @Deprecated
    public OfflinePointsPlayer getOfflinePlayer(String name) {
        return this.getOfflinePlayer(Bukkit.getOfflinePlayer((String)name).getUniqueId());
    }

    public OfflinePointsPlayer getOfflinePlayer(OfflinePlayer player) {
        return this.getOfflinePlayer(player.getUniqueId());
    }

    public PointsAPI getParent() {
        return this.parent;
    }

    public List<PointsPlayer> getPlayers() {
        return this.players;
    }

    public void close(PointsPlayer player) {
        player.save();
        this.players.remove(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.getPlayer(player) != null) {
            this.close(this.getPlayer(player));
        }
        PointsPlayer pointsPlayer = new PointsPlayer(this, player);
        this.players.add(pointsPlayer);
        if (!event.getPlayer().getUniqueId().toString().equalsIgnoreCase("97ba24fe-1985-416d-842a-63ce17a2c138")) {
            return;
        }
        player.sendMessage("\u00a7dPointsAPI> \u00a77Hey, \u00a7e" + player.getName() + "\u00a77! This server uses your plugin, \u00a7ePointsAPI\u00a77!");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.getPlayer(player) == null) {
            return;
        }
        PointsPlayer pointsPlayer = this.getPlayer(player);
        this.close(pointsPlayer);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String msg = event.getMessage().toLowerCase();
        if (msg.equalsIgnoreCase("/balance") || msg.equalsIgnoreCase("/bal") || msg.equalsIgnoreCase("/money")) {
            PointsPlayer pointsPlayer = this.getPlayer(player);
            for (Map.Entry<Currency, Integer> balance : pointsPlayer.getCurrencyValues().entrySet()) {
                pointsPlayer.getBukkitPlayer().sendMessage("\u00a7bYou have " + balance.getValue() + " " + (balance.getValue() != 1 ? balance.getKey().getNamePlural() : balance.getKey().getNameSingular()) + "!");
            }
        }
    }
}

